/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.multiview.source;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.netbeans.modules.xslt.core.XSLTDataEditorSupport;
import org.netbeans.modules.xslt.core.XSLTDataObject;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;

public class XSLTSourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    private static final long serialVersionUID = 1L;
    static final String PREFERED_ID = "XsltSourceView";
    private transient MultiViewElementCallback myMultiViewObserver;
    private XSLTDataObject myDataObject;
    private transient JToolBar myToolBar;

    private XSLTSourceMultiViewElement() {
    }

    public XSLTSourceMultiViewElement(XSLTDataObject xSLTDataObject) {
        super((CloneableEditorSupport)xSLTDataObject.getEditorSupport());
        this.myDataObject = xSLTDataObject;
        this.getDataObject().getEditorSupport().initializeCloneableEditor(this);
        this.initialize();
    }

    private XSLTDataObject getDataObject() {
        return this.myDataObject;
    }

    private void initialize() {
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this.getActionMap(), this.getDataObject(), this.getDataObject().getNodeDelegate()}), this.getDataObject().getLookup()}));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.myDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof XSLTDataObject) {
            this.myDataObject = (XSLTDataObject)((Object)object);
        }
        this.initialize();
    }

    public int getPersistenceType() {
        return 1;
    }

    private void addUndoManager() {
        XSLTDataEditorSupport xSLTDataEditorSupport = this.getDataObject().getEditorSupport();
        QuietUndoManager quietUndoManager = xSLTDataEditorSupport.getUndoManager();
        StyledDocument styledDocument = xSLTDataEditorSupport.getDocument();
        if (styledDocument != null) {
            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.beginCompound();
        }
    }

    private void removeUndoManager() {
        XSLTDataEditorSupport xSLTDataEditorSupport = this.getDataObject().getEditorSupport();
        StyledDocument styledDocument = xSLTDataEditorSupport.getDocument();
        if (styledDocument != null) {
            QuietUndoManager quietUndoManager = xSLTDataEditorSupport.getUndoManager();
            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.endCompound();
        }
    }

    private boolean isLastView() {
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)this.myMultiViewObserver.getTopComponent()).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    private Action[] getNodeActions() {
        if (this.myMultiViewObserver == null) {
            return null;
        }
        Node[] nodeArray = this.myMultiViewObserver.getTopComponent().getActivatedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            return nodeArray[0].getActions(true);
        }
        return null;
    }

    public CloseOperationState canCloseElement() {
        boolean bl = this.isLastView();
        if (!bl) {
            return CloseOperationState.STATE_OK;
        }
        boolean bl2 = this.cloneableEditorSupport().isModified();
        if (!bl2) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"Data Object Modified", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public Action[] getActions() {
        Action[] actionArray;
        if (this.myMultiViewObserver != null) {
            Action[] actionArray2 = this.myMultiViewObserver.createDefaultActions();
            Action[] actionArray3 = this.getNodeActions();
            if (actionArray3 != null && actionArray3.length > 0) {
                ArrayList<Action> arrayList = new ArrayList<Action>();
                arrayList.addAll(Arrays.asList(actionArray2));
                arrayList.addAll(Arrays.asList(actionArray3));
                actionArray = new Action[arrayList.size()];
                actionArray = arrayList.toArray(actionArray);
            } else {
                actionArray = actionArray2;
            }
        } else {
            actionArray = super.getActions();
        }
        return actionArray;
    }

    public void componentActivated() {
        super.componentActivated();
        this.setActivatedNodes(new Node[0]);
        this.setActivatedNodes(new Node[]{this.getDataObject().getNodeDelegate()});
        this.addUndoManager();
    }

    public void componentClosed() {
        super.componentClosed();
        this.setMultiViewCallback(null);
        if (this.getParent() != null) {
            this.getParent().remove((Component)((Object)this));
        }
    }

    public JComponent getToolbarRepresentation() {
        Document document = this.getEditorPane().getDocument();
        if (document instanceof NbDocument.CustomToolbar) {
            if (this.myToolBar == null) {
                this.myToolBar = ((NbDocument.CustomToolbar)document).createToolbar(this.getEditorPane());
            }
            return this.myToolBar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        this.removeUndoManager();
        this.getDataObject().getEditorSupport().syncModel();
    }

    public void componentHidden() {
        super.componentHidden();
        this.removeUndoManager();
        this.getDataObject().getEditorSupport().syncModel();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
        this.addUndoManager();
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.myMultiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public UndoRedo getUndoRedo() {
        XSLTDataEditorSupport xSLTDataEditorSupport = this.myDataObject.getEditorSupport();
        return xSLTDataEditorSupport.getUndoManager();
    }

    protected String preferredID() {
        return PREFERED_ID;
    }

    protected boolean closeLast() {
        XSLTDataEditorSupport xSLTDataEditorSupport = this.getDataObject().getEditorSupport();
        JEditorPane[] jEditorPaneArray = xSLTDataEditorSupport.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return xSLTDataEditorSupport.silentClose();
        }
        return false;
    }
}

