/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.gsfret.InstantRenameAction;
import org.netbeans.modules.gsf.DeleteToNextCamelCasePosition;
import org.netbeans.modules.gsf.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.gsf.GsfDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.NextCamelCasePosition;
import org.netbeans.modules.gsf.PreviousCamelCasePosition;
import org.netbeans.modules.gsf.SelectCodeElementAction;
import org.netbeans.modules.gsf.SelectNextCamelCasePosition;
import org.netbeans.modules.gsf.SelectPreviousCamelCasePosition;
import org.netbeans.modules.gsf.api.BracketCompletion;
import org.netbeans.modules.gsf.api.EditorAction;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsfret.editor.fold.GsfFoldManager;
import org.netbeans.modules.gsfret.editor.hyperlink.GoToSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GsfEditorKitFactory {
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    Language language;
    String mimeType;

    public GsfEditorKitFactory(Language language) {
        assert (language != null);
        this.language = language;
        this.mimeType = language.getMimeType();
    }

    public GsfEditorKit kit() {
        return new GsfEditorKit();
    }

    public static Action findAction(Action[] actionArray, String string) {
        for (Action action : actionArray) {
            Object object = action.getValue("Name");
            if (!(object instanceof String) || !string.equals(object)) continue;
            return action;
        }
        return null;
    }

    static BracketCompletion getBracketCompletion(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (Language language : list) {
            if (language.getBracketCompletion() == null) continue;
            return language.getBracketCompletion();
        }
        return null;
    }

    private static boolean completionSettingEnabled() {
        return true;
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public CollapseAllCodeBlockFolds() {
            super(GsfEditorKitFactory.collapseAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(GsfEditorKitFactory.class).getString(GsfEditorKitFactory.collapseAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(GsfEditorKitFactory.class).getString("popup-collapse-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(GsfFoldManager.CODE_BLOCK_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public ExpandAllCodeBlockFolds() {
            super(GsfEditorKitFactory.expandAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(GsfEditorKitFactory.class).getString(GsfEditorKitFactory.expandAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(GsfEditorKitFactory.class).getString("popup-expand-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(GsfFoldManager.CODE_BLOCK_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    private class EditorActionWrapper
    extends BaseAction {
        EditorAction gotoAction;

        public EditorActionWrapper(EditorAction editorAction) {
            super(editorAction.getActionName(), 142);
            this.gotoAction = editorAction;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.gotoAction.actionPerformed(actionEvent, jTextComponent);
        }

        protected Class getShortDescriptionBundleClass() {
            return this.gotoAction.getShortDescriptionBundleClass();
        }
    }

    public class GsfEditorKit
    extends NbEditorKit {
        String mimeType;

        public GsfEditorKit() {
            this.mimeType = GsfEditorKitFactory.this.language.getMimeType();
            Settings.addInitializer((Settings.Initializer)new Settings.Initializer(){

                public String getName() {
                    return GsfEditorKit.this.mimeType;
                }

                public void updateSettingsMap(Class clazz, Map map) {
                    if (clazz != null && clazz.equals(GsfEditorKit.class)) {
                        map.put("code-folding-enable", Boolean.TRUE);
                    }
                }
            });
        }

        public String getContentType() {
            return GsfEditorKitFactory.this.language.getMimeType();
        }

        public Document createDefaultDocument() {
            GsfDocument gsfDocument = new GsfDocument(((Object)((Object)this)).getClass(), GsfEditorKitFactory.this.language);
            gsfDocument.putProperty("mimeType", this.mimeType);
            return gsfDocument;
        }

        public SyntaxSupport createSyntaxSupport(final BaseDocument baseDocument) {
            return new ExtSyntaxSupport(baseDocument){

                public int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
                    BracketCompletion bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)baseDocument, n);
                    if (bracketCompletion != null) {
                        OffsetRange offsetRange = bracketCompletion.findMatching((Document)this.getDocument(), n);
                        if (offsetRange == OffsetRange.NONE) {
                            return null;
                        }
                        return new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    }
                    return null;
                }
            };
        }

        protected void initDocument(BaseDocument baseDocument) {
            CodeTemplateManager.get((Document)baseDocument);
        }

        public Completion createCompletion(ExtEditorUI extEditorUI) {
            return null;
        }

        public Object clone() {
            return new GsfEditorKit();
        }

        protected Action[] createActions() {
            String string;
            Action[] actionArray = super.createActions();
            GsfLanguage gsfLanguage = GsfEditorKitFactory.this.language.getGsfLanguage();
            ArrayList<Object> arrayList = new ArrayList<Object>(30);
            arrayList.add((Object)new GsfDefaultKeyTypedAction());
            arrayList.add((Object)new GsfInsertBreakAction());
            arrayList.add((Object)new GsfDeleteCharAction("delete-previous", false));
            String string2 = string = gsfLanguage != null ? gsfLanguage.getLineCommentPrefix() : null;
            if (string != null) {
                arrayList.add(new ExtKit.CommentAction(string));
                arrayList.add(new ExtKit.UncommentAction(string));
                arrayList.add(new ExtKit.ToggleCommentAction(string));
            }
            Collection collection = Lookup.getDefault().lookupAll(EditorAction.class);
            for (EditorAction editorAction : collection) {
                arrayList.add((Object)new EditorActionWrapper(editorAction));
            }
            arrayList.add((Object)new InstantRenameAction());
            arrayList.add((Object)new GenericGoToDeclarationAction());
            arrayList.add((Object)new GenericGenerateGoToPopupAction());
            arrayList.add((Object)new SelectCodeElementAction("select-element-next", true));
            arrayList.add((Object)new SelectCodeElementAction("select-element-previous", false));
            arrayList.add((Object)new NextCamelCasePosition(GsfEditorKitFactory.findAction(actionArray, "caret-next-word")));
            arrayList.add((Object)new PreviousCamelCasePosition(GsfEditorKitFactory.findAction(actionArray, "caret-previous-word")));
            arrayList.add((Object)new SelectNextCamelCasePosition(GsfEditorKitFactory.findAction(actionArray, "selection-next-word")));
            arrayList.add((Object)new SelectPreviousCamelCasePosition(GsfEditorKitFactory.findAction(actionArray, "selection-previous-word")));
            arrayList.add((Object)new DeleteToNextCamelCasePosition(GsfEditorKitFactory.findAction(actionArray, "remove-word-next")));
            arrayList.add((Object)new DeleteToPreviousCamelCasePosition(GsfEditorKitFactory.findAction(actionArray, "remove-word-previous")));
            return TextAction.augmentList(actionArray, arrayList.toArray(new Action[arrayList.size()]));
        }

        private class GenericGenerateGoToPopupAction
        extends NbEditorKit.NbGenerateGoToPopupAction {
            private GenericGenerateGoToPopupAction() {
            }

            public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            }

            private void addAcceleretors(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
                Keymap keymap = jTextComponent.getKeymap();
                if (keymap != null) {
                    KeyStroke keyStroke;
                    KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
                    if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                        jMenuItem.setAccelerator(keyStrokeArray[0]);
                    } else if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                        jMenuItem.setAccelerator(keyStroke);
                    }
                }
            }

            private void addAction(JTextComponent jTextComponent, JMenu jMenu, Action action) {
                if (action != null) {
                    String string = (String)action.getValue("Name");
                    JMenuItem jMenuItem = null;
                    if (action instanceof BaseAction) {
                        jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                    }
                    if (jMenuItem == null) {
                        String string2 = (String)action.getValue("trimmed-text");
                        if (string2 == null) {
                            string2 = this.getItemText(jTextComponent, string, action);
                        }
                        if (string2 != null) {
                            jMenuItem = new JMenuItem(string2);
                            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string2);
                            jMenuItem.addActionListener(action);
                            this.addAcceleretors(action, jMenuItem, jTextComponent);
                            jMenuItem.setEnabled(action.isEnabled());
                            Object object = action.getValue("helpID");
                            if (object != null && object instanceof String) {
                                jMenuItem.putClientProperty("HelpID", object);
                            }
                        } else if ("goto-source".equals(string)) {
                            jMenuItem = new JMenuItem(NbBundle.getBundle(GsfEditorKit.class).getString("goto_source_open_source_not_formatted"));
                            this.addAcceleretors(action, jMenuItem, jTextComponent);
                            jMenuItem.setEnabled(false);
                        }
                    }
                    if (jMenuItem != null) {
                        jMenu.add(jMenuItem);
                    }
                }
            }

            private void addAction(JTextComponent jTextComponent, JMenu jMenu, String string) {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                if (baseKit == null) {
                    return;
                }
                Action action = baseKit.getActionByName(string);
                if (action != null) {
                    this.addAction(jTextComponent, jMenu, action);
                } else {
                    jMenu.addSeparator();
                }
            }

            private String getItemText(JTextComponent jTextComponent, String string, Action action) {
                String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
                return string2;
            }

            public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
                String string = NbBundle.getBundle(GsfEditorKit.class).getString("generate-goto-popup");
                JMenu jMenu = new JMenu(string);
                this.addAction(jTextComponent, jMenu, "goto-declaration");
                return jMenu;
            }
        }

        private class GenericGoToDeclarationAction
        extends ExtKit.GotoDeclarationAction {
            private GenericGoToDeclarationAction() {
            }

            public boolean gotoDeclaration(JTextComponent jTextComponent) {
                GoToSupport.performGoTo((Document)((BaseDocument)jTextComponent.getDocument()), jTextComponent.getCaretPosition());
                return true;
            }
        }

        public class GsfDeleteCharAction
        extends ExtKit.ExtDeleteCharAction {
            private JTextComponent currentTarget;

            public GsfDeleteCharAction(String string, boolean bl) {
                super(string, bl);
            }

            public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
                this.currentTarget = jTextComponent;
                super.actionPerformed(actionEvent, jTextComponent);
                this.currentTarget = null;
            }

            protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
                BracketCompletion bracketCompletion;
                if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)baseDocument, n)) != null) {
                    boolean bl = bracketCompletion.charBackspaced((Document)baseDocument, n, this.currentTarget, c);
                    return;
                }
                super.charBackspaced(baseDocument, n, caret, c);
            }
        }

        public class GsfInsertBreakAction
        extends BaseKit.InsertBreakAction {
            static final long serialVersionUID = -1506173310438326380L;

            protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
                BracketCompletion bracketCompletion;
                if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)baseDocument, caret.getDot())) != null) {
                    try {
                        int n = bracketCompletion.beforeBreak((Document)baseDocument, caret.getDot(), jTextComponent);
                        if (n >= 0) {
                            return new Integer(n);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
                return null;
            }

            protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
                if (GsfEditorKitFactory.completionSettingEnabled() && object != null && object instanceof Integer) {
                    int n = (Integer)object;
                    if (n != -1) {
                        caret.setDot(n);
                    } else {
                        int n2 = caret.getDot();
                        caret.setDot(n2 + 1);
                    }
                }
            }
        }

        public class GsfDefaultKeyTypedAction
        extends ExtKit.ExtDefaultKeyTypedAction {
            private JTextComponent currentTarget;

            public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
                this.currentTarget = jTextComponent;
                super.actionPerformed(actionEvent, jTextComponent);
                this.currentTarget = null;
            }

            protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
                BracketCompletion bracketCompletion;
                if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)baseDocument, n)) != null) {
                    boolean bl2 = bracketCompletion.beforeCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                    if (!bl2) {
                        super.insertString(baseDocument, n, caret, string, bl);
                        bl2 = bracketCompletion.afterCharInserted((Document)baseDocument, n, this.currentTarget, string.charAt(0));
                    }
                    return;
                }
                super.insertString(baseDocument, n, caret, string, bl);
            }

            protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
                char c = string.charAt(0);
                Document document = jTextComponent.getDocument();
                if (document instanceof BaseDocument) {
                    BracketCompletion bracketCompletion;
                    BaseDocument baseDocument = (BaseDocument)document;
                    if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)baseDocument, n)) != null) {
                        try {
                            int n2 = caret.getDot();
                            boolean bl2 = bracketCompletion.beforeCharInserted((Document)baseDocument, n2, jTextComponent, c);
                            int n3 = Math.min(caret.getDot(), caret.getMark());
                            int n4 = Math.max(caret.getDot(), caret.getMark());
                            if (n3 != n4) {
                                baseDocument.remove(n3, n4 - n3);
                            }
                            if (!bl2) {
                                if (string != null && string.length() > 0) {
                                    baseDocument.insertString(n3, string, null);
                                }
                                bracketCompletion.afterCharInserted((Document)baseDocument, caret.getDot() - 1, jTextComponent, c);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        return;
                    }
                }
                super.replaceSelection(jTextComponent, n, caret, string, bl);
            }
        }
    }
}

