/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.gsf.api.EditorOptions;
import org.netbeans.modules.gsf.api.EditorOptionsFactory;
import org.openide.util.Lookup;

public class GsfEditorOptionsFactory
implements EditorOptionsFactory {
    public EditorOptions get(String string) {
        return new GsfEditorOptions(string);
    }

    private class GsfEditorOptions
    extends EditorOptions {
        private String mimeType;
        private BaseOptions options;

        GsfEditorOptions(String string) {
            this.mimeType = string;
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
            this.options = (BaseOptions)lookup.lookup(BaseOptions.class);
        }

        public int getTabSize() {
            Object object = this.options.getSettingValue("tab-size");
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return 8;
        }

        public boolean getExpandTabs() {
            Object object = this.options.getSettingValue("expand-tabs");
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return true;
        }

        public int getSpacesPerTab() {
            Object object;
            if (this.options != null && (object = this.options.getSettingValue("spaces-per-tab")) instanceof Integer) {
                return (Integer)object;
            }
            return 2;
        }

        public boolean getMatchBrackets() {
            Object object;
            if (this.options != null && (object = this.options.getSettingValue("pair-characters-completion")) instanceof Boolean) {
                return (Boolean)object;
            }
            return true;
        }

        public int getRightMargin() {
            Object object;
            if (this.options != null && (object = this.options.getSettingValue("text-limit-width")) instanceof Integer) {
                return (Integer)object;
            }
            return 80;
        }
    }
}

