/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.editor.Settings;
import org.netbeans.modules.gsf.GsfEditorSettings;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfret.source.ActivatedDocumentListener;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifierMBeanImpl;
import org.netbeans.napi.gsfret.source.SourceTaskFactoryManager;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class GsfModuleInstaller
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.gsf.enableMBeans");

    public void restored() {
        SourceAccessor.dummy = 1;
        Settings.addInitializer((Settings.Initializer)new GsfEditorSettings());
        Settings.reset();
        SourceTaskFactoryManager.register();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RepositoryUpdater.getDefault();
                ActivatedDocumentListener.register();
            }
        });
        if (ENABLE_MBEANS) {
            GsfModuleInstaller.registerMBeans();
        }
    }

    public boolean closing() {
        boolean bl = super.closing();
        RepositoryUpdater.getDefault().close();
        try {
            for (final Language language : LanguageRegistry.getInstance()) {
                if (language.getIndexer() == null) continue;
                ClassIndexManager.get(language);
                ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        ClassIndexManager.get(language).close();
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (ENABLE_MBEANS) {
            GsfModuleInstaller.unregisterMBeans();
        }
        return bl;
    }

    private static void registerMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.gsfret.source:type=LowMemoryNotifier"));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ErrorManager.getDefault().notify((Throwable)notCompliantMBeanException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ErrorManager.getDefault().notify((Throwable)malformedObjectNameException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ErrorManager.getDefault().notify((Throwable)instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ErrorManager.getDefault().notify((Throwable)mBeanRegistrationException);
        }
    }

    private static void unregisterMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.unregisterMBean(new ObjectName("org.netbeans.modules.gsfret.source:type=LowMemoryNotifier"));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ErrorManager.getDefault().notify((Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ErrorManager.getDefault().notify((Throwable)mBeanRegistrationException);
        }
    }
}

