/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.gsf.GsfTypeProvider;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class GsfTypeDescription
extends TypeDescriptor {
    private Icon icon;
    private final GsfTypeProvider.CacheItem cacheItem;
    private final ElementHandle handle;
    private String simpleName;
    private String outerName;
    private String packageName;

    public GsfTypeDescription(GsfTypeProvider.CacheItem cacheItem, ElementHandle elementHandle) {
        this.cacheItem = cacheItem;
        this.handle = elementHandle;
        this.init();
    }

    public void open() {
        if (this.cacheItem.isBinary()) {
            ClasspathInfo classpathInfo = ClasspathInfo.create(this.cacheItem.getRoot());
            Source source = Source.create(classpathInfo, new FileObject[0]);
            final ElementHandle elementHandle = this.handle;
            ElementHandle[] elementHandleArray = new ElementHandle[1];
            try {
                source.runUserActionTask(new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) {
                        FileObject fileObject = compilationController.getFileObject();
                        Source source = Source.forFileObject(fileObject);
                        UiUtils.open(source, elementHandle);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Logger.getLogger(GsfTypeDescription.class.getName()).info("Source not found: " + elementHandle);
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            FileObject fileObject;
            FileObject fileObject2 = fileObject = this.packageName != null ? this.cacheItem.getRoot().getFileObject(this.packageName.replace(".", "/")) : this.cacheItem.getRoot();
            if (fileObject != null) {
                FileObject[] fileObjectArray = fileObject.getChildren();
                String string = this.outerName == null ? this.simpleName : this.outerName;
                int n = string.indexOf(46);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                for (FileObject fileObject3 : fileObjectArray) {
                    if (!string.equals(fileObject3.getName()) || !LanguageRegistry.getInstance().isSupported(fileObject3.getMIMEType())) continue;
                    Source source = Source.forFileObject(fileObject3);
                    UiUtils.open(source, this.handle);
                }
            } else {
                Logger.getLogger(GsfTypeDescription.class.getName()).info("Package " + this.packageName + " doesn't exist in root: " + FileUtil.getFileDisplayName((FileObject)this.cacheItem.getRoot()));
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getOuterName() {
        throw null;
    }

    public FileObject getFileObject() {
        return this.cacheItem.getRoot();
    }

    public String getTypeName() {
        StringBuilder stringBuilder = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            stringBuilder.append(" in ").append(this.outerName);
        }
        return stringBuilder.toString();
    }

    public String getContextName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        return stringBuilder.toString();
    }

    public String getProjectName() {
        String string = this.cacheItem.getProjectName();
        return string == null ? "" : string;
    }

    public Icon getProjectIcon() {
        return this.cacheItem.getProjectIcon();
    }

    private void init() {
        ElementHandle elementHandle = this.handle;
        this.icon = Icons.getElementIcon(elementHandle.getKind(), null);
        this.simpleName = elementHandle.getName();
        this.packageName = elementHandle.getIn();
        this.outerName = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            stringBuilder.append(" in ").append(this.outerName);
        }
        stringBuilder.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        if (this.cacheItem.getProjectName() != null) {
            stringBuilder.append(" [").append(this.cacheItem.getProjectName()).append("]");
        }
        return stringBuilder.toString();
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    public int getOffset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

