/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.BracketCompletion;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class SelectCodeElementAction
extends BaseAction {
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    private boolean selectNext;

    public SelectCodeElementAction(String string, boolean bl) {
        super(string);
        this.selectNext = bl;
        String string2 = this.getShortDescription();
        if (string2 != null) {
            this.putValue("ShortDescription", string2);
        }
    }

    public String getShortDescription() {
        String string;
        String string2 = (String)this.getValue("Name");
        if (string2 == null) {
            return null;
        }
        try {
            string = NbBundle.getBundle(GsfEditorKitFactory.class).getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            string = string2;
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            if (n2 > n || this.selectNext) {
                SelectionHandler selectionHandler = (SelectionHandler)jTextComponent.getClientProperty(SelectionHandler.class);
                if (selectionHandler == null) {
                    selectionHandler = new SelectionHandler(jTextComponent);
                    jTextComponent.addCaretListener(selectionHandler);
                    jTextComponent.putClientProperty(SelectionHandler.class, selectionHandler);
                }
                if (this.selectNext) {
                    selectionHandler.selectNext();
                } else {
                    selectionHandler.selectPrevious();
                }
            }
        }
    }

    private static final class SelectionInfo {
        private int startOffset;
        private int endOffset;

        SelectionInfo(int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectionHandler
    implements CaretListener,
    CancellableTask<CompilationController>,
    Runnable {
        private JTextComponent target;
        private SelectionInfo[] selectionInfos;
        private int selIndex = -1;
        private boolean ignoreNextCaretUpdate;

        SelectionHandler(JTextComponent jTextComponent) {
            this.target = jTextComponent;
        }

        public void selectNext() {
            if (this.selectionInfos == null) {
                Source source = Source.forDocument(this.target.getDocument());
                try {
                    source.runUserActionTask(this, true);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            this.run();
        }

        public synchronized void selectPrevious() {
            if (this.selIndex == -1) {
                this.selIndex = this.computeSelIndex(false);
            }
            if (this.selIndex > 0) {
                this.select(this.selectionInfos[--this.selIndex]);
            }
        }

        private void select(SelectionInfo selectionInfo) {
            Caret caret = this.target.getCaret();
            this.markIgnoreNextCaretUpdate();
            caret.setDot(selectionInfo.getStartOffset());
            this.markIgnoreNextCaretUpdate();
            caret.moveDot(selectionInfo.getEndOffset());
        }

        private void markIgnoreNextCaretUpdate() {
            this.ignoreNextCaretUpdate = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (!this.ignoreNextCaretUpdate) {
                SelectionHandler selectionHandler = this;
                synchronized (selectionHandler) {
                    this.selectionInfos = null;
                    this.selIndex = -1;
                }
            }
            this.ignoreNextCaretUpdate = false;
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) {
            try {
                compilationController.toPhase(Phase.RESOLVED);
                this.selectionInfos = this.initSelectionPath(this.target, compilationController);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        private BracketCompletion getBracketCompletion(Document document, int n) {
            BaseDocument baseDocument = (BaseDocument)document;
            List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
            for (Language language : list) {
                if (language.getBracketCompletion() == null) continue;
                return language.getBracketCompletion();
            }
            return null;
        }

        private SelectionInfo[] initSelectionPath(JTextComponent jTextComponent, CompilationController compilationController) {
            BracketCompletion bracketCompletion = this.getBracketCompletion(jTextComponent.getDocument(), jTextComponent.getCaretPosition());
            if (bracketCompletion != null) {
                List list = bracketCompletion.findLogicalRanges((CompilationInfo)compilationController, jTextComponent.getCaretPosition());
                SelectionInfo[] selectionInfoArray = new SelectionInfo[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    OffsetRange offsetRange = (OffsetRange)list.get(i);
                    selectionInfoArray[i] = new SelectionInfo(offsetRange.getStart(), offsetRange.getEnd());
                }
                return selectionInfoArray;
            }
            return new SelectionInfo[0];
        }

        private int computeSelIndex(boolean bl) {
            Caret caret = this.target.getCaret();
            if (this.selectionInfos != null && caret != null && caret.getDot() != caret.getMark()) {
                int n;
                int n2 = caret.getDot();
                int n3 = caret.getMark();
                int n4 = Math.min(n2, n3);
                for (n = 0; n < this.selectionInfos.length; ++n) {
                    if (this.selectionInfos[n].getStartOffset() != n4) continue;
                    return n;
                }
                for (n = this.selectionInfos.length - 2; n >= 0; --n) {
                    if (this.selectionInfos[n].getStartOffset() <= n4 || this.selectionInfos[n + 1].getStartOffset() >= n4) continue;
                    return bl ? n : n - 1;
                }
            }
            return this.selIndex;
        }

        @Override
        public void run() {
            if (this.selIndex == -1) {
                this.selIndex = this.computeSelIndex(true);
            }
            if (this.selIndex < this.selectionInfos.length - 1) {
                this.select(this.selectionInfos[++this.selIndex]);
            }
        }
    }
}

