/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.hyperlink;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsfret.editor.hyperlink.PopupUtil;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationPopup
extends JPanel
implements FocusListener {
    private String caption;
    private List<DeclarationFinder.AlternativeLocation> declarations;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public DeclarationPopup(String string, List<DeclarationFinder.AlternativeLocation> list) {
        this.caption = string;
        this.declarations = list;
        this.initComponents();
        this.jList1.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(this.caption);
        this.jLabel1.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.setModel(this.createListModel());
        this.jList1.setCellRenderer(new RendererImpl());
        this.jList1.setSelectedIndex(0);
        this.jList1.setVisibleRowCount(this.declarations.size());
        this.jList1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DeclarationPopup.this.jList1KeyPressed(keyEvent);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DeclarationPopup.this.jList1MouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            this.openSelected();
        }
    }

    private void jList1KeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.openSelected();
        }
    }

    private void openSelected() {
        DeclarationFinder.AlternativeLocation alternativeLocation = (DeclarationFinder.AlternativeLocation)this.jList1.getSelectedValue();
        if (alternativeLocation != null) {
            DeclarationFinder.DeclarationLocation declarationLocation = alternativeLocation.getLocation();
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DeclarationPopup.class, (String)"InvalidLoc"));
                Toolkit.getDefaultToolkit().beep();
            } else {
                UiUtils.open(declarationLocation.getFileObject(), declarationLocation.getOffset());
            }
        }
        PopupUtil.hidePopup();
    }

    private ListModel createListModel() {
        DefaultListModel<DeclarationFinder.AlternativeLocation> defaultListModel = new DefaultListModel<DeclarationFinder.AlternativeLocation>();
        for (DeclarationFinder.AlternativeLocation alternativeLocation : this.declarations) {
            defaultListModel.addElement(alternativeLocation);
        }
        return defaultListModel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.jList1.requestFocus();
        this.jList1.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private static class RendererImpl
    extends DefaultListCellRenderer {
        private RendererImpl() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof DeclarationFinder.AlternativeLocation) {
                DeclarationFinder.AlternativeLocation alternativeLocation = (DeclarationFinder.AlternativeLocation)object;
                ElementHandle elementHandle = alternativeLocation.getElement();
                ImageIcon imageIcon = Icons.getElementIcon(elementHandle.getKind(), elementHandle.getModifiers());
                this.setIcon(imageIcon);
                GsfHtmlFormatter gsfHtmlFormatter = new GsfHtmlFormatter();
                String string = alternativeLocation.getDisplayHtml((HtmlFormatter)gsfHtmlFormatter);
                this.setText("<html>" + string);
            }
            return component;
        }
    }
}

