/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.gsf.api.ColoringAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringManager {
    private String mimeType;
    private final Map<Set<ColoringAttributes>, String> type2Coloring;
    private static final Font ITALIC = SettingsDefaults.defaultFont.deriveFont(2);
    private static final Font BOLD = SettingsDefaults.defaultFont.deriveFont(1);

    public ColoringManager(String string) {
        this.mimeType = string;
        this.type2Coloring = new LinkedHashMap<Set<ColoringAttributes>, String>();
        this.put("mark-occurrences", ColoringAttributes.MARK_OCCURRENCES);
        this.put("mod-type-parameter-use", ColoringAttributes.TYPE_PARAMETER_USE);
        this.put("mod-type-parameter-declaration", ColoringAttributes.TYPE_PARAMETER_DECLARATION);
        this.put("mod-enum", ColoringAttributes.ENUM);
        this.put("mod-annotation-type", ColoringAttributes.ANNOTATION_TYPE);
        this.put("mod-interface", ColoringAttributes.INTERFACE);
        this.put("mod-class", ColoringAttributes.CLASS);
        this.put("mod-global", ColoringAttributes.GLOBAL);
        this.put("mod-constructor", ColoringAttributes.CONSTRUCTOR);
        this.put("mod-method", ColoringAttributes.METHOD);
        this.put("mod-parameter", ColoringAttributes.PARAMETER);
        this.put("mod-local-variable", ColoringAttributes.LOCAL_VARIABLE);
        this.put("mod-field", ColoringAttributes.FIELD);
        this.put("mod-public", ColoringAttributes.PUBLIC);
        this.put("mod-protected", ColoringAttributes.PROTECTED);
        this.put("mod-package-private", ColoringAttributes.PACKAGE_PRIVATE);
        this.put("mod-private", ColoringAttributes.PRIVATE);
        this.put("mod-static", ColoringAttributes.STATIC);
        this.put("mod-abstract", ColoringAttributes.ABSTRACT);
        this.put("mod-deprecated", ColoringAttributes.DEPRECATED);
        this.put("mod-undefined", ColoringAttributes.UNDEFINED);
        this.put("mod-unused", ColoringAttributes.UNUSED);
        this.put("mod-local-variable-use", ColoringAttributes.LOCAL_VARIABLE_USE);
        this.put("mod-local-variable-declaration", ColoringAttributes.LOCAL_VARIABLE_DECLARATION);
        this.put("mod-parameter-declaration", ColoringAttributes.PARAMETER_DECLARATION);
        this.put("mod-parameter-use", ColoringAttributes.PARAMETER_USE);
        this.put("mod-java-method-use", ColoringAttributes.JAVA_METHOD_USE);
        this.put("mod-java-field-use", ColoringAttributes.JAVA_FIELD_USE);
        this.put("mod-java-constructor-use", ColoringAttributes.JAVA_CONSTRUCTOR_USE);
        this.put("mod-class-use", ColoringAttributes.CLASS_USE);
        this.put("mod-class-declaration", ColoringAttributes.CLASS_DECLARATION);
        this.put("mod-java-interface-use", ColoringAttributes.JAVA_INTERFACE_USE);
        this.put("mod-attribute-declaration", ColoringAttributes.ATTRIBUTE_DECLARATION);
        this.put("mod-function-declaration", ColoringAttributes.FUNCTION_DECLARATION);
        this.put("mod-operation-declaration", ColoringAttributes.OPERATION_DECLARATION);
        this.put("mod-operation-use", ColoringAttributes.OPERATION_USE);
        this.put("mod-attribute-use", ColoringAttributes.ATTRIBUTE_USE);
        this.put("mod-functions-use", ColoringAttributes.FUNCTION_USE);
        this.put("mod-static-field", ColoringAttributes.STATICFIELD);
        this.put("mod-static-method", ColoringAttributes.STATICMETHOD);
        this.put("mod-regexp", ColoringAttributes.REGEXP);
    }

    private void put(String string, ColoringAttributes ... coloringAttributesArray) {
        EnumSet<ColoringAttributes> enumSet = EnumSet.copyOf(Arrays.asList(coloringAttributesArray));
        this.type2Coloring.put(enumSet, string);
    }

    public Coloring getColoring(Collection<ColoringAttributes> collection) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)this.mimeType)).lookup(FontColorSettings.class);
        Coloring coloring = new Coloring(null, 0, null, null);
        collection = collection.size() > 0 ? EnumSet.copyOf(collection) : EnumSet.noneOf(ColoringAttributes.class);
        for (Map.Entry<Set<ColoringAttributes>, String> entry : this.type2Coloring.entrySet()) {
            int n;
            if (!collection.containsAll((Collection)entry.getKey())) continue;
            String string = entry.getValue();
            collection.removeAll((Collection)entry.getKey());
            if (string == null) continue;
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
            if (attributeSet == null) {
                Logger.getLogger(ColoringManager.class.getName()).log(Level.SEVERE, "no colors for: {0}", string);
                continue;
            }
            Color color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
            Color color2 = (Color)attributeSet.getAttribute(StyleConstants.Background);
            Color color3 = (Color)attributeSet.getAttribute(StyleConstants.StrikeThrough);
            Color color4 = (Color)attributeSet.getAttribute(StyleConstants.Underline);
            Color color5 = (Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor);
            boolean bl = attributeSet.getAttribute(StyleConstants.Bold) == Boolean.TRUE;
            boolean bl2 = attributeSet.getAttribute(StyleConstants.Italic) == Boolean.TRUE;
            Font font = coloring.getFont();
            int n2 = n = font != null ? coloring.getFontMode() : 0;
            if (color == null) {
                color = coloring.getForeColor();
            }
            if (color2 == null) {
                color2 = coloring.getBackColor();
            }
            if (bl) {
                font = font != null ? font.deriveFont(font.isItalic() ? 3 : 1) : BOLD;
                n |= 2;
            }
            if (bl2) {
                font = font != null ? font.deriveFont(font.isBold() ? 3 : 2) : ITALIC;
                n |= 2;
            }
            if (color4 == null) {
                color4 = coloring.getUnderlineColor();
            }
            if (color3 == null) {
                color3 = coloring.getStrikeThroughColor();
            }
            if (color5 == null) {
                color5 = coloring.getWaveUnderlineColor();
            }
            coloring = new Coloring(font, n, color, color2, color4, color3, color5);
        }
        return coloring;
    }
}

