/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HighlightImpl
implements Mark,
Highlight {
    private Document doc;
    private Position start;
    private Position start2;
    private Position end;
    private Position end2;
    private Collection<ColoringAttributes> colorings;
    private Color esColor;
    private Language language;
    Collection<ColoringAttributes> coloringsAttributesOrder = Arrays.asList(ColoringAttributes.STATIC, ColoringAttributes.ABSTRACT, ColoringAttributes.PUBLIC, ColoringAttributes.PROTECTED, ColoringAttributes.PACKAGE_PRIVATE, ColoringAttributes.PRIVATE, ColoringAttributes.DEPRECATED, ColoringAttributes.FIELD, ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.PARAMETER, ColoringAttributes.METHOD, ColoringAttributes.CONSTRUCTOR, ColoringAttributes.CLASS, ColoringAttributes.UNUSED, ColoringAttributes.TYPE_PARAMETER_DECLARATION, ColoringAttributes.TYPE_PARAMETER_USE, ColoringAttributes.UNDEFINED, ColoringAttributes.MARK_OCCURRENCES);

    public HighlightImpl(Document document, Position position, Position position2, Collection<ColoringAttributes> collection) {
        this(document, position, position2, collection, null);
    }

    public HighlightImpl(Document document, Position position, Position position2, Collection<ColoringAttributes> collection, Color color) {
        this.doc = document;
        this.start = position;
        this.end = position2;
        this.colorings = collection;
        this.esColor = color;
    }

    public HighlightImpl(Language language, Document document, int n, int n2, Collection<ColoringAttributes> collection, Color color) throws BadLocationException {
        this.language = language;
        this.doc = document;
        this.start = NbDocument.createPosition((Document)document, (int)n, (Position.Bias)Position.Bias.Forward);
        this.start = NbDocument.createPosition((Document)document, (int)n, (Position.Bias)Position.Bias.Backward);
        this.end = NbDocument.createPosition((Document)document, (int)n2, (Position.Bias)Position.Bias.Backward);
        this.end2 = NbDocument.createPosition((Document)document, (int)n2, (Position.Bias)Position.Bias.Forward);
        this.colorings = collection;
        this.esColor = color;
    }

    public int getEnd() {
        int n = this.end.getOffset();
        if (this.end2 == null) {
            return n;
        }
        int n2 = this.end2.getOffset();
        if (n == n2) {
            return n;
        }
        try {
            String string = this.doc.getText(n, n2 - n);
            int n3 = n;
            for (char c : string.toCharArray()) {
                if (!Character.isJavaIdentifierPart(c)) continue;
                ++n3;
            }
            if (n3 != n) {
                this.end = NbDocument.createPosition((Document)this.doc, (int)n3, (Position.Bias)Position.Bias.Backward);
                this.end2 = NbDocument.createPosition((Document)this.doc, (int)n3, (Position.Bias)Position.Bias.Forward);
            }
            return n3;
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.FINE, badLocationException.getMessage(), badLocationException);
            return n;
        }
    }

    public int getStart() {
        int n = this.start.getOffset();
        if (this.start2 == null) {
            return n;
        }
        int n2 = this.start2.getOffset();
        if (n == n2) {
            return n;
        }
        try {
            String string = this.doc.getText(n, n2 - n);
            int n3 = n;
            for (char c : string.toCharArray()) {
                if (!Character.isJavaIdentifierPart(c)) continue;
                ++n3;
            }
            if (n3 != n) {
                this.start = NbDocument.createPosition((Document)this.doc, (int)n3, (Position.Bias)Position.Bias.Forward);
                this.start2 = NbDocument.createPosition((Document)this.doc, (int)n3, (Position.Bias)Position.Bias.Backward);
            }
            return n3;
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.FINE, badLocationException.getMessage(), badLocationException);
            return n;
        }
    }

    public Coloring getColoring() {
        return this.language.getColoringManager().getColoring(this.colorings);
    }

    public String toString() {
        return "Highlight: [" + this.colorings + ", " + this.start.getOffset() + "-" + this.end.getOffset() + "]";
    }

    public int getType() {
        return 1;
    }

    public Status getStatus() {
        return Status.STATUS_OK;
    }

    public int getPriority() {
        return 1000;
    }

    public Color getEnhancedColor() {
        return this.esColor;
    }

    public int[] getAssignedLines() {
        int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.start.getOffset());
        return new int[]{n, n};
    }

    public String getShortDescription() {
        return "...";
    }

    public String getHighlightTestData() {
        int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.start.getOffset());
        int n2 = NbDocument.findLineColumn((StyledDocument)((StyledDocument)this.doc), (int)this.start.getOffset());
        int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.end.getOffset());
        int n4 = NbDocument.findLineColumn((StyledDocument)((StyledDocument)this.doc), (int)this.end.getOffset());
        return this.coloringsToString() + ", " + n + ":" + n2 + "-" + n3 + ":" + n4;
    }

    private String coloringsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("[");
        for (ColoringAttributes coloringAttributes : this.coloringsAttributesOrder) {
            if (!this.colorings.contains(coloringAttributes)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(coloringAttributes.name());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

