/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.navigation.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class OpenAction
extends AbstractAction {
    private ElementHandle elementHandle;
    private FileObject fileObject;
    private long start;

    public OpenAction(ElementHandle elementHandle, FileObject fileObject, long l) {
        this.elementHandle = elementHandle;
        this.fileObject = fileObject;
        this.start = l;
        this.putValue("Name", NbBundle.getMessage(OpenAction.class, (String)"LBL_Goto"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fileObject != null && this.elementHandle == null) {
            UiUtils.open(this.fileObject, (int)this.start);
            return;
        }
        ElementHandle elementHandle = this.elementHandle;
        try {
            Source source;
            DataObject dataObject = DataObject.find((FileObject)this.fileObject);
            if (dataObject != null && elementHandle != null && (source = Source.forFileObject(dataObject.getPrimaryFile())) != null) {
                UiUtils.open(source, elementHandle);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

