/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenedEditors
implements PropertyChangeListener {
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, FileObject> visibleEditors2Files = new HashMap<JTextComponent, FileObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static OpenedEditors DEFAULT;

    private OpenedEditors() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OpenedEditors.this.stateChanged();
            }
        });
    }

    public static synchronized OpenedEditors getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OpenedEditors();
        }
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ArrayList<ChangeListener> arrayList = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        return Collections.unmodifiableList(this.visibleEditors);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        return Collections.unmodifiableCollection(this.visibleEditors2Files.values());
    }

    public synchronized void stateChanged() {
        JTextComponent jTextComponent2;
        for (JTextComponent jTextComponent2 : this.visibleEditors) {
            jTextComponent2.removePropertyChangeListener(this);
            this.visibleEditors2Files.remove(jTextComponent2);
        }
        this.visibleEditors.clear();
        JTextComponent jTextComponent3 = EditorRegistry.lastFocusedComponent();
        Object object = jTextComponent2 = jTextComponent3 != null ? OpenedEditors.getFileObject(jTextComponent3) : null;
        if (jTextComponent3 instanceof JEditorPane && jTextComponent2 != null && Source.forFileObject((FileObject)jTextComponent2) != null) {
            this.visibleEditors.add(jTextComponent3);
        }
        for (JTextComponent jTextComponent4 : this.visibleEditors) {
            jTextComponent4.addPropertyChangeListener(this);
            this.visibleEditors2Files.put(jTextComponent4, OpenedEditors.getFileObject(jTextComponent4));
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject;
        JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
        FileObject fileObject2 = this.visibleEditors2Files.get(jTextComponent);
        if (fileObject2 != (fileObject = OpenedEditors.getFileObject(jTextComponent))) {
            this.visibleEditors2Files.put(jTextComponent, fileObject);
            this.fireChangeEvent();
        }
    }

    static FileObject getFileObject(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("stream");
        if (!(object instanceof DataObject)) {
            return null;
        }
        DataObject dataObject = (DataObject)object;
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    public static boolean isSupported(FileObject fileObject, String ... stringArray) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", (Object)fileObject);
        return !OpenedEditors.filterSupportedMIMETypes(Collections.singletonList(fileObject), stringArray).isEmpty();
    }

    public static List<FileObject> filterSupportedMIMETypes(Collection<FileObject> collection, String ... stringArray) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", collection);
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        for (FileObject fileObject : collection) {
            Logger.getLogger(OpenedEditors.class.getName()).log(Level.FINER, "analyzing={0}", fileObject);
            if (!LanguageRegistry.getInstance().isSupported(fileObject.getMIMEType()) || Source.forFileObject(fileObject) == null) continue;
            linkedList.add(fileObject);
        }
        return linkedList;
    }
}

