/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.Position;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupPosition;
import com.sun.rave.web.ui.component.ImageComponent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.html.HtmlGraphicImage;
import javax.swing.JComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designerapi.DesignTimeTransferDataCreator;
import org.netbeans.modules.visualweb.api.designtime.idebridge.DesigntimeIdeBridgeProvider;
import org.netbeans.modules.visualweb.designer.jsf.DomProviderImpl;
import org.netbeans.modules.visualweb.designer.jsf.FacesDndSupport;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.outline.api.OutlineSelector;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DndSupport
implements FacesModel.JsfSupport {
    private final JsfForm jsfForm;
    private PropertyChangeListener dndListener;
    private final FacesDndSupport facesDndSupport;

    public DndSupport(JsfForm jsfForm) {
        this.jsfForm = jsfForm;
        this.facesDndSupport = new FacesDndSupport(jsfForm);
    }

    DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray) {
        return FacesDndSupport.getImportFlavor(dataFlavorArray);
    }

    String[] getClassNames(DisplayItem[] displayItemArray) {
        return this.facesDndSupport.getClasses(displayItemArray);
    }

    DesignBean[] pasteBeans(Transferable transferable, DesignBean designBean, MarkupPosition markupPosition, Point point, FacesDndSupport.UpdateSuspender updateSuspender) {
        return this.facesDndSupport.pasteBeans(transferable, designBean, markupPosition, point, this.jsfForm.getUpdateSuspender());
    }

    int computeActions(DesignBean designBean, Transferable transferable) {
        return this.facesDndSupport.computeActions(designBean, transferable);
    }

    int processLinks(Element element, List<DesignBean> list) {
        return this.processLinks(element, null, list, true, true, false);
    }

    private int processLinks(Element element, Class[] classArray, List<DesignBean> list, boolean bl, boolean bl2, boolean bl3) {
        return this.facesDndSupport.processLinks(element, classArray, list, bl, bl2, bl3, this.jsfForm.getUpdateSuspender());
    }

    void updateDndListening() {
        this.dndListener = new DnDListener(this.jsfForm);
        this.facesDndSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dndListener, (Object)this.facesDndSupport));
    }

    int getDropType(DesignBean designBean, Element element, Transferable transferable, boolean bl) {
        Object object;
        DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors());
        if (dataFlavor == null) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            ErrorManager.getDefault().log("Unusable transfer, data flavors=" + (dataFlavorArray == null ? null : Arrays.asList(transferable.getTransferDataFlavors())));
            return 0;
        }
        Class<?> clazz = dataFlavor.getRepresentationClass();
        if (clazz == DisplayItem.class) {
            try {
                Object object2 = transferable.getTransferData(dataFlavor);
                if (!(object2 instanceof DisplayItem)) {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Invalid transferData=" + object2 + ", from transferable=" + transferable));
                    return 0;
                }
                DisplayItem displayItem = (DisplayItem)object2;
                return this.getDropTypeForDisplayItem(designBean, element, displayItem, bl);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
                return 0;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return 0;
            }
        }
        if (clazz == DesignBean.class) {
            try {
                Object object3 = transferable.getTransferData(dataFlavor);
                if (!(object3 instanceof DesignBean[])) {
                    ErrorManager.getDefault().log("Invalid DesignBean[] transfer data: " + object3);
                    return 0;
                }
                DesignBean[] designBeanArray = (DesignBean[])object3;
                String[] stringArray = new String[designBeanArray.length];
                int n = designBeanArray.length;
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = designBeanArray[i].getInstance().getClass().getName();
                }
                return this.getDropTypeForClassNames(designBean, element, stringArray, null, bl);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
                return 0;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                return 0;
            }
        }
        DesignTimeTransferDataCreator designTimeTransferDataCreator = (DesignTimeTransferDataCreator)Lookup.getDefault().lookup(DesignTimeTransferDataCreator.class);
        if (designTimeTransferDataCreator != null && (object = designTimeTransferDataCreator.getDisplayItem(transferable)) != null) {
            return this.getDropTypeForDisplayItem(designBean, element, (DisplayItem)object, bl);
        }
        if (clazz == String.class || clazz == List.class) {
            if (clazz == List.class) {
                try {
                    object = (List)transferable.getTransferData(dataFlavor);
                    for (Object e : object) {
                        File file;
                        if (!(e instanceof File) || !(file = (File)e).exists()) continue;
                        String string = file.getName();
                        String string2 = string.substring(string.lastIndexOf(".") + 1);
                        Project project = this.jsfForm.getProject();
                        if (FileOwnerQuery.getOwner((URI)file.toURI()) == project) {
                            return 0;
                        }
                        if (FacesDndSupport.isImage(string2)) {
                            return 1;
                        }
                        if (!FacesDndSupport.isStylesheet(string2)) continue;
                        return 1;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    DndSupport.log(unsupportedFlavorException);
                    return 0;
                }
                catch (IOException iOException) {
                    DndSupport.log(iOException);
                    return 0;
                }
            } else if (clazz == String.class) {
                return 1;
            }
            return 0;
        }
        if (clazz == Node.class) {
            try {
                Node node;
                DataObject dataObject;
                object = transferable.getTransferData(dataFlavor);
                if (object instanceof Node && (dataObject = (DataObject)(node = (Node)object).getCookie(DataObject.class)) != null) {
                    FileObject fileObject = dataObject.getPrimaryFile();
                    if (FacesDndSupport.isImage(fileObject.getExt())) {
                        String string = this.getImageComponentClassName();
                        String[] stringArray = new String[]{string};
                        return this.getDropTypeForClassNames(designBean, element, stringArray, null, bl);
                    }
                    if (FacesDndSupport.isStylesheet(fileObject.getExt())) {
                        return 1;
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
            }
            return 0;
        }
        return 0;
    }

    private String getImageComponentClassName() {
        if (this.jsfForm.isBraveheartPage()) {
            return ImageComponent.class.getName();
        }
        if (this.jsfForm.isWoodstockPage()) {
            return com.sun.webui.jsf.component.ImageComponent.class.getName();
        }
        return HtmlGraphicImage.class.getName();
    }

    private int getDropTypeForDisplayItem(DesignBean designBean, Element element, DisplayItem displayItem, boolean bl) {
        if (displayItem == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Item is null"));
            return 0;
        }
        String[] stringArray = this.getClassNames(new DisplayItem[]{displayItem});
        return this.getDropTypeForClassNames(designBean, element, stringArray, null, bl);
    }

    int getDropTypeForClassNames(DesignBean designBean, Element element, String[] stringArray, DesignBean[] designBeanArray, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null class names array.");
        }
        if (designBean == null) {
            if (bl) {
                return 0;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.canCreateBean(stringArray[i], null, null)) continue;
                this.showDropMatch(null, 1);
                return 1;
            }
            this.clearDropMatch();
            return 0;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<DesignBean> arrayList2 = designBeanArray == null ? null : new ArrayList<DesignBean>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class clazz = this.getBeanClass(stringArray[i]);
                if (clazz != null) {
                    arrayList.add(clazz);
                }
                if (designBeanArray == null) continue;
                arrayList2.add(designBeanArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        Class[] classArray = arrayList.toArray(new Class[arrayList.size()]);
        int n = this.processLinks(element, classArray, arrayList2, true, false, true);
        if (n != 0) {
            return n;
        }
        if (bl) {
            this.clearDropMatch();
            return 0;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            org.w3c.dom.Node node = null;
            DesignBean designBean2 = this.findParent(stringArray[i], designBean, node, true);
            if (designBean2 == null) continue;
            if (designBean2 instanceof MarkupDesignBean) {
                this.showDropMatch(DomProviderImpl.getComponentRootElementForMarkupDesignBean((MarkupDesignBean)designBean2), 1);
            } else {
                this.clearDropMatch();
            }
            return 1;
        }
        this.showDropMatch(null, 0);
        return 0;
    }

    private boolean canCreateBean(String string, DesignBean designBean, Position position) {
        LiveUnit liveUnit = this.jsfForm.getLiveUnit();
        if (liveUnit == null) {
            return false;
        }
        return liveUnit.canCreateBean(string, designBean, position);
    }

    private DesignBean findParent(String string, DesignBean designBean, org.w3c.dom.Node node, boolean bl) {
        return this.jsfForm.findParent(string, designBean, node, bl);
    }

    private Class getBeanClass(String string) throws ClassNotFoundException {
        return this.jsfForm.getFacesPageUnit().getBeanClass(string);
    }

    private void showDropMatch(Element element, int n) {
        this.jsfForm.showDropMatch(element, null, n);
    }

    private void clearDropMatch() {
        this.jsfForm.clearDropMatch();
    }

    void importString(Designer designer, String string, Point point, org.w3c.dom.Node node, int n, Dimension dimension, boolean bl, Element element, DesignBean designBean, DesignBean designBean2) {
        this.facesDndSupport.importString(designer, string, point, node, n, dimension, bl, element, designBean, designBean2, this.jsfForm.getUpdateSuspender());
    }

    boolean importData(Designer designer, JComponent jComponent, Transferable transferable, Point point, org.w3c.dom.Node node, int n, Dimension dimension, boolean bl, Element element, DesignBean designBean, DesignBean designBean2, int n2) {
        return this.facesDndSupport.importData(designer, jComponent, transferable, point, node, n, dimension, bl, element, designBean, designBean2, this.jsfForm.getUpdateSuspender(), n2);
    }

    boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, Transferable transferable) {
        return this.facesDndSupport.canImport(jComponent, dataFlavorArray, transferable);
    }

    public void moveBeans(DesignBean[] designBeanArray, DesignBean designBean) {
        this.facesDndSupport.moveBeans(designBeanArray, designBean, new MarkupPosition(-1), null);
    }

    public void selectAndInlineEdit(DesignBean[] designBeanArray, DesignBean designBean) {
        this.facesDndSupport.notifyBeansDesigner(designBeanArray, designBean);
    }

    public void refresh(boolean bl) {
        this.facesDndSupport.fireRefreshNeeded(bl);
    }

    private static void log(Exception exception) {
        Logger logger = Logger.getLogger(DndSupport.class.getName());
        logger.log(Level.INFO, null, exception);
    }

    private static class DnDListener
    implements PropertyChangeListener {
        private final JsfForm jsfForm;

        public DnDListener(JsfForm jsfForm) {
            this.jsfForm = jsfForm;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("dropTarget".equals(propertyChangeEvent.getPropertyName())) {
                FacesDndSupport.DropInfo dropInfo = (FacesDndSupport.DropInfo)propertyChangeEvent.getNewValue();
                Element element = DomProviderImpl.getComponentRootElementForMarkupDesignBean(dropInfo.getMarkupDesignBean());
                this.jsfForm.showDropMatch(element, dropInfo.getRegionElement(), dropInfo.getDropType());
            } else if ("selectedDesignBean".equals(propertyChangeEvent.getPropertyName())) {
                DesignBean designBean = (DesignBean)propertyChangeEvent.getNewValue();
                Element element = JsfSupportUtilities.getComponentRootElementForDesignBean(designBean);
                if (element == null) {
                    Node node = DesigntimeIdeBridgeProvider.getDefault().getNodeRepresentation(designBean);
                    if (node != null) {
                        OutlineSelector.getDefault().selectNodes(new Node[]{node});
                    }
                } else {
                    this.jsfForm.selectComponent(element);
                }
            } else if ("refresh".equals(propertyChangeEvent.getPropertyName())) {
                this.jsfForm.refreshModel((Boolean)propertyChangeEvent.getNewValue());
            } else if ("inlineEdit".equals(propertyChangeEvent.getPropertyName())) {
                DesignBean[] designBeanArray = (DesignBean[])propertyChangeEvent.getNewValue();
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (DesignBean designBean : designBeanArray) {
                    Element element = JsfSupportUtilities.getComponentRootElementForDesignBean(designBean);
                    if (element == null) continue;
                    arrayList.add(element);
                }
                this.jsfForm.inlineEditComponents(arrayList.toArray(new Element[arrayList.size()]));
            }
        }
    }
}

