/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import java.beans.IntrospectionException;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.nodes.BeanNode;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;

public class JsfDesignerPreferences {
    private static final int CONSTRAINTS_UNINITIALIZED = -1;
    public static final int CONSTRAINTS_NONE = 0;
    public static final int CONSTRAINTS_640x480 = 1;
    public static final int CONSTRAINTS_800x600 = 2;
    public static final int CONSTRAINTS_1024x768 = 3;
    public static final int CONSTRAINTS_1280x1024 = 4;
    private static final int DEFAULT_FONT_SIZE = 16;
    public static final String PROP_GRID_SHOW = "gridShow";
    public static final String PROP_GRID_SNAP = "gridSnap";
    public static final String PROP_GRID_WIDTH = "gridWidth";
    public static final String PROP_GRID_HEIGHT = "gridHeight";
    public static final String PROP_PAGE_SIZE = "pageSize";
    public static final String PROP_SHOW_DECORATIONS = "showDecorations";
    public static final String PROP_DEFAULT_FONT_SIZE = "defaultFontSize";
    private transient int constraints = -1;
    private transient int defaultFontSize;
    private static final JsfDesignerPreferences INSTANCE = new JsfDesignerPreferences();

    public static JsfDesignerPreferences getInstance() {
        return INSTANCE;
    }

    public static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)INSTANCE);
    }

    public void addWeakPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Preferences preferences = this.getPreferences();
        preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferenceChangeListener, (Object)preferences));
    }

    public void setGridShow(boolean bl) {
        this.getPreferences().putBoolean(PROP_GRID_SHOW, bl);
    }

    public boolean getGridShow() {
        return this.getPreferences().getBoolean(PROP_GRID_SHOW, true);
    }

    public void setGridSnap(boolean bl) {
        this.getPreferences().putBoolean(PROP_GRID_SNAP, bl);
    }

    public boolean getGridSnap() {
        return this.getPreferences().getBoolean(PROP_GRID_SNAP, true);
    }

    public void setGridWidth(int n) {
        if (n < 4) {
            n = 4;
        }
        this.getPreferences().putInt(PROP_GRID_WIDTH, n);
    }

    public int getGridWidth() {
        return this.getPreferences().getInt(PROP_GRID_WIDTH, 24);
    }

    public void setGridHeight(int n) {
        if (n < 4) {
            n = 4;
        }
        this.getPreferences().putInt(PROP_GRID_HEIGHT, n);
    }

    public int getGridHeight() {
        return this.getPreferences().getInt(PROP_GRID_HEIGHT, 24);
    }

    public void setPageSize(int n) {
        this.constraints = n;
        this.getPreferences().putInt(PROP_PAGE_SIZE, n);
    }

    public int getPageSize() {
        return this.getPreferences().getInt(PROP_PAGE_SIZE, 0);
    }

    public int getPageSizeWidth() {
        if (this.constraints == -1) {
            this.constraints = this.getPageSize();
        }
        switch (this.constraints) {
            case 1: {
                return 600;
            }
            case 2: {
                return 760;
            }
            case 3: {
                return 955;
            }
            case 4: {
                return 1210;
            }
        }
        return -1;
    }

    public int getPageSizeHeight() {
        if (this.constraints == -1) {
            this.constraints = this.getPageSize();
        }
        switch (this.constraints) {
            case 1: {
                return 300;
            }
            case 2: {
                return 420;
            }
            case 3: {
                return 600;
            }
            case 4: {
                return 856;
            }
        }
        return -1;
    }

    public void setShowDecorations(boolean bl) {
        this.getPreferences().putBoolean(PROP_SHOW_DECORATIONS, bl);
    }

    public boolean isShowDecorations() {
        return this.getPreferences().getBoolean(PROP_SHOW_DECORATIONS, false);
    }

    public void setDefaultFontSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Zero or negative font size is not allowed, size=" + n);
        }
        this.defaultFontSize = n;
        this.getPreferences().putInt(PROP_DEFAULT_FONT_SIZE, n);
    }

    public int getDefaultFontSize() {
        if (this.defaultFontSize > 0) {
            return this.defaultFontSize;
        }
        this.defaultFontSize = this.getPreferences().getInt(PROP_DEFAULT_FONT_SIZE, 16);
        return this.defaultFontSize;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(JsfDesignerPreferences.class);
    }
}

