/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.netbeans.modules.visualweb.designer.jsf.DecorationManager;
import org.netbeans.modules.visualweb.designer.jsf.JsfDesignerPreferences;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class DecorationsAction
extends AbstractAction
implements Presenter.Toolbar {
    PropertyChangeListener decorationManagerListener = new DecorationManagerListener(this);

    public DecorationsAction() {
        this.putValue("Name", NbBundle.getMessage(DecorationsAction.class, (String)"LBL_DecorationsActionName"));
        this.putValue("ShortDescription", NbBundle.getMessage(DecorationsAction.class, (String)"LBL_DecorationsAction"));
        this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/visualweb/designer/resources/decorations.png")));
        DecorationManager decorationManager = DecorationManager.getDefault();
        decorationManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.decorationManagerListener, (Object)decorationManager));
        this.updateState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JsfDesignerPreferences jsfDesignerPreferences;
        boolean bl = (jsfDesignerPreferences = JsfDesignerPreferences.getInstance()).isShowDecorations();
        jsfDesignerPreferences.setShowDecorations(!bl);
    }

    public Component getToolbarPresenter() {
        if (!this.isEnabled()) {
            return new JComponent(){};
        }
        return new DecorationsToolbarButton(this);
    }

    private void updateState() {
        this.setEnabled(DecorationManager.getDefault().getDecorationProviders().length > 0);
    }

    private static class DecorationManagerListener
    implements PropertyChangeListener {
        private final DecorationsAction decorationsAction;

        public DecorationManagerListener(DecorationsAction decorationsAction) {
            this.decorationsAction = decorationsAction;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("decorationProviders".equals(propertyChangeEvent.getPropertyName())) {
                this.decorationsAction.updateState();
            }
        }
    }

    private static class DecorationsToolbarButton
    extends JToggleButton
    implements PreferenceChangeListener {
        public DecorationsToolbarButton(Action action) {
            this.putClientProperty("hideActionText", Boolean.TRUE);
            this.setAction(action);
            JsfDesignerPreferences jsfDesignerPreferences = JsfDesignerPreferences.getInstance();
            jsfDesignerPreferences.addWeakPreferenceChangeListener(this);
            this.updateState();
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if ("showDecorations".equals(preferenceChangeEvent.getKey())) {
                this.updateState();
            }
        }

        private void updateState() {
            JsfDesignerPreferences jsfDesignerPreferences = JsfDesignerPreferences.getInstance();
            boolean bl = jsfDesignerPreferences.isShowDecorations();
            this.setSelected(bl);
        }
    }
}

