/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.visualweb.designer.jsf.JsfDesignerPreferences;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class TargetResolutionAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar {
    private static final Resolution RESOLUTION_NONE = new Resolution(0, NbBundle.getMessage(TargetResolutionAction.class, (String)"LBL_ResolutionNone"));
    private static final Resolution RESOLUTION_640x480 = new Resolution(1, NbBundle.getMessage(TargetResolutionAction.class, (String)"LBL_Resolution640x480"));
    private static final Resolution RESOLUTION_800x600 = new Resolution(2, NbBundle.getMessage(TargetResolutionAction.class, (String)"LBL_Resolution800x600"));
    private static final Resolution RESOLUTION_1024x768 = new Resolution(3, NbBundle.getMessage(TargetResolutionAction.class, (String)"LBL_Resolution1024x768"));
    private static final Resolution RESOLUTION_1280x1024 = new Resolution(4, NbBundle.getMessage(TargetResolutionAction.class, (String)"LBL_Resolution1280x1024"));
    private static final Resolution[] RESOLUTIONS = new Resolution[]{RESOLUTION_NONE, RESOLUTION_640x480, RESOLUTION_800x600, RESOLUTION_1024x768, RESOLUTION_1280x1024};

    public TargetResolutionAction() {
        this.putValue("Name", this.getDisplayName());
    }

    private String getDisplayName() {
        return NbBundle.getMessage(TargetResolutionAction.class, (String)"LBL_TargetResolutionAction");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RESOLUTIONS[0].performAction();
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)new ResolutionMenuModel(), false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)new ResolutionMenuModel(), true);
    }

    public Component getToolbarPresenter() {
        return new TargetResolutionComboBox(this);
    }

    private static void setResolution(int n) {
        if (n != JsfDesignerPreferences.getInstance().getPageSize()) {
            JsfDesignerPreferences.getInstance().setPageSize(n);
        }
    }

    private static class ResolutionMenuModel
    implements Actions.SubMenuModel {
        public int getCount() {
            return RESOLUTIONS.length;
        }

        public String getLabel(int n) {
            return RESOLUTIONS[n].getDisplayName();
        }

        public HelpCtx getHelpCtx(int n) {
            return null;
        }

        public void performActionAt(int n) {
            RESOLUTIONS[n].performAction();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static class Resolution {
        private final int type;
        private final String displayName;

        public Resolution(int n, String string) {
            this.type = n;
            this.displayName = string;
        }

        public int getType() {
            return this.type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void performAction() {
            TargetResolutionAction.setResolution(this.type);
        }
    }

    private static class TargetResolutionComboBox
    extends JComboBox
    implements PropertyChangeListener,
    PreferenceChangeListener {
        private final Action contextAwareAction;

        public TargetResolutionComboBox(Action action) {
            super(RESOLUTIONS);
            this.contextAwareAction = action;
            this.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object instanceof Resolution) {
                        object = ((Resolution)object).getDisplayName();
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            action.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action));
            JsfDesignerPreferences.getInstance().addWeakPreferenceChangeListener(this);
            TargetResolutionComboBox.setSelectedItemForComboBox(this);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Resolution resolution = (Resolution)TargetResolutionComboBox.this.getSelectedItem();
                    if (resolution != null) {
                        resolution.performAction();
                    }
                }
            });
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        private static void setSelectedItemForComboBox(JComboBox jComboBox) {
            int n = JsfDesignerPreferences.getInstance().getPageSize();
            Resolution resolution = null;
            for (int i = 0; i < RESOLUTIONS.length; ++i) {
                if (n != RESOLUTIONS[i].getType()) continue;
                resolution = RESOLUTIONS[i];
                break;
            }
            jComboBox.setSelectedItem(resolution);
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if ("pageSize".equals(preferenceChangeEvent.getKey())) {
                TargetResolutionComboBox.setSelectedItemForComboBox(this);
            }
        }
    }
}

