/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.ui;

import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.openide.util.NbBundle;

public class RenderErrorPanelImpl
extends JPanel
implements ActionListener,
JsfForm.ErrorPanel {
    private final JsfForm jsfForm;
    private final JsfForm.ErrorPanelCallback errorPanelCallback;
    private final RenderFailureProvider renderFailureProvider;
    private JButton continueButton;
    private JTextArea exceptions;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea textArea;

    public RenderErrorPanelImpl(JsfForm jsfForm, JsfForm.ErrorPanelCallback errorPanelCallback, RenderFailureProvider renderFailureProvider) {
        this.jsfForm = jsfForm;
        this.errorPanelCallback = errorPanelCallback;
        this.renderFailureProvider = renderFailureProvider;
        this.initComponents();
        this.updateErrors();
        Font font = this.jLabel3.getFont();
        if (font != null) {
            int n = font.getSize();
            float f = 2 * n;
            Font font2 = font.deriveFont(f);
            this.jLabel3.setFont(font2);
        }
        this.continueButton.addActionListener(this);
        this.textArea.setEnabled(false);
        this.textArea.setDisabledTextColor(Color.BLACK);
        this.textArea.setFont((Font)UIManager.getDefaults().get("Label.font"));
        errorPanelCallback.setRenderFailureShown(true);
    }

    public void updateErrors() {
        boolean bl;
        boolean bl2 = bl = this.jsfForm.getHtmlBody(false) == null;
        if (bl) {
            this.jLabel3.setText(NbBundle.getMessage(RenderErrorPanelImpl.class, (String)"LBL_MissingBodyElement"));
            this.textArea.setText(NbBundle.getMessage(RenderErrorPanelImpl.class, (String)"TXT_MissingBodyElement"));
            this.continueButton.setVisible(false);
            this.jScrollPane1.setVisible(false);
        } else {
            this.jLabel3.setText(NbBundle.getMessage(RenderErrorPanelImpl.class, (String)"CompRenderError"));
            Exception exception = this.renderFailureProvider.getRenderFailureException();
            MarkupDesignBean markupDesignBean = this.renderFailureProvider.getRenderFailureComponent();
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            this.exceptions.setText(string);
            String string2 = markupDesignBean.getInstanceName();
            this.textArea.setText(NbBundle.getMessage(RenderErrorPanelImpl.class, (String)"CompErrorDescription", (Object)string2, (Object)exception.toString()));
            this.continueButton.setVisible(true);
            this.jScrollPane1.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.errorPanelCallback.handleRefresh(this.jsfForm.isModelBusted());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textArea = new JTextArea();
        this.continueButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.exceptions = new JTextArea();
        this.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBackground(Color.red);
        this.jLabel3.setForeground(Color.white);
        this.jLabel3.setText(NbBundle.getMessage(RenderErrorPanelImpl.class, (String)"CompRenderError"));
        this.jPanel2.add(this.jLabel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.textArea, gridBagConstraints);
        this.continueButton.setText(NbBundle.getBundle(RenderErrorPanelImpl.class).getString("Continue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.add((Component)this.continueButton, gridBagConstraints);
        this.jPanel1.setBackground(Color.white);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.exceptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public static interface RenderFailureProvider {
        public Exception getRenderFailureException();

        public MarkupDesignBean getRenderFailureComponent();
    }
}

