/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyValue
extends RubyEntity {
    private String value;
    private String referenceTypeName;
    private boolean hasChildren;
    private RubyVariable owner;
    private RubyVariable[] variables;

    public RubyValue(RubyVariable owner, String value, String type, boolean hasChildren) {
        super(owner.getProxy());
        this.value = value;
        this.owner = owner;
        this.hasChildren = hasChildren;
        this.referenceTypeName = type;
    }

    public String getReferenceTypeName() {
        return this.referenceTypeName;
    }

    public String getValueString() {
        return this.value;
    }

    public boolean isAllocated() {
        return false;
    }

    public RubyVariable[] getVariables() throws RubyDebuggerException {
        if (!this.hasChildren) {
            return new RubyVariable[0];
        }
        if (this.variables == null) {
            this.variables = this.getProxy().readInstanceVariables(this.owner);
        }
        return this.variables;
    }

    public boolean hasVariables() {
        return this.hasChildren;
    }

    public String toString() {
        return this.getValueString();
    }
}

