/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorsNode
extends ContainerNode {
    private ClasspathInfo cpInfo;

    public ConstructorsNode(ClasspathInfo classpathInfo, ClassNode classNode) {
        super(NbBundle.getMessage(ConstructorsNode.class, (String)"Constructors_DisplayName"), IconResource.CONSTRUCTORS_ICON, classNode);
        this.cpInfo = classpathInfo;
    }

    public ElementHandle<TypeElement> getClassHandle() {
        return ((ClassNode)this.getParent()).getClassHandle();
    }

    @Override
    protected SelectorChildren getChildren() {
        return new Children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Children
    extends GreedySelectorChildren<ConstructorsNode> {
        private Children() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(final ConstructorsNode constructorsNode) {
            final ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            try {
                JavaSource javaSource = JavaSource.create((ClasspathInfo)constructorsNode.cpInfo, (FileObject[])new FileObject[0]);
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement typeElement = SourceUtils.resolveClassByName((String)constructorsNode.getClassHandle().getBinaryName(), (CompilationController)compilationController);
                        List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
                        for (ExecutableElement executableElement : list) {
                            arrayList.add(new ConstructorNode(constructorsNode.cpInfo, executableElement, constructorsNode));
                        }
                    }
                }, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
    }
}

