/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.mozilla.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.MoreInfoFix;
import org.netbeans.modules.javascript.hints.spi.AstRule;
import org.netbeans.modules.javascript.hints.spi.Description;
import org.netbeans.modules.javascript.hints.spi.EditList;
import org.netbeans.modules.javascript.hints.spi.Fix;
import org.netbeans.modules.javascript.hints.spi.HintSeverity;
import org.netbeans.modules.javascript.hints.spi.PreviewableFix;
import org.netbeans.modules.javascript.hints.spi.RuleContext;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeConvert
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public Set<Integer> getKinds() {
        return Collections.singleton(40);
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        Node node = ruleContext.node;
        String string = node.getString();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            Document document;
            char c = string.charAt(i);
            if (c < '\u0100') continue;
            OffsetRange offsetRange = AstUtilities.getRange((CompilationInfo)compilationInfo, (Node)node);
            int n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)offsetRange.getStart());
            if (n2 == -1) {
                return;
            }
            try {
                char c2;
                document = compilationInfo.getDocument();
                if (n2 < document.getLength() - i - 1 && (c2 = document.getText(n2 + i, 1).charAt(0)) != c) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            document = new OffsetRange(n2 += i, n2 + 1);
            ArrayList<Fix> arrayList = new ArrayList<Fix>();
            arrayList.add(new ConvertFix(compilationInfo, n2, c));
            arrayList.add(new MoreInfoFix("unicodeconvert"));
            String string2 = this.getDisplayName();
            Description description = new Description(this, string2, compilationInfo.getFileObject(), (OffsetRange)document, arrayList, 1500);
            list.add(description);
        }
    }

    @Override
    public String getId() {
        return "UnicodeConvert";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(UnicodeConvert.class, (String)"UnicodeConvert");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(UnicodeConvert.class, (String)"UnicodeConvertDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class ConvertFix
    implements PreviewableFix {
        private CompilationInfo info;
        private int lexOffset;
        private char c;

        ConvertFix(CompilationInfo compilationInfo, int n, char c) {
            this.info = compilationInfo;
            this.lexOffset = n;
            this.c = c;
        }

        private String getConverted() {
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder);
            formatter.format("\\u%04x", this.c);
            return stringBuilder.toString();
        }

        public String getDescription() {
            String string = this.getConverted();
            return NbBundle.getMessage(UnicodeConvert.class, (String)"UnicodeConvertFix", (Object)Character.valueOf(this.c), (Object)string);
        }

        public boolean canPreview() {
            return true;
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            EditList editList = new EditList(baseDocument);
            editList.replace(this.lexOffset, 1, this.getConverted(), false, 0);
            return editList;
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            editList.apply();
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

