/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints.infrastructure;

import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.hints.options.HintsAdvancedOption;
import org.netbeans.modules.javascript.hints.spi.EditList;
import org.netbeans.modules.javascript.hints.spi.PreviewableFix;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class PreviewHintFix
implements EnhancedFix {
    private CompilationInfo info;
    private PreviewableFix fix;
    private final String sortText;

    public PreviewHintFix(CompilationInfo compilationInfo, PreviewableFix previewableFix, String string) {
        this.info = compilationInfo;
        this.fix = previewableFix;
        this.sortText = string;
    }

    public String getText() {
        return "    " + NbBundle.getMessage(HintsAdvancedOption.class, (String)"PreviewHint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement() throws Exception {
        EditList editList = this.fix.getEditList();
        BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
        OffsetRange offsetRange = new OffsetRange(0, baseDocument.getLength());
        String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getEnd());
        BaseDocument baseDocument2 = new BaseDocument(null, false);
        Language language = (Language)baseDocument.getProperty(Language.class);
        baseDocument2.putProperty(Language.class, (Object)language);
        String string2 = (String)baseDocument.getProperty((Object)"mimeType");
        baseDocument2.putProperty((Object)"mimeType", (Object)string2);
        baseDocument2.insertString(0, string, null);
        editList.applyToDocument(baseDocument2);
        String string3 = baseDocument2.getText(0, baseDocument2.getLength());
        String string4 = NbBundle.getMessage(HintsAdvancedOption.class, (String)"CurrentSource");
        String string5 = NbBundle.getMessage(HintsAdvancedOption.class, (String)"FixedSource");
        final DiffController diffController = DiffController.create((StreamSource)new DiffSource(string, string4), (StreamSource)new DiffSource(string3, string5));
        JComponent jComponent = diffController.getJComponent();
        jComponent.setPreferredSize(new Dimension(800, 600));
        final int n = diffController.getDifferenceCount() == 0 ? NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)editList.getRange().getStart()) : -1;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n != -1) {
                    diffController.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, n);
                } else if (diffController.getDifferenceCount() > 0) {
                    diffController.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.DifferenceIndex, 0);
                }
            }
        });
        JButton jButton = new JButton(NbBundle.getMessage(HintsAdvancedOption.class, (String)"Apply"));
        JButton jButton2 = new JButton(NbBundle.getMessage(HintsAdvancedOption.class, (String)"Ok"));
        JButton jButton3 = new JButton(NbBundle.getMessage(HintsAdvancedOption.class, (String)"Cancel"));
        String string6 = NbBundle.getMessage(HintsAdvancedOption.class, (String)"PreviewTitle", (Object)this.fix.getDescription());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, string6, true, new Object[]{jButton, jButton2, jButton3}, (Object)jButton2, 0, null, null, true);
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == jButton) {
                this.fix.implement();
            }
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        return null;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    private class DiffSource
    extends StreamSource {
        private String source;
        private String title;

        private DiffSource(String string, String string2) {
            this.source = string;
            this.title = string2;
        }

        public String getName() {
            return "?";
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return PreviewHintFix.this.info.getFileObject().getMIMEType();
        }

        public Reader createReader() throws IOException {
            return new StringReader(this.source);
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isEditable() {
            return false;
        }
    }
}

