/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.options.advanced.Model;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class AdvancedPanel
extends JPanel {
    JTabbedPane tabbedPanel;
    private LookupListener listener = new LookupListenerImpl();
    private Model model = new Model(this.listener);
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            AdvancedPanel.this.handleTabSwitched();
        }
    };

    AdvancedPanel() {
    }

    public void update() {
        int n = this.tabbedPanel.getSelectedIndex();
        if (n != -1) {
            String string = this.tabbedPanel.getTitleAt(n);
            this.model.update(string);
        }
    }

    public void applyChanges() {
        this.model.applyChanges();
    }

    public void cancel() {
        this.model.cancel();
    }

    public HelpCtx getHelpCtx() {
        return this.model.getHelpCtx(this.tabbedPanel != null ? (JComponent)this.tabbedPanel.getSelectedComponent() : null);
    }

    public boolean dataValid() {
        return this.model.isValid();
    }

    public boolean isChanged() {
        return this.model.isChanged();
    }

    public Lookup getLookup() {
        return this.model.getLookup();
    }

    void init(Lookup lookup) {
        this.tabbedPanel = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
        this.initTabbedPane(lookup);
    }

    private void initTabbedPane(Lookup lookup) {
        this.tabbedPanel.removeChangeListener(this.changeListener);
        this.tabbedPanel.removeAll();
        List list = this.model.getCategories();
        this.tabbedPanel.setVisible(list.size() > 0);
        for (String string : list) {
            this.tabbedPanel.addTab(string, new JLabel(string));
        }
        this.tabbedPanel.addChangeListener(this.changeListener);
        this.handleTabSwitched();
    }

    private void handleTabSwitched() {
        int n;
        int n2 = n = this.tabbedPanel.getSelectedIndex() >= 0 ? this.tabbedPanel.getSelectedIndex() : -1;
        if (n != -1) {
            String string = this.tabbedPanel.getTitleAt(n);
            if (this.tabbedPanel.getSelectedComponent() instanceof JLabel) {
                this.tabbedPanel.setComponentAt(this.tabbedPanel.getSelectedIndex(), this.model.getPanel(string));
                ((JComponent)this.tabbedPanel.getSelectedComponent()).setBorder(new EmptyBorder(11, 11, 11, 11));
            }
            this.model.update(string);
            this.firePropertyChange("helpCtx", null, null);
        }
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Lookup lookup = AdvancedPanel.this.model.getLookup();
            AdvancedPanel.this.model = new Model(AdvancedPanel.this.listener);
            AdvancedPanel.this.initTabbedPane(lookup);
        }
    }
}

