/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XsltproProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_NBPROJECT_DIR = "nbproject";

    private XsltproProjectGenerator() {
    }

    public static AntProjectHelper createProject(File file, final String string) throws IOException {
        final FileObject fileObject = XsltproProjectGenerator.createProjectDir(file);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                antProjectHelperArray[0] = XsltproProjectGenerator.setupProject(fileObject, string);
                final Project project = ProjectManager.getDefault().findProject(fileObject);
                fileObject.createFolder(XsltproProjectGenerator.DEFAULT_SRC_FOLDER);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            EditableProperties editableProperties = antProjectHelperArray[0].getProperties("nbproject/project.properties");
                            editableProperties.put("source.root", XsltproProjectGenerator.DEFAULT_SRC_FOLDER);
                            editableProperties.setProperty("meta.inf", "${source.root}/conf");
                            editableProperties.setProperty("src.dir", "${source.root}");
                            editableProperties.setProperty("resource.dir", XsltproProjectGenerator.DEFAULT_RESOURCE_FOLDER);
                            antProjectHelperArray[0].putProperties("nbproject/project.properties", editableProperties);
                            ProjectManager.getDefault().saveProject(project);
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    ErrorManager.getDefault().notify((Throwable)mutexException);
                }
            }
        });
        return antProjectHelperArray[0];
    }

    private static FileObject createProjectDir(File file) throws IOException {
        FileObject fileObject;
        if (!file.exists()) {
            XsltproProjectGenerator.refreshFileSystem(file);
            fileObject = FileUtil.createFolder((File)file);
        } else {
            fileObject = FileUtil.toFileObject((File)file);
        }
        if (fileObject == null) {
            throw new IOException("Can't create " + file.getName());
        }
        assert (fileObject.isFolder()) : "Not really a dir: " + file;
        assert (fileObject.getChildren().length == 0) : "Dir must have been empty: " + file;
        return fileObject;
    }

    private static void refreshFileSystem(File file) throws FileStateInvalidException {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        assert (fileObject != null) : "At least disk roots must be mounted! " + file2;
        fileObject.getFileSystem().refresh(false);
    }

    public static AntProjectHelper importProject(File file, String string, FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String string2, String string3) throws IOException {
        File file2;
        file.mkdirs();
        File file3 = file;
        while (file3.getParentFile() != null) {
            file3 = file3.getParentFile();
        }
        FileObject fileObject4 = FileUtil.toFileObject((File)file3);
        assert (fileObject4 != null) : "At least disk roots must be mounted! " + file3;
        fileObject4.getFileSystem().refresh(false);
        fileObject4 = FileUtil.toFileObject((File)file);
        if (fileObject4 == null) {
            throw new IOException("Can't create " + file.getName());
        }
        assert (fileObject4.isFolder()) : "Not really a dir: " + file;
        AntProjectHelper antProjectHelper = XsltproProjectGenerator.setupProject(fileObject4, string);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        if (FileUtil.isParentOf((FileObject)fileObject4, (FileObject)fileObject) || fileObject4.equals(fileObject)) {
            editableProperties.put("source.root", ".");
            editableProperties.setProperty("src.dir", XsltproProjectGenerator.relativePath(fileObject4, fileObject2));
            editableProperties.setProperty("meta.inf", XsltproProjectGenerator.relativePath(fileObject4, fileObject3));
        } else {
            file2 = FileUtil.toFile((FileObject)fileObject);
            editableProperties.put("source.root", file2.getAbsolutePath());
            String string4 = XsltproProjectGenerator.relativePath(fileObject, fileObject3);
            string4 = string4.length() > 0 ? "${source.root}/" + string4 : "${source.root}";
            String string5 = XsltproProjectGenerator.relativePath(fileObject, fileObject2);
            string5 = string5.length() > 0 ? "${source.root}/" + string5 : "${source.root}";
            editableProperties.setProperty("src.dir", string5);
            editableProperties.setProperty("meta.inf", string4);
        }
        if (!"build.xml".equals(string3)) {
            editableProperties.setProperty("buildfile", string3);
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        file2 = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject((Project)file2);
        return antProjectHelper;
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException("Cannot find relative path, " + fileObject + " is not parent of " + fileObject2);
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject fileObject, String string) throws IOException {
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.xslt.project");
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-xsltpro/1", "name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2ee-xsltpro/1", "minimum-ant-version");
        element3.appendChild(document.createTextNode("1.6"));
        element.appendChild(element3);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("dist.dir", "dist");
        editableProperties.setProperty("dist.jar", "${dist.dir}/" + string + ".zip");
        editableProperties.setProperty("jar.name", string + ".jar");
        editableProperties.setProperty("jar.compress", "false");
        Deployment deployment = Deployment.getDefault();
        String string2 = deployment.getDefaultServerInstanceID();
        editableProperties.setProperty("javac.source", "1.4");
        editableProperties.setProperty("javac.debug", "true");
        editableProperties.setProperty("javac.deprecation", "false");
        editableProperties.setProperty("allow.build.with.error", "false");
        editableProperties.setProperty("javac.target", "1.4");
        editableProperties.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties.setProperty("build.classes.dir", "${build.dir}/jar");
        editableProperties.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        editableProperties.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        editableProperties.setProperty("platform.active", "default_platform");
        editableProperties.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}");
        editableProperties.setProperty("wsdl.classpath", "");
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        editableProperties.setProperty("com.sun.jbi.ui.devtool.jbi.setype.prefix", "sun-xslt-engine");
        editableProperties.setProperty("com.sun.jbi.ui.devtool.jbi.description.application-sub-assembly", NbBundle.getMessage(XsltproProjectGenerator.class, (String)"TXT_Service_Unit_Description"));
        editableProperties.setProperty("jbi.se.type", "sun-bpel-engine");
        editableProperties.setProperty("jbi.service-unit.description", NbBundle.getMessage(XsltproProjectGenerator.class, (String)"TXT_Service_Unit_Description"));
        editableProperties.setProperty("com.sun.jbi.ui.devtool.jbi.component.conf.root", "nbproject/private");
        editableProperties.setProperty("com.sun.jbi.ui.devtool.jbi.deployment.conf.root", "nbproject/deployment");
        editableProperties.setProperty("bcdeployment.jar", "${build.dir}/BCDeployment.jar");
        editableProperties.setProperty("sedeployment.jar", "${build.dir}/SEDeployment.jar");
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.setProperty("com.sun.jbi.ui.devtool.jbi.component.conf.file", "ComponentInformation.xml");
        editableProperties.setProperty("com.sun.jbi.ui.devtool.jbi.deployment.conf.file", "default.xml");
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }
}

