/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastTargetExecuted {
    private static File buildScript;
    private static int verbosity;
    private static String[] targets;
    private static Map<String, String> properties;
    private static final ChangeSupport cs;

    private LastTargetExecuted() {
    }

    static void record(File file, int n, String[] stringArray, Map<String, String> map) {
        buildScript = file;
        verbosity = n;
        targets = stringArray;
        properties = map;
        cs.fireChange();
    }

    public static AntProjectCookie getLastBuildScript() {
        block4: {
            if (buildScript != null && buildScript.isFile()) {
                FileObject fileObject = FileUtil.toFileObject((File)buildScript);
                assert (fileObject != null);
                try {
                    return (AntProjectCookie)DataObject.find((FileObject)fileObject).getCookie(AntProjectCookie.class);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)dataObjectNotFoundException);
                }
            }
        }
        return null;
    }

    public static String[] getLastTargets() {
        return targets;
    }

    public static String getProcessDisplayName() {
        AntProjectCookie antProjectCookie = LastTargetExecuted.getLastBuildScript();
        if (antProjectCookie != null) {
            return TargetExecutor.getProcessDisplayName(antProjectCookie, targets != null ? Arrays.asList(targets) : null);
        }
        return null;
    }

    public static ExecutorTask rerun() throws IOException {
        AntProjectCookie antProjectCookie = LastTargetExecuted.getLastBuildScript();
        if (antProjectCookie == null) {
            cs.fireChange();
            return null;
        }
        TargetExecutor targetExecutor = new TargetExecutor(antProjectCookie, targets);
        targetExecutor.setVerbosity(verbosity);
        targetExecutor.setProperties(properties);
        return targetExecutor.execute();
    }

    public static void addChangeListener(ChangeListener changeListener) {
        cs.addChangeListener(changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        cs.removeChangeListener(changeListener);
    }

    static {
        cs = new ChangeSupport(LastTargetExecuted.class);
    }
}

