/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.lang.model.element.Element;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.navigation.DocumentationScrollPane;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaHierarchyModel;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyIcons;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.java.navigation.NoBorderToolBar;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaHierarchyPanel
extends JPanel {
    private static TreeModel pleaseWaitTreeModel;
    private FileObject fileObject;
    private JavaHierarchyModel javaHierarchyModel;
    private Component lastFocusedComponent;
    private DocumentationScrollPane docPane;
    public JCheckBox caseSensitiveFilterCheckBox;
    public JButton closeButton;
    public JButton expandAllButton;
    public JLabel filterLabel;
    public JTextField filterTextField;
    public JLabel filtersLabel;
    public JToolBar filtersToolbar;
    public ButtonGroup javaHierarchyModeButtonGroup;
    public JTree javaHierarchyTree;
    public JScrollPane javaHierarchyTreeScrollPane;
    public JToggleButton showFQNToggleButton;
    public JToggleButton showInnerToggleButton;
    public JToggleButton showSubTypeHierarchyToggleButton;
    public JToggleButton showSuperTypeHierarchyToggleButton;
    public JEditorPane signatureEditorPane;
    public JSplitPane splitPane;

    public JavaHierarchyPanel(FileObject fileObject, Element[] elementArray, CompilationInfo compilationInfo) {
        this.fileObject = fileObject;
        this.initComponents();
        this.docPane = new DocumentationScrollPane(true);
        this.splitPane.setRightComponent(this.docPane);
        this.splitPane.setDividerLocation(JavaMembersAndHierarchyOptions.getHierarchyDividerLocation());
        ToolTipManager.sharedInstance().registerComponent(this.javaHierarchyTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.caseSensitiveFilterCheckBox.setSelected(JavaMembersAndHierarchyOptions.isCaseSensitive());
        this.showSuperTypeHierarchyToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy());
        this.showSubTypeHierarchyToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy());
        this.showFQNToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFQN());
        this.showInnerToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInner());
        this.javaHierarchyTree.getSelectionModel().setSelectionMode(1);
        this.javaHierarchyTree.setRootVisible(false);
        this.javaHierarchyTree.setShowsRootHandles(true);
        this.javaHierarchyTree.setCellRenderer(new JavaTreeCellRenderer());
        this.javaHierarchyModel = new JavaHierarchyModel(fileObject, elementArray, compilationInfo);
        this.javaHierarchyTree.setModel(this.javaHierarchyModel);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }
        });
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.signatureEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.gotoElement((JavaElement)object);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = JavaHierarchyPanel.this.docPane.getViewport().getView();
                if (component instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)component;
                    ActionListener actionListener = jEditorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0, false));
                    actionListener.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
                }
            }
        }, KeyStroke.getKeyStroke(33, 1, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){
            private boolean firstTime = true;

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = JavaHierarchyPanel.this.docPane.getViewport().getView();
                if (component instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)component;
                    ActionListener actionListener = jEditorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0, false));
                    actionEvent = new ActionEvent(jEditorPane, 1001, "");
                    actionListener.actionPerformed(actionEvent);
                    if (this.firstTime) {
                        actionListener.actionPerformed(actionEvent);
                        this.firstTime = false;
                    }
                }
            }
        }, KeyStroke.getKeyStroke(34, 1, false), 0);
        this.caseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersAndHierarchyOptions.setCaseSensitive(JavaHierarchyPanel.this.caseSensitiveFilterCheckBox.isSelected());
                if (JavaHierarchyPanel.this.filterTextField.getText().trim().length() > 0) {
                    JavaHierarchyPanel.this.selectMatchingRow();
                }
            }
        });
        this.javaHierarchyTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                Point point = mouseEvent.getPoint();
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    if (mouseEvent.getClickCount() == 1) {
                        if (mouseEvent.isControlDown()) {
                            JavaElement javaElement = (JavaElement)object;
                            JavaHierarchyPanel.this.applyFilter();
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        JavaHierarchyPanel.this.gotoElement((JavaElement)object);
                    }
                }
            }
        });
        this.javaHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JavaHierarchyPanel.this.showSignature();
                JavaHierarchyPanel.this.showJavaDoc();
            }
        });
        this.javaHierarchyTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.gotoElement((JavaElement)object);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.javaHierarchyTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.showSuperTypeHierarchyToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                    JavaHierarchyPanel.this.applyFilter(true);
                }
            }
        });
        this.showSubTypeHierarchyToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy()) {
                    JavaHierarchyPanel.this.applyFilter(true);
                }
            }
        });
        this.showFQNToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersAndHierarchyOptions.setShowFQN(JavaHierarchyPanel.this.showFQNToggleButton.isSelected());
                JavaHierarchyPanel.this.javaHierarchyModel.fireTreeNodesChanged();
            }
        });
        this.showInnerToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.applyFilter(true);
            }
        });
        this.expandAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.expandAll();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.close();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaHierarchyPanel.this.applyFilter(true);
                JavaHierarchyPanel.this.filterTextField.requestFocusInWindow();
            }
        });
    }

    public void removeNotify() {
        JavaMembersAndHierarchyOptions.setHierarchyDividerLocation(this.splitPane.getDividerLocation());
        this.docPane.setData(null);
        super.removeNotify();
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        JRootPane jRootPane;
        if ((keyEvent.getKeyCode() == 112 || keyEvent.getKeyCode() == 156) && (jRootPane = SwingUtilities.getRootPane(this)) != null) {
            jRootPane.putClientProperty("help", Boolean.TRUE);
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void enterBusy() {
        Window window;
        this.javaHierarchyTree.setModel(pleaseWaitTreeModel);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((window = SwingUtilities.getWindowAncestor(this)) != null) {
            this.lastFocusedComponent = window.getFocusOwner();
        }
        this.filterTextField.setEnabled(false);
        this.caseSensitiveFilterCheckBox.setEnabled(false);
        this.showSubTypeHierarchyToggleButton.setEnabled(false);
        this.showSuperTypeHierarchyToggleButton.setEnabled(false);
        this.showFQNToggleButton.setEnabled(false);
        this.showInnerToggleButton.setEnabled(false);
        this.expandAllButton.setEnabled(false);
    }

    private void leaveBusy() {
        this.javaHierarchyTree.setModel(this.javaHierarchyModel);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getDefaultCursor());
        }
        this.filterTextField.setEnabled(true);
        this.caseSensitiveFilterCheckBox.setEnabled(true);
        this.showSubTypeHierarchyToggleButton.setEnabled(true);
        this.showSuperTypeHierarchyToggleButton.setEnabled(true);
        this.showFQNToggleButton.setEnabled(true);
        this.showInnerToggleButton.setEnabled(true);
        this.expandAllButton.setEnabled(true);
        if (this.lastFocusedComponent != null) {
            if (this.lastFocusedComponent.isDisplayable()) {
                this.lastFocusedComponent.requestFocusInWindow();
            }
            this.lastFocusedComponent = null;
        }
    }

    private void applyFilter() {
        this.applyFilter(true);
    }

    private void applyFilter(final boolean bl) {
        if (bl) {
            this.enterBusy();
        }
        JavaMembersAndHierarchyOptions.setCaseSensitive(this.caseSensitiveFilterCheckBox.isSelected());
        JavaMembersAndHierarchyOptions.setShowSuperTypeHierarchy(this.showSuperTypeHierarchyToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowSubTypeHierarchy(this.showSubTypeHierarchyToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowFQN(this.showFQNToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowInner(this.showInnerToggleButton.isSelected());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (bl) {
                        JavaHierarchyPanel.this.javaHierarchyModel.update();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (bl) {
                                JavaHierarchyPanel.this.leaveBusy();
                            }
                            for (int i = 0; i < JavaHierarchyPanel.this.javaHierarchyTree.getRowCount(); ++i) {
                                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForRow(i);
                                if (JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy()) {
                                    if (treePath.getPathCount() >= JavaMembersAndHierarchyOptions.getSubTypeHierarchyDepth()) continue;
                                    JavaHierarchyPanel.this.javaHierarchyTree.expandRow(i);
                                    continue;
                                }
                                JavaHierarchyPanel.this.javaHierarchyTree.expandRow(i);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void expandAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JRootPane jRootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                if (jRootPane != null) {
                    jRootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (int i = 0; i < JavaHierarchyPanel.this.javaHierarchyTree.getRowCount(); ++i) {
                        JavaHierarchyPanel.this.javaHierarchyTree.expandRow(i);
                    }
                    JavaHierarchyPanel.this.selectMatchingRow();
                }
                finally {
                    JRootPane jRootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                    if (jRootPane != null) {
                        jRootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void selectMatchingRow() {
        this.filterTextField.setForeground(UIManager.getColor("TextField.foreground"));
        this.javaHierarchyTree.setSelectionRow(-1);
        for (int i = 0; i < this.javaHierarchyTree.getRowCount(); ++i) {
            String string;
            Object object = this.javaHierarchyTree.getPathForRow(i).getLastPathComponent();
            if (!(object instanceof JavaElement) || !Utils.patternMatch((JavaElement)object, string = this.filterTextField.getText(), string.toLowerCase())) continue;
            this.javaHierarchyTree.setSelectionRow(i);
            this.javaHierarchyTree.scrollRowToVisible(i);
            return;
        }
        this.filterTextField.setForeground(Color.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaElement) {
        try {
            javaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showSignature() {
        Object object;
        this.signatureEditorPane.setText("");
        this.signatureEditorPane.setToolTipText(null);
        TreePath treePath = this.javaHierarchyTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.signatureEditorPane.setText(((JavaElement)object).getTooltip());
            this.signatureEditorPane.setCaretPosition(0);
            this.signatureEditorPane.setToolTipText(((JavaElement)object).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object object;
        TreePath treePath = this.javaHierarchyTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.docPane.setData(((JavaElement)object).getJavaDoc());
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private void initComponents() {
        this.javaHierarchyModeButtonGroup = new ButtonGroup();
        this.filterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.caseSensitiveFilterCheckBox = new JCheckBox();
        this.splitPane = new JSplitPane();
        this.javaHierarchyTreeScrollPane = new JScrollPane();
        this.javaHierarchyTree = new JTree();
        this.signatureEditorPane = new JEditorPane();
        this.filtersLabel = new JLabel();
        this.closeButton = new JButton();
        this.filtersToolbar = new NoBorderToolBar();
        this.showSuperTypeHierarchyToggleButton = new JToggleButton();
        this.showSubTypeHierarchyToggleButton = new JToggleButton();
        this.showFQNToggleButton = new JToggleButton();
        this.showInnerToggleButton = new JToggleButton();
        this.expandAllButton = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.filterLabel.setLabelFor(this.filterTextField);
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getBundle(JavaHierarchyPanel.class).getString("LABEL_filterLabel"));
        this.filterTextField.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveFilterCheckBox, (String)NbBundle.getBundle(JavaHierarchyPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.caseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.caseSensitiveFilterCheckBox.setFocusable(false);
        this.caseSensitiveFilterCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.splitPane.setDividerLocation(350);
        this.splitPane.setOneTouchExpandable(true);
        this.javaHierarchyTreeScrollPane.setBorder(null);
        this.javaHierarchyTreeScrollPane.setViewportView(this.javaHierarchyTree);
        this.splitPane.setLeftComponent(this.javaHierarchyTreeScrollPane);
        this.signatureEditorPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.signatureEditorPane.setContentType("text/x-java");
        this.signatureEditorPane.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LABEL_filtersLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LABEL_Close"));
        this.filtersToolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.filtersToolbar.setFloatable(false);
        this.filtersToolbar.setBorderPainted(false);
        this.filtersToolbar.setOpaque(false);
        this.javaHierarchyModeButtonGroup.add(this.showSuperTypeHierarchyToggleButton);
        this.showSuperTypeHierarchyToggleButton.setIcon(JavaMembersAndHierarchyIcons.SUPER_TYPE_HIERARCHY_ICON);
        this.showSuperTypeHierarchyToggleButton.setMnemonic('S');
        this.showSuperTypeHierarchyToggleButton.setSelected(true);
        this.showSuperTypeHierarchyToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showSuperTypeHierarchyToggleButton"));
        this.showSuperTypeHierarchyToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showSuperTypeHierarchyToggleButton);
        this.javaHierarchyModeButtonGroup.add(this.showSubTypeHierarchyToggleButton);
        this.showSubTypeHierarchyToggleButton.setIcon(JavaMembersAndHierarchyIcons.SUB_TYPE_HIERARCHY_ICON);
        this.showSubTypeHierarchyToggleButton.setMnemonic('B');
        this.showSubTypeHierarchyToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showSubTypeHierarchyToggleButton"));
        this.showSubTypeHierarchyToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showSubTypeHierarchyToggleButton);
        this.showFQNToggleButton.setIcon(JavaMembersAndHierarchyIcons.FQN_ICON);
        this.showFQNToggleButton.setMnemonic('Q');
        this.showFQNToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.showFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showFQNToggleButton);
        this.showInnerToggleButton.setIcon(JavaMembersAndHierarchyIcons.INNER_CLASS_ICON);
        this.showInnerToggleButton.setMnemonic('I');
        this.showInnerToggleButton.setSelected(true);
        this.showInnerToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showInnerToggleButton"));
        this.showInnerToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showInnerToggleButton);
        this.expandAllButton.setIcon(JavaMembersAndHierarchyIcons.EXPAND_ALL_ICON);
        this.expandAllButton.setMnemonic('E');
        this.expandAllButton.setToolTipText(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"TOOLTIP_expandAll"));
        this.expandAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.expandAllButton);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.splitPane, -1, 710, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.filterTextField, -1, 550, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caseSensitiveFilterCheckBox)).add((Component)this.signatureEditorPane, -1, 710, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filtersLabel).addPreferredGap(0).add((Component)this.filtersToolbar, -1, 581, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.caseSensitiveFilterCheckBox).add((Component)this.filterTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.signatureEditorPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.filtersLabel).add((Component)this.closeButton)).add((Component)this.filtersToolbar, -2, 25, -2)).addContainerGap()));
        this.caseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"caseSensitiveFilterCheckBox_ACSD"));
    }

    static {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LBL_WaitNode")));
        pleaseWaitTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
    }
}

