/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.AbstractReference;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xslt.model.QualifiedNameable;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.model.XslReference;
import org.netbeans.modules.xslt.model.impl.Utilities;
import org.netbeans.modules.xslt.model.impl.XslComponentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlobalReferenceImpl<T extends QualifiedNameable>
extends AbstractReference<T>
implements XslReference<T> {
    private QName myQname;
    private String myPrefix;
    private String myLocalPart;

    GlobalReferenceImpl(T t, Class<T> clazz, XslComponentImpl xslComponentImpl) {
        super(t, clazz, (AbstractComponent)xslComponentImpl);
    }

    GlobalReferenceImpl(Class<T> clazz, XslComponentImpl xslComponentImpl, String string) {
        super(clazz, (AbstractComponent)xslComponentImpl, string);
        this.initReferenceString(string);
    }

    public T get() {
        if (this.getReferenced() == null) {
            this.setReferenced((Referenceable)this.find());
        }
        return (T)((QualifiedNameable)super.getReferenced());
    }

    public String getRefString() {
        if (this.refString == null) {
            QualifiedNameable qualifiedNameable = (QualifiedNameable)super.getReferenced();
            assert (qualifiedNameable != null);
            this.myQname = qualifiedNameable.getName();
            if (this.myQname != null) {
                this.myPrefix = this.myQname.getPrefix();
                this.myLocalPart = this.myQname.getLocalPart();
                String string = this.myPrefix == null || this.myPrefix.length() == 0 ? this.myLocalPart : this.myPrefix + ":" + this.myLocalPart;
                if (this.getParent().isInDocumentModel()) {
                    this.refString = string;
                } else {
                    return string;
                }
            }
        }
        return super.getRefString();
    }

    @Override
    public QName getQName() {
        this.checkParentNotRemovedFromModel();
        if (this.myQname == null) {
            QualifiedNameable qualifiedNameable = (QualifiedNameable)super.getReferenced();
            this.myQname = qualifiedNameable.getName();
        }
        return this.myQname;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GlobalReferenceImpl)) {
            return false;
        }
        GlobalReferenceImpl globalReferenceImpl = (GlobalReferenceImpl)object;
        return this.getParent().equals(globalReferenceImpl.getParent()) && this.getQName().equals(globalReferenceImpl.getQName());
    }

    public int hashCode() {
        return this.getParent().hashCode();
    }

    public XslComponentImpl getParent() {
        return (XslComponentImpl)super.getParent();
    }

    public boolean references(T t) {
        if (t instanceof QualifiedNameable) {
            T t2 = t;
            return t2.getName() != null && t2.getName().equals(this.getQName()) && !this.isBroken() && this.get() == t;
        }
        return super.references(t);
    }

    public void refresh() {
        this.getRefString();
        this.setReferenced(null);
    }

    protected T getReferenced() {
        if (super.getReferenced() == null) {
            this.checkParentPartOfModel();
        } else {
            if (super.getParent().getModel() == null) {
                throw new IllegalStateException("Referencing component has been removed from model.");
            }
            if (((QualifiedNameable)super.getReferenced()).getModel() == null) {
                throw new IllegalStateException("Referenced component has been removed from model.");
            }
        }
        return (T)((QualifiedNameable)super.getReferenced());
    }

    protected void checkParentNotRemovedFromModel() {
        if (this.getParent().getModel() == null) {
            throw new IllegalStateException("Referencing component has been removed from model.");
        }
    }

    protected void checkParentPartOfModel() {
        if (!this.getParent().isInDocumentModel()) {
            throw new IllegalStateException("Referencing component is not part of model.");
        }
    }

    protected QName calculateQNameLocally() {
        String string;
        String string2 = this.getPrefix();
        String string3 = this.getLocalPart();
        String string4 = null;
        string4 = this.getParent().lookupNamespaceURI(string2);
        if (string4 == null && (string = this.getParent().lookupPrefix(string2)) != null) {
            string4 = string2 = string;
        }
        if (string2 == null) {
            return new QName(string4, string3);
        }
        return new QName(string4, string3, string2);
    }

    private String getLocalPart() {
        if (this.myLocalPart == null) {
            String string = this.getRefString();
            if (string == null) {
                return null;
            }
            String[] stringArray = string.split(":");
            if (stringArray.length == 2) {
                return stringArray[1];
            }
            return stringArray[0];
        }
        return this.myLocalPart;
    }

    private String getPrefix() {
        if (this.myPrefix == null) {
            String string = this.getRefString();
            if (string == null) {
                return null;
            }
            String[] stringArray = string.split(":");
            if (stringArray.length == 2) {
                return stringArray[0];
            }
            return null;
        }
        return this.myPrefix;
    }

    private void initReferenceString(String string) {
        assert (string != null);
        this.refString = string;
        String[] stringArray = this.refString.split(":");
        if (stringArray.length == 2) {
            this.myPrefix = stringArray[0];
            this.myLocalPart = stringArray[1];
        } else {
            this.myPrefix = null;
            this.myLocalPart = stringArray[0];
        }
    }

    private T find() {
        LinkedHashSet<XslModel> linkedHashSet = Utilities.getAvailibleModels(this.getParent().getModel());
        for (XslModel xslModel : linkedHashSet) {
            List list;
            T t;
            Stylesheet stylesheet;
            if (!Model.State.VALID.equals((Object)xslModel.getState()) || (stylesheet = xslModel.getStylesheet()) == null || (t = this.find(list = stylesheet.getChildren(this.getType()))) == null) continue;
            return t;
        }
        return null;
    }

    private T find(List<T> list) {
        for (QualifiedNameable qualifiedNameable : list) {
            QName qName = qualifiedNameable.getName();
            if (qName == null) continue;
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            if (!this.getLocalPart().equals(string) || !Utilities.equals(this.getQName().getNamespaceURI(), string2)) continue;
            return (T)qualifiedNameable;
        }
        return null;
    }
}

