/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.dm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.sun.ide.dm.SunDeploymentManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ProgressEventSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Status;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunJDBCDriverDeployer
implements JDBCDriverDeployer {
    private DeploymentManager dm;
    private SunDeploymentManager sunDm;

    public SunJDBCDriverDeployer(DeploymentManager deploymentManager) {
        this.dm = deploymentManager;
        this.sunDm = (SunDeploymentManager)this.dm;
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        DeploymentManagerProperties deploymentManagerProperties;
        boolean bl = true;
        if (!this.sunDm.isLocal()) {
            bl = false;
        }
        if (!(deploymentManagerProperties = new DeploymentManagerProperties(this.dm)).isDriverDeploymentEnabled()) {
            bl = false;
        }
        return bl;
    }

    public ProgressObject deployJDBCDrivers(Target target, Set<Datasource> set) {
        return new JDBCDriversProgressObject(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JDBCDriversProgressObject
    implements ProgressObject,
    Runnable {
        private final ProgressEventSupport eventSupport;
        private final Set<Datasource> datasources;

        public JDBCDriversProgressObject(Set<Datasource> set) {
            this.eventSupport = new ProgressEventSupport(SunJDBCDriverDeployer.this);
            this.datasources = set;
            String string = NbBundle.getMessage(SunJDBCDriverDeployer.class, (String)"MSG_CheckMissingDrivers");
            this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.RUNNING));
            RequestProcessor.getDefault().post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List list = this.getJdbcDrivers();
            if (list.size() > 0) {
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    Object object;
                    URL uRL = (URL)list.get(i);
                    File file = this.getJDBCDriversLocation();
                    try {
                        String string;
                        File file2 = new File(file, new File(uRL.toURI()).getName());
                        try {
                            object = new BufferedInputStream(uRL.openStream());
                            try {
                                string = NbBundle.getMessage(SunJDBCDriverDeployer.class, (String)"MSG_DeployDriver", (Object)file2.getPath());
                                this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.RUNNING));
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                                try {
                                    FileUtil.copy((InputStream)object, (OutputStream)bufferedOutputStream);
                                }
                                finally {
                                    bufferedOutputStream.close();
                                }
                            }
                            finally {
                                ((BufferedInputStream)object).close();
                            }
                        }
                        catch (IOException iOException) {
                            string = NbBundle.getMessage(SunJDBCDriverDeployer.class, (String)"ERR_DeployDriver", (Object)file2.getPath(), (Object)file.getPath());
                            this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.FAILED));
                            bl = false;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        object = NbBundle.getMessage(SunJDBCDriverDeployer.class, (String)"ERR_DeployDriver", (Object)uRL, (Object)file.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, (String)object, StateType.FAILED));
                        bl = false;
                    }
                }
                String string = NbBundle.getMessage(SunJDBCDriverDeployer.class, (String)"MSG_DeployDriverComplete");
                if (bl) {
                    SunJDBCDriverDeployer.this.sunDm.setRestartForDriverDeployment(true);
                } else {
                    string = NbBundle.getMessage(SunJDBCDriverDeployer.class, (String)"ERR_DeployDriverFailed");
                }
                this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.COMPLETED));
            }
            this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, "", StateType.COMPLETED));
        }

        private List getJdbcDrivers() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            List<File> list = Arrays.asList(this.getJDBCDriversLocation().listFiles());
            for (Datasource datasource : this.datasources) {
                String string = datasource.getDriverClassName();
                boolean bl = false;
                try {
                    bl = Util.containsClass(list, (String)string);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (bl) continue;
                for (DatabaseConnection databaseConnection : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                    JDBCDriver[] jDBCDriverArray;
                    String string2 = databaseConnection.getDriverClass();
                    for (JDBCDriver jDBCDriver : jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string2)) {
                        URL[] uRLArray = jDBCDriver.getURLs();
                        for (int i = 0; i < uRLArray.length; ++i) {
                            URL uRL = uRLArray[i];
                            String string3 = uRL.toString();
                            if (string3.contains("nbinst:/")) {
                                URL uRL2;
                                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                                if (fileObject == null || (uRL2 = URLMapper.findURL((FileObject)fileObject, (int)1)) == null) continue;
                                arrayList.add(uRL2);
                                continue;
                            }
                            arrayList.add(uRL);
                        }
                    }
                }
            }
            return arrayList;
        }

        private File getJDBCDriversLocation() {
            DeploymentManagerProperties deploymentManagerProperties = new DeploymentManagerProperties(SunJDBCDriverDeployer.this.sunDm);
            return deploymentManagerProperties.getDriverLocation();
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.eventSupport.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return null;
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Cancel is not supported");
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Stop is not supported");
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.eventSupport.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.eventSupport.removeProgressListener(progressListener);
        }
    }
}

