/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class HttpMonitorSupport {
    public static final String MONITOR_ENABLED_PROPERTY_NAME = "monitor_enabled";
    private static final String MONITOR_MODULE_NAME = "org.netbeans.modules.web.monitor";
    private static ModuleInfo httpMonitorInfo;
    private static ModuleSpy monitorSpy;
    private static Lookup.Result res;
    private static MonitorInfoListener monitorInfoListener;
    private static MonitorLookupListener monitorLookupListener;
    private static final String MONITOR_FILTER_NAME = "HTTPMonitorFilter";
    private static final String MONITOR_FILTER_CLASS = "org.netbeans.modules.web.monitor.server.MonitorFilter";
    private static final String MONITOR_FILTER_PATTERN = "/*";
    private static final String MONITOR_INTERNALPORT_PARAM_NAME = "netbeans.monitor.ide";

    public static boolean getMonitorFlag(DeploymentManager deploymentManager) {
        DeploymentManagerProperties deploymentManagerProperties = new DeploymentManagerProperties(deploymentManager);
        String string = deploymentManagerProperties.getHttpMonitorOn();
        return string == null ? true : Boolean.valueOf(string);
    }

    public static void setMonitorFlag(DeploymentManager deploymentManager, boolean bl) {
        DeploymentManagerProperties deploymentManagerProperties = new DeploymentManagerProperties(deploymentManager);
        deploymentManagerProperties.setHttpMonitorOn(Boolean.toString(bl));
    }

    public static boolean synchronizeMonitorWithFlag(SunDeploymentManagerInterface sunDeploymentManagerInterface) throws IOException, SAXException {
        boolean bl = HttpMonitorSupport.getMonitorFlag((DeploymentManager)sunDeploymentManagerInterface);
        return HttpMonitorSupport.synchronizeMonitor(sunDeploymentManagerInterface, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean synchronizeMonitor(SunDeploymentManagerInterface sunDeploymentManagerInterface, boolean bl) throws IOException, SAXException {
        boolean bl2 = HttpMonitorSupport.isMonitorEnabled();
        boolean bl3 = bl2 && bl;
        File file = HttpMonitorSupport.getDefaultWebXML(sunDeploymentManagerInterface);
        if (file == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception(""));
            return false;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(file);
        if (webApp == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception(""));
            return false;
        }
        boolean bl4 = false;
        try {
            if (bl3) {
                HttpMonitorSupport.addMonitorJars(sunDeploymentManagerInterface);
                boolean bl5 = HttpMonitorSupport.changeFilterMonitor(webApp, true);
                bl4 = bl4 || bl5;
                bl5 = HttpMonitorSupport.specifyFilterPortParameter(webApp);
                bl4 = bl4 || bl5;
            } else {
                boolean bl6 = HttpMonitorSupport.changeFilterMonitor(webApp, false);
                bl4 = bl4 || bl6;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl4 = false;
            ErrorManager.getDefault().notify(65536, (Throwable)classNotFoundException);
        }
        if (bl4) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                webApp.write((OutputStream)fileOutputStream);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        return bl4;
    }

    private static File getDefaultWebXML(SunDeploymentManagerInterface sunDeploymentManagerInterface) {
        DeploymentManagerProperties deploymentManagerProperties = new DeploymentManagerProperties((DeploymentManager)sunDeploymentManagerInterface);
        String string = deploymentManagerProperties.getLocation() + "/" + deploymentManagerProperties.getDomainName() + "/config/default-web.xml";
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static void addMonitorJars(SunDeploymentManagerInterface sunDeploymentManagerInterface) throws IOException {
        DeploymentManagerProperties deploymentManagerProperties = new DeploymentManagerProperties((DeploymentManager)sunDeploymentManagerInterface);
        String string = deploymentManagerProperties.getLocation() + "/" + deploymentManagerProperties.getDomainName();
        File file = new File(string);
        if (file == null) {
            return;
        }
        HttpMonitorSupport.copyFromIDEInstToDir("modules/ext/org-netbeans-modules-web-httpmonitor.jar", file, "lib/org-netbeans-modules-web-httpmonitor.jar");
    }

    private static boolean changeFilterMonitor(WebApp webApp, boolean bl) throws ClassNotFoundException {
        boolean bl2;
        block8: {
            block7: {
                int n;
                bl2 = false;
                if (!bl) break block7;
                boolean bl3 = false;
                Filter[] filterArray = webApp.getFilter();
                for (n = 0; n < filterArray.length; ++n) {
                    if (!filterArray[n].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    Filter filter = (Filter)webApp.createBean("Filter");
                    filter.setFilterName(MONITOR_FILTER_NAME);
                    filter.setFilterClass(MONITOR_FILTER_CLASS);
                    webApp.addFilter(filter);
                    bl2 = true;
                }
                n = 0;
                FilterMapping[] filterMappingArray = webApp.getFilterMapping();
                for (int i = 0; i < filterMappingArray.length; ++i) {
                    if (!filterMappingArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) break block8;
                FilterMapping filterMapping = (FilterMapping)webApp.createBean("FilterMapping");
                Object[] objectArray = new String[]{"REQUEST", "FORWARD", "INCLUDE", "ERROR"};
                try {
                    filterMapping.setDispatcher((String[])objectArray);
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    ((BaseBean)filterMapping).createProperty("dispatcher", "Dispatcher", 65840, String.class);
                    ((BaseBean)filterMapping).setValue("Dispatcher", objectArray);
                }
                filterMapping.setFilterName(MONITOR_FILTER_NAME);
                filterMapping.setUrlPattern(MONITOR_FILTER_PATTERN);
                webApp.addFilterMapping(filterMapping);
                bl2 = true;
                break block8;
            }
            FilterMapping[] filterMappingArray = webApp.getFilterMapping();
            for (int i = 0; i < filterMappingArray.length; ++i) {
                if (!filterMappingArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilterMapping(filterMappingArray[i]);
                bl2 = true;
                break;
            }
            Filter[] filterArray = webApp.getFilter();
            for (int i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilter(filterArray[i]);
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private static File findInstallationFile(String string) {
        return InstalledFileLocator.getDefault().locate(string, null, false);
    }

    private static void copyFromIDEInstToDir(String string, File file, String string2) throws IOException {
        File file2 = HttpMonitorSupport.findFileUnderBase(file, string2);
        File file3 = HttpMonitorSupport.findInstallationFile(string);
        if (file3 != null && file3.exists() && (!file2.exists() || file3.length() != file2.length())) {
            HttpMonitorSupport.copy(file3, file2);
        }
    }

    private static void copy(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        while ((n = bufferedInputStream.read()) != -1) {
            bufferedOutputStream.write(n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    private static File findFileUnderBase(File file, String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = string.replace('/', File.separatorChar);
        return new File(file, string);
    }

    private static boolean specifyFilterPortParameter(WebApp webApp) throws ClassNotFoundException {
        Filter[] filterArray = webApp.getFilter();
        Filter filter = null;
        for (int i = 0; i < filterArray.length; ++i) {
            if (!MONITOR_FILTER_NAME.equals(filterArray[i].getFilterName())) continue;
            filter = filterArray[i];
            break;
        }
        if (filter == null) {
            return false;
        }
        InitParam[] initParamArray = filter.getInitParam();
        InitParam initParam = null;
        for (int i = 0; i < initParamArray.length; ++i) {
            if (!MONITOR_INTERNALPORT_PARAM_NAME.equals(initParamArray[i].getParamName())) continue;
            initParam = initParamArray[i];
            break;
        }
        String string = HttpMonitorSupport.getLocalHost() + ":" + HttpMonitorSupport.getInternalServerPort();
        if (initParam == null) {
            InitParam initParam2 = (InitParam)filter.createBean("InitParam");
            initParam2.setParamName(MONITOR_INTERNALPORT_PARAM_NAME);
            initParam2.setParamValue(string);
            filter.addInitParam(initParam2);
            return true;
        }
        if (string.equals(initParam.getParamValue())) {
            return false;
        }
        initParam.setParamValue(string);
        return true;
    }

    public static String getLocalHost() {
        return "127.0.0.1";
    }

    private static URL getSampleHTTPServerURL() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("HTTPServer_DUMMY");
        if (fileObject == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        return uRL;
    }

    private static String getInternalServerPort() {
        URL uRL = HttpMonitorSupport.getSampleHTTPServerURL();
        if (uRL != null) {
            return "" + uRL.getPort();
        }
        return "8082";
    }

    private static void startModuleSpy(ModuleSpy moduleSpy) {
        res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Iterator iterator = res.allInstances().iterator();
        String string = moduleSpy.getModuleId();
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
            if (!moduleInfo.getCodeName().startsWith(string)) continue;
            httpMonitorInfo = moduleInfo;
            moduleSpy.setEnabled(moduleInfo.isEnabled());
            monitorInfoListener = new MonitorInfoListener(moduleSpy);
            httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
            break;
        }
        monitorLookupListener = new MonitorLookupListener(moduleSpy, httpMonitorInfo);
        res.addLookupListener((LookupListener)monitorLookupListener);
    }

    static synchronized boolean isMonitorEnabled() {
        if (monitorSpy == null) {
            monitorSpy = new ModuleSpy(MONITOR_MODULE_NAME);
            HttpMonitorSupport.startModuleSpy(monitorSpy);
        }
        return monitorSpy.isEnabled();
    }

    void removeListeners() {
        if (httpMonitorInfo != null) {
            httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
        }
        if (res != null) {
            res.removeLookupListener((LookupListener)monitorLookupListener);
        }
    }

    private static class MonitorLookupListener
    implements LookupListener {
        ModuleSpy spy;
        ModuleInfo httpMonitorInfo;

        MonitorLookupListener(ModuleSpy moduleSpy, ModuleInfo moduleInfo) {
            this.spy = moduleSpy;
            this.httpMonitorInfo = moduleInfo;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Iterator iterator = res.allInstances().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.getCodeName().startsWith(this.spy.getModuleId())) continue;
                this.spy.setEnabled(moduleInfo.isEnabled());
                if (this.httpMonitorInfo == null) {
                    this.httpMonitorInfo = moduleInfo;
                    HttpMonitorSupport.monitorInfoListener = new MonitorInfoListener(this.spy);
                    this.httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                }
                bl = true;
                break;
            }
            if (!bl && this.httpMonitorInfo != null) {
                this.httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                this.httpMonitorInfo = null;
                this.spy.setEnabled(false);
            }
        }
    }

    private static class MonitorInfoListener
    implements PropertyChangeListener {
        ModuleSpy spy;

        MonitorInfoListener(ModuleSpy moduleSpy) {
            this.spy = moduleSpy;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.spy.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class ModuleSpy {
        private boolean enabled;
        private String moduleId;

        public ModuleSpy(String string) {
            this.moduleId = string;
        }

        public void setModuleId(String string) {
            this.moduleId = string;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getModuleId() {
            return this.moduleId;
        }
    }
}

