/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualDirectoryPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class AddDomainDirectoryPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private AddInstanceVisualDirectoryPanel component;
    private WizardDescriptor wiz;
    private final boolean creatingPersonalInstance;
    private final Set listeners = new HashSet(1);

    AddDomainDirectoryPanel(boolean bl) {
        this.creatingPersonalInstance = bl;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddInstanceVisualDirectoryPanel(this.creatingPersonalInstance);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        if (this.creatingPersonalInstance) {
            return new HelpCtx("AS_RegServ_EnterPIDir");
        }
        return new HelpCtx("AS_RegServ_EnterDomainDir");
    }

    public boolean isValid() {
        byte[] byArray;
        if (null == this.wiz) {
            return false;
        }
        File file = new File(((AddInstanceVisualDirectoryPanel)this.getComponent()).getInstanceDirectory());
        if (!this.creatingPersonalInstance) {
            if (((AddInstanceVisualDirectoryPanel)this.getComponent()).getInstanceDirectory().length() < 1) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_EneterValidDomainDir", (Object)((AddInstanceVisualDirectoryPanel)this.getComponent()).getInstanceDirectory()));
                ((AddInstanceVisualDirectoryPanel)this.getComponent()).setAdminPort("");
                return false;
            }
            String string = Util.rootOfUsableDomain(file);
            if (null != string) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)string);
                ((AddInstanceVisualDirectoryPanel)this.getComponent()).setAdminPort("");
                return false;
            }
            Util.fillDescriptorFromDomainXml(this.wiz, file);
            String string2 = (String)this.wiz.getProperty("port");
            ((AddInstanceVisualDirectoryPanel)this.getComponent()).setAdminPort(string2);
            if ("".equals(string2)) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_UnsupportedDomain", (Object)((AddInstanceVisualDirectoryPanel)this.getComponent()).getInstanceDirectory()));
                return false;
            }
            return true;
        }
        File file2 = file.getParentFile();
        if (file.exists()) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_ExistingDomainDir", (Object)file.getAbsolutePath()));
            return false;
        }
        if (null == file2) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDir", (Object)((AddInstanceVisualDirectoryPanel)this.getComponent()).getInstanceDirectory()));
            return false;
        }
        if (!file2.exists()) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDirParent", (Object)file2.getAbsolutePath()));
            return false;
        }
        if (!Utils.canWrite(file2)) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_InValidDomainDirParent", (Object)file2.getAbsolutePath()));
            return false;
        }
        String string = file.getAbsolutePath();
        byte[] byArray2 = byArray = string.getBytes();
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(AddDomainDirectoryPanel.class.getName()).log(Level.FINER, null, unsupportedEncodingException);
        }
        if (byArray.length != byArray2.length) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)"Msg_Utf8Required"));
            return false;
        }
        this.wiz.putProperty("domain", (Object)file.getName());
        this.wiz.putProperty("install_location", (Object)file.getParentFile().getAbsolutePath());
        this.wiz.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        this.wiz = (WizardDescriptor)object;
    }

    public void storeSettings(Object object) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return !this.creatingPersonalInstance;
    }
}

