/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.j2ee.sun.api.Asenv;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Util {
    public static NumericDocument getNumericDocument() {
        return new NumericDocument();
    }

    public static void showInformation(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                message.setTitle(string2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static void showInformationWhenHolding(final String string, final String string2) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                message.setTitle(string2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static void showInformation(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static Object showWarning(String string) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
    }

    public static Object showWarning(String string, String string2) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, string2, 2, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
    }

    public static void showError(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static void showError(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                message.setTitle(string2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static void setStatusBar(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusDisplayer.getDefault().setStatusText(string);
            }
        });
    }

    static File[] getRegisterableDefaultDomains(File file) {
        File[] fileArray = new File[]{};
        Asenv asenv = new Asenv(file);
        String string = asenv.get("AS_DEF_DOMAINS_PATH");
        if (string == null || string.trim().length() < 1) {
            Logger.getLogger(Util.class.getName()).finer("defDomainsDirName was bad for location: " + file.getAbsolutePath());
            return fileArray;
        }
        File file2 = new File(string);
        if (!file2.exists() && file.getAbsolutePath().startsWith("/opt/SUNWappserver")) {
            file2 = new File("/var/opt/SUNWappserver/domains");
        }
        if (!file2.exists()) {
            return fileArray;
        }
        File[] fileArray2 = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && Utils.canWrite(file);
            }
        });
        if (null == fileArray2) {
            return fileArray;
        }
        int n = 0;
        for (int i = 0; i < fileArray2.length; ++i) {
            String string2 = Util.rootOfUsableDomain(fileArray2[i]);
            if (null == string2) {
                ++n;
                continue;
            }
            fileArray2[i] = null;
        }
        File[] fileArray3 = new File[n];
        int n2 = 0;
        for (int i = 0; i < fileArray2.length; ++i) {
            if (fileArray2[i] == null) continue;
            fileArray3[n2] = fileArray2[i];
            ++n2;
        }
        return fileArray3;
    }

    static String rootOfUsableDomain(File file) {
        if (!file.exists()) {
            return NbBundle.getMessage(Util.class, (String)"ERROR_DOMAIN_ROOT_DOES_NOT_EXIST");
        }
        File file2 = new File(file, "config");
        File file3 = new File(file2, "domain.xml");
        if (!file3.exists()) {
            return NbBundle.getMessage(Util.class, (String)"ERROR_CANNOT_FIND_DOMAIN");
        }
        if (!Utils.canWrite(file3)) {
            return NbBundle.getMessage(Util.class, (String)"ERROR_CANNOT_WRITE_TO_DOMAIN");
        }
        if (!(file2.exists() && file2.isDirectory() && Utils.canWrite(file2))) {
            return NbBundle.getMessage(Util.class, (String)"ERROR_CANNOT_WRITE_TO_CONFIG");
        }
        file2 = new File(file, "logs");
        if (!(file2.exists() && file2.isDirectory() && Utils.canWrite(file2))) {
            return NbBundle.getMessage(Util.class, (String)"ERROR_CANNOT_WRITE_TO_LOG");
        }
        return null;
    }

    public static String getHostPort(File file, File file2) {
        File file3 = File.pathSeparatorChar == ':' ? new File(file.getAbsolutePath() + "/config/domain.xml") : new File(file.getAbsolutePath() + "\\config\\domain.xml");
        String string = null;
        try {
            Class[] classArray = new Class[]{File.class, File.class};
            Object[] objectArray = new Object[]{file3, file2};
            ClassLoader classLoader = ServerLocationManager.getServerOnlyClassLoader((File)file2);
            if (classLoader != null) {
                Class<?> clazz = classLoader.loadClass("org.netbeans.modules.j2ee.sun.bridge.AppServerBridge");
                Method method = clazz.getMethod("getHostPort", classArray);
                string = (String)method.invoke(null, objectArray);
            }
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(Util.class.getName()).log(Level.WARNING, "", runtimeException);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    static String getDeploymentUri(File file, File file2) {
        return "deployer:Sun:AppServer::" + Util.getHostPort(file, file2);
    }

    static File domainFile(File file) {
        if (File.pathSeparatorChar == ';') {
            return new File(file + "\\config\\domain.xml");
        }
        return new File(file + "/config/domain.xml");
    }

    static void fillDescriptorFromDomainXml(WizardDescriptor wizardDescriptor, File file) {
        String string = Util.getHostPort(file, (File)wizardDescriptor.getProperty("platform_location"));
        if (null != string) {
            wizardDescriptor.putProperty("domain_file", (Object)Util.domainFile(file));
            int n = string.indexOf(58);
            wizardDescriptor.putProperty("host", (Object)string.substring(0, n));
            wizardDescriptor.putProperty("port", (Object)string.substring(n + 1));
            wizardDescriptor.putProperty("domain", (Object)file.getName());
            wizardDescriptor.putProperty("install_location", (Object)file.getParentFile().getAbsolutePath());
            wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        } else {
            wizardDescriptor.putProperty("host", (Object)"");
            wizardDescriptor.putProperty("port", (Object)"");
            wizardDescriptor.putProperty("domain", (Object)"");
            wizardDescriptor.putProperty("install_location", (Object)"");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        }
    }

    static JFileChooser getJFileChooser(javax.swing.filechooser.FileFilter fileFilter) {
        JFileChooser jFileChooser = new JFileChooser();
        Util.decorateChooser(jFileChooser, null, NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        return jFileChooser;
    }

    static void decorateChooser(JFileChooser jFileChooser, String string, String string2) {
        jFileChooser.setDialogTitle(string2);
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(Util.class, (String)"Choose_Button_Mnemonic").charAt(0));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setApproveButtonToolTipText(NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        jFileChooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        jFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Util.class, (String)"LBL_Chooser_Name"));
        if (null != string && string.length() > 0) {
            File file = new File(string);
            if (file.isDirectory()) {
                jFileChooser.setCurrentDirectory(file);
            } else {
                jFileChooser.setSelectedFile(file);
            }
        }
    }

    public static class NumericDocument
    extends PlainDocument {
        private final Toolkit toolkit = Toolkit.getDefaultToolkit();

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                this.toolkit.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

