/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BPELNode {
    public static final String RECEIVE = "receive";
    public static final String REPLY = "reply";
    public static final String INVOKE = "invoke";
    public static final String ASSIGN = "assign";
    public static final String THROW = "throw";
    public static final String TERMINATE = "exit";
    public static final String WAIT = "wait";
    public static final String EMPTY = "empty";
    public static final String SEQUENCE = "sequence";
    public static final String SWITCH = "switch";
    public static final String IF = "if";
    public static final String WHILE = "while";
    public static final String REPEAT_UNTIL = "repeatUntil";
    public static final String FOREACH = "forEach";
    public static final String PICK = "pick";
    public static final String FLOW = "flow";
    public static final String SCOPE = "scope";
    public static final String COMPENSATE = "compensate";
    public static final String COMPENSATE_SCOPE = "compensateScope";
    public static final String RETHROW = "rethrow";
    public static final String VALIDATE = "validate";
    private static HashMap ALL_ACTIVITIES_MAP = new HashMap();
    private final int mLineNo;
    private final String mName;
    private final String mXpath;
    private final BPELNodeType mType;
    private final boolean mActivityFlag;
    private final String mTargetNameSpace;
    private int mClosingNo;
    private List mChildren = new ArrayList();
    private BPELNode mParent;

    public static BPELNodeType getNodeType(String string) {
        return ALL_ACTIVITIES_MAP.get(string) != null ? (BPELNodeType)ALL_ACTIVITIES_MAP.get(string) : BPELNodeType.NONE_ACTIVITY_TYPE;
    }

    public BPELNode(String string, int n, String string2, BPELNodeType bPELNodeType, BPELNode bPELNode) {
        this.mName = string;
        this.mLineNo = n;
        this.mTargetNameSpace = string2;
        this.mType = bPELNodeType;
        this.mActivityFlag = BPELNode.getNodeType(string) != BPELNodeType.NONE_ACTIVITY_TYPE;
        this.mParent = bPELNode;
        this.mXpath = this.constructXpath();
    }

    public boolean isActivity() {
        return this.mActivityFlag;
    }

    private String constructXpath() {
        String string = "/";
        if (this.mParent == null) {
            return string + this.mName;
        }
        String string2 = this.mParent.getXpath();
        List list = this.mParent.getChildren();
        int n = 1;
        for (int i = 0; i < list.size(); ++i) {
            BPELNode bPELNode = (BPELNode)list.get(i);
            if (bPELNode.getType() != this.mType) continue;
            ++n;
        }
        return string2 + "/" + this.mName + "[" + n + "]";
    }

    public String getName() {
        return this.mName;
    }

    public BPELNodeType getType() {
        return this.mType;
    }

    public List getChildren() {
        return this.mChildren;
    }

    public void addChild(BPELNode bPELNode) {
        this.mChildren.add(bPELNode);
    }

    public String getXpath() {
        return this.mXpath;
    }

    public int getLineNumber() {
        return this.mLineNo;
    }

    public BPELNode getParent() {
        return this.mParent;
    }

    public String getTargetNameSpace() {
        return this.mTargetNameSpace;
    }

    public void setClosingNumber(int n) {
        this.mClosingNo = n;
    }

    public int getClosingNumber() {
        return this.mClosingNo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BPELNode)) {
            return false;
        }
        return ((BPELNode)object).mTargetNameSpace.equals(this.mTargetNameSpace) && ((BPELNode)object).mXpath.equals(this.mXpath);
    }

    public int hashCode() {
        return (this.mXpath.hashCode() + this.mTargetNameSpace.hashCode()) * 37;
    }

    public String toString() {
        return "targetNameSpace:" + this.mTargetNameSpace + "   name:" + this.mName + "   lineNo:" + this.mLineNo + "   xPath:" + this.mXpath;
    }

    static {
        ALL_ACTIVITIES_MAP.put(RECEIVE, BPELNodeType.RECEIVE_TYPE);
        ALL_ACTIVITIES_MAP.put(REPLY, BPELNodeType.REPLY_TYPE);
        ALL_ACTIVITIES_MAP.put(INVOKE, BPELNodeType.INVOKE_TYPE);
        ALL_ACTIVITIES_MAP.put(ASSIGN, BPELNodeType.ASSIGN_TYPE);
        ALL_ACTIVITIES_MAP.put(THROW, BPELNodeType.THROW_TYPE);
        ALL_ACTIVITIES_MAP.put(TERMINATE, BPELNodeType.TERMINATE_TYPE);
        ALL_ACTIVITIES_MAP.put(WAIT, BPELNodeType.WAIT_TYPE);
        ALL_ACTIVITIES_MAP.put(EMPTY, BPELNodeType.EMPTY_TYPE);
        ALL_ACTIVITIES_MAP.put(SEQUENCE, BPELNodeType.SEQUENCE_TYPE);
        ALL_ACTIVITIES_MAP.put(IF, BPELNodeType.IF_TYPE);
        ALL_ACTIVITIES_MAP.put(REPEAT_UNTIL, BPELNodeType.REPEAT_UNTIL_TYPE);
        ALL_ACTIVITIES_MAP.put(FOREACH, BPELNodeType.FOREACH_TYPE);
        ALL_ACTIVITIES_MAP.put(SWITCH, BPELNodeType.SWITCH_TYPE);
        ALL_ACTIVITIES_MAP.put(WHILE, BPELNodeType.WHILE_TYPE);
        ALL_ACTIVITIES_MAP.put(PICK, BPELNodeType.PICK_TYPE);
        ALL_ACTIVITIES_MAP.put(FLOW, BPELNodeType.FLOW_TYPE);
        ALL_ACTIVITIES_MAP.put(SCOPE, BPELNodeType.SCOPE_TYPE);
        ALL_ACTIVITIES_MAP.put(COMPENSATE, BPELNodeType.COMPENSATE_TYPE);
        ALL_ACTIVITIES_MAP.put(COMPENSATE_SCOPE, BPELNodeType.COMPENSATE_SCOPE_TYPE);
        ALL_ACTIVITIES_MAP.put(RETHROW, BPELNodeType.RETHROW_TYPE);
        ALL_ACTIVITIES_MAP.put(VALIDATE, BPELNodeType.VALIDATE_TYPE);
    }

    public static final class BPELNodeType {
        private String mName;
        private static final String NONE_ACTIVITY = "NoneActivity";
        public static final BPELNodeType RECEIVE_TYPE = new BPELNodeType("receive");
        public static final BPELNodeType REPLY_TYPE = new BPELNodeType("reply");
        public static final BPELNodeType INVOKE_TYPE = new BPELNodeType("invoke");
        public static final BPELNodeType ASSIGN_TYPE = new BPELNodeType("assign");
        public static final BPELNodeType THROW_TYPE = new BPELNodeType("throw");
        public static final BPELNodeType TERMINATE_TYPE = new BPELNodeType("exit");
        public static final BPELNodeType WAIT_TYPE = new BPELNodeType("wait");
        public static final BPELNodeType EMPTY_TYPE = new BPELNodeType("empty");
        public static final BPELNodeType SEQUENCE_TYPE = new BPELNodeType("sequence");
        public static final BPELNodeType IF_TYPE = new BPELNodeType("if");
        public static final BPELNodeType SWITCH_TYPE = new BPELNodeType("switch");
        public static final BPELNodeType REPEAT_UNTIL_TYPE = new BPELNodeType("repeatUntil");
        public static final BPELNodeType WHILE_TYPE = new BPELNodeType("while");
        public static final BPELNodeType FOREACH_TYPE = new BPELNodeType("forEach");
        public static final BPELNodeType PICK_TYPE = new BPELNodeType("pick");
        public static final BPELNodeType FLOW_TYPE = new BPELNodeType("flow");
        public static final BPELNodeType SCOPE_TYPE = new BPELNodeType("scope");
        public static final BPELNodeType COMPENSATE_SCOPE_TYPE = new BPELNodeType("compensateScope");
        public static final BPELNodeType RETHROW_TYPE = new BPELNodeType("rethrow");
        public static final BPELNodeType VALIDATE_TYPE = new BPELNodeType("validate");
        public static final BPELNodeType COMPENSATE_TYPE = new BPELNodeType("compensate");
        public static final BPELNodeType NONE_ACTIVITY_TYPE = new BPELNodeType("NoneActivity");

        private BPELNodeType(String string) {
            this.mName = string;
        }

        public boolean equals(Object object) {
            if (object instanceof BPELNodeType) {
                return false;
            }
            return ((BPELNodeType)object).mName.equals(this.mName);
        }

        public int hashCode() {
            return this.mName.hashCode();
        }

        public String toString() {
            return "Type:" + this.mName;
        }
    }
}

