/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.core.debugger.DebuggerHelper;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelBreakpointListener;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class DebuggerHelperImpl
implements DebuggerHelper {
    private BpelBreakpointListener myBreakpointAnnotationListener;

    public void toggleBreakpointEnabledState(Node node, BpelEntity bpelEntity) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return;
        }
        int n = EditorUtil.getLineNumber(node);
        if (n < 1) {
            return;
        }
        String string = ModelUtil.getXpath(bpelEntity.getUID());
        if (string == null) {
            return;
        }
        String string2 = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getPath().replace("\\", "/");
        LineBreakpoint lineBreakpoint = this.getBreakpointAnnotationListener().findBreakpoint(string2, string, n);
        if (lineBreakpoint != null) {
            if (lineBreakpoint.isEnabled()) {
                lineBreakpoint.disable();
            } else {
                lineBreakpoint.enable();
            }
        }
    }

    public void enableBreakpoints(BpelEntity bpelEntity) {
        List<LineBreakpoint> list = this.getBreakpointAnnotationListener().getBreakpoints();
        String string = ModelUtil.getXpath(bpelEntity.getUID());
        for (LineBreakpoint lineBreakpoint : list) {
            Object object;
            String string2;
            if (lineBreakpoint.isEnabled() || !(string2 = EditorContextBridge.getXpath((Object)(object = this.getBreakpointAnnotationListener().findAnnotation(lineBreakpoint)))).startsWith(string)) continue;
            lineBreakpoint.enable();
        }
    }

    public void disableBreakpoints(BpelEntity bpelEntity) {
        List<LineBreakpoint> list = this.getBreakpointAnnotationListener().getBreakpoints();
        String string = ModelUtil.getXpath(bpelEntity.getUID());
        for (LineBreakpoint lineBreakpoint : list) {
            Object object;
            String string2;
            if (!lineBreakpoint.isEnabled() || !(string2 = EditorContextBridge.getXpath((Object)(object = this.getBreakpointAnnotationListener().findAnnotation(lineBreakpoint)))).startsWith(string)) continue;
            lineBreakpoint.disable();
        }
    }

    public void deleteBreakpoints(BpelEntity bpelEntity) {
        List<LineBreakpoint> list = this.getBreakpointAnnotationListener().getBreakpoints();
        String string = ModelUtil.getXpath(bpelEntity.getUID());
        for (LineBreakpoint lineBreakpoint : list) {
            Object object = this.getBreakpointAnnotationListener().findAnnotation(lineBreakpoint);
            String string2 = EditorContextBridge.getXpath((Object)object);
            if (!string2.startsWith(string)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lineBreakpoint);
        }
    }

    private BpelBreakpointListener getBreakpointAnnotationListener() {
        if (this.myBreakpointAnnotationListener == null) {
            this.myBreakpointAnnotationListener = (BpelBreakpointListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BpelBreakpointListener.class));
        }
        return this.myBreakpointAnnotationListener;
    }
}

