/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static DocumentBuilder cDocumentBuilder;

    private XmlUtil() {
    }

    public static String toString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = null;
        transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            return "";
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            return "";
        }
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            return "";
        }
        return stringWriter.toString();
    }

    public static boolean isTextOnlyNode(Node node) {
        NodeList nodeList;
        return node.getNodeType() == 1 && (nodeList = node.getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3;
    }

    public static Element parseXmlElement(String string) {
        Document document = null;
        if (string != null && string.length() > 0) {
            InputSource inputSource = new InputSource(new StringReader(string));
            try {
                document = XmlUtil.getDocumentBuilder().parse(inputSource);
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (cDocumentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(false);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(false);
            cDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        return cDocumentBuilder;
    }
}

