/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.watch;

import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.InvalidStateException;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.openide.util.NbBundle;

public class BpelWatch {
    private BpelDebugger myDebugger;
    private Watch myNbWatch;
    private Value myValue;
    private Exception myException;

    public BpelWatch(BpelDebugger bpelDebugger, Watch watch) {
        this.myDebugger = bpelDebugger;
        this.myNbWatch = watch;
        this.evaluate();
    }

    public String getExpression() {
        return this.myNbWatch.getExpression();
    }

    public void setExpression(String string) {
        this.myNbWatch.setExpression(string);
    }

    public void remove() {
        this.myNbWatch.remove();
    }

    public Exception getException() {
        return this.myException;
    }

    public Value getValue() {
        return this.myValue;
    }

    public Watch getNbWatch() {
        return this.myNbWatch;
    }

    private void evaluate() {
        ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
        if (processInstance != null) {
            try {
                this.myValue = processInstance.evaluate(this.myNbWatch.getExpression());
            }
            catch (Exception exception) {
                this.myException = exception;
            }
        } else {
            this.myException = new InvalidStateException(NbBundle.getMessage(BpelWatch.class, (String)"BW_NoPI"));
        }
    }
}

