/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class JGoArea
extends JGoObject
implements JGoObjectCollection {
    public static final int ChangedPickableBackground = 1900;
    private static final int ChangedNoClear = 1901;
    static final int flagPickableBackground = 32768;
    private JGoObjList myChildren = new JGoObjList(true);
    private JGoListPosition myCurrentListPosition = null;

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoArea newobj = (JGoArea)super.copyObject(env);
        if (newobj != null) {
            boolean oldInit = newobj.isInitializing();
            newobj.setInitializing(true);
            this.copyChildren(newobj, env);
            newobj.setInitializing(oldInit);
        }
        return newobj;
    }

    protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            newarea.addObjectAtTailInternal(env.copy(obj), true);
        }
    }

    void setLayer(JGoLayer layer, int mode, Object nextobj, JGoObject mainObject) {
        if (layer != null) {
            super.setLayer(layer, mode, nextobj, mainObject);
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPos(pos);
                obj.setLayer(layer, -1, null, mainObject);
            }
        } else {
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPos(pos);
                obj.setLayer(null, -1, null, mainObject);
            }
            super.setLayer(null, mode, nextobj, mainObject);
        }
    }

    void setView(JGoView view, JGoObject mainObject) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            obj.setView(view, mainObject);
        }
        super.setView(view, mainObject);
    }

    public void setPickableBackground(boolean bFlag) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x8000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x8000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFF7FFF);
            }
            this.update(1900, old ? 1 : 0, null);
        }
    }

    public boolean isPickableBackground() {
        return (this.getInternalFlags() & 0x8000) != 0;
    }

    public JGoObject pick(Point p, boolean selectableOnly) {
        if (!this.isVisible()) {
            return null;
        }
        if (!this.getBoundingRect().contains(p.x, p.y)) {
            return null;
        }
        JGoObject picked = this.pickObject(p, selectableOnly);
        if (picked != null) {
            return picked;
        }
        if (this.isPickableBackground()) {
            if (!selectableOnly) {
                return this;
            }
            if (this.isSelectable()) {
                return this;
            }
            for (JGoArea obj = this.getParent(); obj != null; obj = obj.getParent()) {
                if (!obj.isSelectable()) continue;
                return obj;
            }
        }
        return null;
    }

    public JGoObject pickObject(Point pointToCheck, boolean selectableOnly) {
        if (!this.getBoundingRect().contains(pointToCheck.x, pointToCheck.y)) {
            return null;
        }
        JGoListPosition pos = this.getLastObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getPrevObjectPos(pos);
            JGoObject picked = obj.pick(pointToCheck, selectableOnly);
            if (picked == null) continue;
            return picked;
        }
        return null;
    }

    public ArrayList pickObjects(Point p, boolean selectableOnly, ArrayList coll, int max) {
        if (coll == null) {
            coll = new ArrayList<JGoObject>();
        }
        if (coll.size() >= max) {
            return coll;
        }
        if (!this.isVisible()) {
            return coll;
        }
        JGoObject picked = this.pickObject(p, selectableOnly);
        if (picked != null) {
            coll.add(picked);
        }
        return coll;
    }

    public boolean getNearestIntersectionPoint(int px, int py, int cx, int cy, Point result) {
        double closestdist = 1.0E21;
        int closestx = cx;
        int closesty = cy;
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            double dist;
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (!obj.isVisible() || !obj.getNearestIntersectionPoint(px, py, cx, cy, result) || !((dist = (double)((result.x - px) * (result.x - px) + (result.y - py) * (result.y - py))) < closestdist)) continue;
            closestdist = dist;
            closestx = result.x;
            closesty = result.y;
        }
        result.x = closestx;
        result.y = closesty;
        return closestdist < 1.0E21;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoArea = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoArea", jGoElementGroup);
        }
        DomElement areaGroup = jGoElementGroup;
        if (svgDoc.JGoXMLOutputEnabled() || svgDoc.SVGOutputEnabled()) {
            areaGroup = svgDoc.createElement("g");
            jGoElementGroup.appendChild(areaGroup);
        }
        JGoListPosition pos = this.getFirstObjectPos();
        DomElement subGroup = areaGroup;
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (svgDoc.JGoXMLOutputEnabled() || svgDoc.SVGOutputEnabled()) {
                subGroup = svgDoc.createElement("g");
                areaGroup.appendChild(subGroup);
            }
            boolean saveIsGenerateSVG = svgDoc.isGenerateSVG();
            if (!obj.isVisible()) {
                svgDoc.setGenerateSVG(false);
            }
            obj.SVGWriteObject(svgDoc, subGroup);
            svgDoc.setGenerateSVG(saveIsGenerateSVG);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            DomElement childGroup = jGoChildElement.getNextSiblingElement();
            svgDoc.SVGTraverseChildren(jGoDoc, childGroup, this, true);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, childGroup.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void paint(Graphics2D g, JGoView view) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (!obj.isVisible()) continue;
            obj.paint(g, view);
        }
    }

    public void expandRectByPenWidth(Rectangle rect) {
        int left = rect.x;
        int top = rect.y;
        int right = left + rect.width;
        int bottom = top + rect.height;
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            Rectangle b = obj.getBoundingRect();
            rect.x = b.x;
            rect.y = b.y;
            rect.width = b.width;
            rect.height = b.height;
            obj.expandRectByPenWidth(rect);
            left = Math.min(left, rect.x);
            top = Math.min(top, rect.y);
            right = Math.max(right, rect.x + rect.width);
            bottom = Math.max(bottom, rect.y + rect.height);
        }
        rect.x = left;
        rect.y = top;
        rect.width = right - left;
        rect.height = bottom - top;
    }

    private boolean mightShrink(Rectangle prevRect, int x, int y, int w, int h) {
        Rectangle thisRect = this.getBoundingRect();
        if (thisRect.x == prevRect.x && x > thisRect.x) {
            return true;
        }
        if (thisRect.y == prevRect.y && y > thisRect.y) {
            return true;
        }
        int thisRight = thisRect.x + thisRect.width;
        int thisBottom = thisRect.y + thisRect.height;
        int childRight = x + w;
        int childBottom = y + h;
        if (thisRight == prevRect.x + prevRect.width && childRight < thisRight) {
            return true;
        }
        return thisBottom == prevRect.y + prevRect.height && childBottom < thisBottom;
    }

    protected Rectangle computeBoundingRect() {
        Rectangle rect = null;
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (obj.isBoundingRectInvalid()) continue;
            if (rect == null) {
                Rectangle b = obj.getBoundingRect();
                rect = new Rectangle(b.x, b.y, b.width, b.height);
                continue;
            }
            rect.add(obj.getBoundingRect());
        }
        return rect;
    }

    protected void geometryChange(Rectangle prevRect) {
        Rectangle r = this.getBoundingRect();
        if (prevRect.width == r.width && prevRect.height == r.height) {
            this.moveChildren(prevRect);
        } else {
            this.rescaleChildren(prevRect);
            this.layoutChildren(null);
            this.setBoundingRectInvalid(true);
        }
    }

    protected boolean geometryChangeChild(JGoObject child, Rectangle prevRect) {
        this.layoutChildren(child);
        this.setBoundingRectInvalid(true);
        return true;
    }

    protected void moveChildren(Rectangle prevRect) {
        int offsety;
        int offsetx;
        JGoObject obj;
        Rectangle thisRect = this.getBoundingRect();
        if (prevRect.equals(thisRect)) {
            return;
        }
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (!(obj instanceof JGoLink)) continue;
            offsetx = obj.getLeft() - prevRect.x;
            offsety = obj.getTop() - prevRect.y;
            obj.setBoundingRect(thisRect.x + offsetx, thisRect.y + offsety, obj.getWidth(), obj.getHeight());
        }
        pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (obj instanceof JGoLink || obj.getPartner() instanceof JGoLabeledLink) continue;
            offsetx = obj.getLeft() - prevRect.x;
            offsety = obj.getTop() - prevRect.y;
            obj.setBoundingRect(thisRect.x + offsetx, thisRect.y + offsety, obj.getWidth(), obj.getHeight());
        }
    }

    protected void rescaleChildren(Rectangle prevRect) {
        int newRectheight;
        int newRectwidth;
        int newRecty;
        int newRectx;
        Rectangle childRect;
        JGoObject obj;
        Rectangle thisRect = this.getBoundingRect();
        if (prevRect.equals(thisRect)) {
            return;
        }
        double scaleFactorX = 1.0;
        if (prevRect.width != 0) {
            scaleFactorX = (double)thisRect.width / (double)prevRect.width;
        }
        double scaleFactorY = 1.0;
        if (prevRect.height != 0) {
            scaleFactorY = (double)thisRect.height / (double)prevRect.height;
        }
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (!obj.isAutoRescale() || !(obj instanceof JGoLink)) continue;
            childRect = obj.getBoundingRect();
            newRectx = thisRect.x + (int)Math.rint((double)(childRect.x - prevRect.x) * scaleFactorX);
            newRecty = thisRect.y + (int)Math.rint((double)(childRect.y - prevRect.y) * scaleFactorY);
            newRectwidth = (int)Math.rint((double)childRect.width * scaleFactorX);
            newRectheight = (int)Math.rint((double)childRect.height * scaleFactorY);
            obj.setBoundingRect(newRectx, newRecty, newRectwidth, newRectheight);
        }
        pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (!obj.isAutoRescale() || obj instanceof JGoLink) continue;
            childRect = obj.getBoundingRect();
            newRectx = thisRect.x + (int)Math.rint((double)(childRect.x - prevRect.x) * scaleFactorX);
            newRecty = thisRect.y + (int)Math.rint((double)(childRect.y - prevRect.y) * scaleFactorY);
            newRectwidth = (int)Math.rint((double)childRect.width * scaleFactorX);
            newRectheight = (int)Math.rint((double)childRect.height * scaleFactorY);
            obj.setBoundingRect(newRectx, newRecty, newRectwidth, newRectheight);
        }
    }

    public void layoutChildren(JGoObject childchanged) {
    }

    public int getNumObjects() {
        return this.myChildren.getNumObjects();
    }

    public boolean isEmpty() {
        return this.myChildren.isEmpty();
    }

    public JGoListPosition addObjectAtHead(JGoObject obj) {
        return this.addObjectAtHeadInternal(obj, false);
    }

    JGoListPosition addObjectAtHeadInternal(JGoObject obj, boolean undoing) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            if (obj.getParent() != this) {
                return null;
            }
            JGoListPosition pos = this.myChildren.getFirstObjectPos();
            if (this.myChildren.getObjectAtPos(pos) == obj) {
                return pos;
            }
            pos = this.myChildren.findObject(obj);
            JGoListPosition nextobjpos = this.myChildren.getNextObjectPos(pos);
            JGoObject nextobj = this.myChildren.getObjectAtPos(nextobjpos);
            this.myChildren.removeObjectAtPos(pos);
            JGoListPosition objpos = this.myChildren.addObjectAtHead(obj);
            if (nextobj != null) {
                obj.update(10, 1, nextobj);
            } else {
                obj.update(10, 0, this);
            }
            return objpos;
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        JGoListPosition objpos = this.myChildren.addObjectAtHead(obj);
        obj.setParent(this);
        JGoLayer layer = this.getLayer();
        if (layer != null) {
            obj.setLayer(layer, 6, this, obj);
        } else {
            JGoView view = this.getView();
            if (view != null) {
                obj.setView(view, obj);
            }
        }
        if (!undoing) {
            this.geometryChangeChild(obj, obj.getBoundingRect());
            this.setBoundingRectInvalid(true);
        }
        return objpos;
    }

    public JGoListPosition addObjectAtTail(JGoObject obj) {
        return this.addObjectAtTailInternal(obj, false);
    }

    JGoListPosition addObjectAtTailInternal(JGoObject obj, boolean undoing) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            if (obj.getParent() != this) {
                return null;
            }
            JGoListPosition pos = this.myChildren.getLastObjectPos();
            if (this.myChildren.getObjectAtPos(pos) == obj) {
                return pos;
            }
            pos = this.myChildren.findObject(obj);
            JGoListPosition nextobjpos = this.myChildren.getNextObjectPos(pos);
            JGoObject nextobj = this.myChildren.getObjectAtPos(nextobjpos);
            this.myChildren.removeObjectAtPos(pos);
            JGoListPosition objpos = this.myChildren.addObjectAtTail(obj);
            if (nextobj != null) {
                obj.update(10, 1, nextobj);
            } else {
                obj.update(10, 0, this);
            }
            return objpos;
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        JGoListPosition objpos = this.myChildren.addObjectAtTail(obj);
        obj.setParent(this);
        JGoLayer layer = this.getLayer();
        if (layer != null) {
            obj.setLayer(layer, 2, this, obj);
        } else {
            JGoView view = this.getView();
            if (view != null) {
                obj.setView(view, obj);
            }
        }
        if (!undoing) {
            this.geometryChangeChild(obj, obj.getBoundingRect());
            this.setBoundingRectInvalid(true);
        }
        return objpos;
    }

    public JGoListPosition insertObjectBefore(JGoListPosition pos, JGoObject obj) {
        return this.insertObjectBeforeInternal(pos, obj, false);
    }

    JGoListPosition insertObjectBeforeInternal(JGoListPosition pos, JGoObject obj, boolean undoing) {
        if (pos == null || obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            if (obj.getParent() != this) {
                return null;
            }
            JGoListPosition oldpos = this.myChildren.findObject(obj);
            if (oldpos != null) {
                JGoListPosition nextobjpos = this.myChildren.getNextObjectPos(oldpos);
                JGoObject nextobj = this.myChildren.getObjectAtPos(nextobjpos);
                this.myChildren.removeObjectAtPos(oldpos);
                JGoListPosition objpos = this.myChildren.insertObjectBefore(pos, obj);
                if (nextobj != null) {
                    obj.update(10, 1, nextobj);
                } else {
                    obj.update(10, 0, this);
                }
                return objpos;
            }
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        JGoListPosition objpos = this.myChildren.insertObjectBefore(pos, obj);
        obj.setParent(this);
        JGoLayer layer = this.getLayer();
        if (layer != null) {
            JGoObject nextobj = this.myChildren.getObjectAtPos(pos);
            obj.setLayer(layer, 8, nextobj, obj);
        } else {
            JGoView view = this.getView();
            if (view != null) {
                obj.setView(view, obj);
            }
        }
        if (!undoing) {
            this.geometryChangeChild(obj, obj.getBoundingRect());
            this.setBoundingRectInvalid(true);
        }
        return objpos;
    }

    public JGoListPosition insertObjectAfter(JGoListPosition pos, JGoObject obj) {
        return this.insertObjectAfterInternal(pos, obj, false);
    }

    JGoListPosition insertObjectAfterInternal(JGoListPosition pos, JGoObject obj, boolean undoing) {
        if (pos == null || obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            if (obj.getParent() != this) {
                return null;
            }
            JGoListPosition oldpos = this.myChildren.findObject(obj);
            if (oldpos != null) {
                JGoListPosition nextobjpos = this.myChildren.getNextObjectPos(oldpos);
                JGoObject nextobj = this.myChildren.getObjectAtPos(nextobjpos);
                this.myChildren.removeObjectAtPos(oldpos);
                JGoListPosition objpos = this.myChildren.insertObjectAfter(pos, obj);
                if (nextobj != null) {
                    obj.update(10, 1, nextobj);
                } else {
                    obj.update(10, 0, this);
                }
                return objpos;
            }
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        JGoListPosition objpos = this.myChildren.insertObjectAfter(pos, obj);
        obj.setParent(this);
        JGoLayer layer = this.getLayer();
        if (layer != null) {
            JGoObject prevobj = this.myChildren.getObjectAtPos(pos);
            obj.setLayer(layer, 4, prevobj, obj);
        } else {
            JGoView view = this.getView();
            if (view != null) {
                obj.setView(view, obj);
            }
        }
        if (!undoing) {
            this.geometryChangeChild(obj, obj.getBoundingRect());
            this.setBoundingRectInvalid(true);
        }
        return objpos;
    }

    public void bringObjectToFront(JGoObject obj) {
        this.addObjectAtTail(obj);
    }

    public void sendObjectToBack(JGoObject obj) {
        this.addObjectAtHead(obj);
    }

    public void removeObject(JGoObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.getParent() != this) {
            return;
        }
        JGoListPosition pos = this.myChildren.findObject(obj);
        if (pos != null) {
            this.removeObjectAtPos(pos);
        }
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoListPosition nextpos = this.myChildren.getNextObjectPos(pos);
        JGoListPosition prevpos = this.myChildren.getPrevObjectPos(pos);
        JGoObject obj = this.myChildren.removeObjectAtPos(pos);
        if (obj != null) {
            Rectangle rect;
            if (!this.isEmpty() && this.mightShrink(rect = this.getBoundingRect(), (rect.x + rect.width) / 2, (rect.y + rect.height) / 2, 0, 0)) {
                this.setBoundingRectInvalid(true);
            }
            if (obj.getLayer() != null) {
                JGoObject nextobj = this.getObjectAtPos(nextpos);
                if (nextobj == null) {
                    obj.setLayer(null, 2, this, obj);
                } else {
                    JGoObject prevobj = this.getObjectAtPos(prevpos);
                    if (prevobj == null) {
                        obj.setLayer(null, 6, this, obj);
                    } else {
                        Object[] info = new Object[]{this, prevobj, nextobj};
                        obj.setLayer(null, 0, info, obj);
                    }
                }
            } else if (obj.getView() != null) {
                obj.setView(null, obj);
            }
            this.geometryChangeChild(obj, obj.getBoundingRect());
            this.setBoundingRectInvalid(true);
            obj.setParent(null);
        }
        return obj;
    }

    public JGoListPosition getFirstObjectPos() {
        return this.myChildren.getFirstObjectPos();
    }

    public JGoListPosition getLastObjectPos() {
        return this.myChildren.getLastObjectPos();
    }

    public JGoListPosition getNextObjectPos(JGoListPosition pos) {
        return this.myChildren.getNextObjectPos(pos);
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition pos) {
        return this.myChildren.getNextObjectPos(pos);
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition pos) {
        return this.myChildren.getPrevObjectPos(pos);
    }

    public JGoObject getObjectAtPos(JGoListPosition pos) {
        return this.myChildren.getObjectAtPos(pos);
    }

    public JGoListPosition findObject(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() == this) {
            return this.myChildren.findObject(obj);
        }
        return null;
    }

    void setCurrentListPosition(JGoListPosition pos) {
        this.myCurrentListPosition = pos;
    }

    JGoListPosition getCurrentListPosition() {
        return this.myCurrentListPosition;
    }

    public final ArrayList addCollection(JGoObjectSimpleCollection coll, boolean reparentLinks, JGoLayer linksLayer) {
        ArrayList<JGoObject> collcopy = new ArrayList<JGoObject>();
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            if (obj.getLayer() != null && obj.getLayer() != this.getLayer() || this.isChildOf(obj) || this == obj) continue;
            collcopy.add(obj);
        }
        return this.addCollection(collcopy, reparentLinks, linksLayer);
    }

    public ArrayList addCollection(ArrayList coll, boolean reparentLinks, JGoLayer linksLayer) {
        this.update(1901, 0, coll);
        for (int i = 0; i < coll.size(); ++i) {
            boolean inLayer;
            JGoObject obj = (JGoObject)coll.get(i);
            boolean bl = inLayer = obj.getLayer() != null;
            if (inLayer) {
                JGoArea.setAllNoClear(obj, true);
                obj.getLayer().removeObject(obj);
            }
            this.addObjectAtTail(obj);
            if (!inLayer) continue;
            JGoArea.setAllNoClear(obj, false);
        }
        this.update(1901, 1, coll);
        if (reparentLinks && this.getDocument() != null) {
            JGoSubGraph.reparentAllLinksToSubGraphs(coll, true, linksLayer);
        }
        return coll;
    }

    static void setAllNoClear(JGoObject obj, boolean b) {
        if (obj instanceof JGoPort) {
            JGoPort p = (JGoPort)obj;
            p.setNoClearLinks(b);
        } else if (obj instanceof JGoLink) {
            JGoLink l = (JGoLink)obj;
            l.setNoClearPorts(b);
        } else if (obj instanceof JGoArea) {
            JGoArea g = (JGoArea)obj;
            JGoListPosition pos = g.getFirstObjectPos();
            while (pos != null) {
                JGoObject o = g.getObjectAtPos(pos);
                pos = g.getNextObjectPosAtTop(pos);
                JGoArea.setAllNoClear(o, b);
            }
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 1900: {
                e.setNewValueBoolean(this.isPickableBackground());
                return;
            }
            case 1901: {
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 1900: {
                this.setPickableBackground(e.getValueBoolean(undo));
                return;
            }
            case 1901: {
                ArrayList coll = (ArrayList)e.getOldValue();
                boolean b = undo ? e.getOldValueInt() == 1 : e.getOldValueInt() == 0;
                for (int i = 0; i < coll.size(); ++i) {
                    JGoObject obj = (JGoObject)coll.get(i);
                    JGoArea.setAllNoClear(obj, b);
                }
                return;
            }
        }
        super.changeValue(e, undo);
    }
}

