/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoIconicNode
extends JGoNode {
    private static Dimension DefaultPortSize = new Dimension(7, 7);
    public static final int ChangedLabel = 2201;
    public static final int ChangedIcon = 2202;
    public static final int ChangedPort = 2203;
    public static final int ChangedLabelOffset = 2204;
    public static final int ChangedDraggableLabel = 2205;
    private JGoObject myIcon = null;
    private JGoText myLabel = null;
    private JGoPort myPort = null;
    private Dimension myLabelOffset = new Dimension(-999999, -999999);
    private boolean myDraggableLabel = false;

    public JGoIconicNode() {
        this.initCommon();
    }

    public JGoIconicNode(String s) {
        this.initCommon();
        this.init(s);
    }

    private void initCommon() {
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFFEF | 0x20);
    }

    private void init(String s) {
        this.setInitializing(true);
        this.myIcon = this.createIcon(s);
        this.myLabel = this.createLabel(s);
        this.myPort = this.createPort();
        this.addObjectAtHead(this.myIcon);
        this.addObjectAtTail(this.myLabel);
        this.addObjectAtTail(this.myPort);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    public JGoObject createIcon(String s) {
        JGoImage img = new JGoImage();
        img.setSelectable(false);
        img.setResizable(false);
        img.setSize(32, 32);
        return img;
    }

    public JGoPort createPort() {
        JGoPort p = new JGoPort();
        p.setStyle(0);
        p.setFromSpot(-1);
        p.setToSpot(-1);
        p.setSize(DefaultPortSize);
        p.setPortObject(this.getIcon());
        return p;
    }

    public JGoText createLabel(String s) {
        if (s != null) {
            JGoText t = new JGoText();
            t.setSelectable(false);
            t.setResizable(false);
            t.setDragsNode(true);
            t.setEditable(true);
            t.setEditOnSingleClick(true);
            t.setTransparent(true);
            t.setAlignment(2);
            t.setText(s);
            return t;
        }
        return null;
    }

    protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        JGoIconicNode newobj = (JGoIconicNode)newarea;
        newobj.myDraggableLabel = this.myDraggableLabel;
        newobj.myLabelOffset = new Dimension(this.myLabelOffset);
        super.copyChildren(newarea, env);
        newobj.myIcon = (JGoObject)env.get(this.myIcon);
        newobj.myLabel = (JGoText)env.get(this.myLabel);
        newobj.myPort = (JGoPort)env.get(this.myPort);
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoObject child = super.removeObjectAtPos(pos);
        if (child == this.myIcon) {
            this.myIcon = null;
        } else if (child == this.myLabel) {
            this.myLabel = null;
        } else if (child == this.myPort) {
            this.myPort = null;
        }
        return child;
    }

    public Point getLocation(Point result) {
        if (this.getIcon() != null) {
            return this.getIcon().getSpotLocation(0, result);
        }
        return this.getSpotLocation(0, result);
    }

    public void setLocation(int x, int y) {
        if (this.getIcon() != null) {
            Rectangle r = this.getIcon().getBoundingRect();
            int cx = r.x + r.width / 2;
            int cy = r.y + r.height / 2;
            if (x != cx || y != cy) {
                int nx = this.getLeft();
                int ny = this.getTop();
                this.setTopLeft(x - (cx - nx), y - (cy - ny));
            }
        } else {
            Rectangle r = this.getBoundingRect();
            int cx = r.x + r.width / 2;
            int cy = r.y + r.height / 2;
            if (x != cx || y != cy) {
                this.setTopLeft(x - r.width / 2, y - r.height / 2);
            }
        }
    }

    public void layoutChildren(JGoObject childchanged) {
        if (this.isInitializing()) {
            return;
        }
        JGoObject icon = this.getIcon();
        if (icon == null) {
            return;
        }
        JGoText label = this.getLabel();
        if (label != null) {
            if (this.isDraggableLabel() && childchanged == label) {
                this.myLabelOffset.width = label.getLeft() - icon.getLeft();
                this.myLabelOffset.height = label.getTop() - icon.getTop();
            } else if (this.myLabelOffset.width > -999999) {
                label.setTopLeft(icon.getLeft() + this.myLabelOffset.width, icon.getTop() + this.myLabelOffset.height);
            } else {
                label.setSpotLocation(2, icon, 6);
            }
        }
        if (this.myPort != null) {
            this.myPort.setSpotLocation(0, icon, 0);
        }
    }

    public Dimension getLabelOffset() {
        return this.myLabelOffset;
    }

    public void setLabelOffset(int w, int h) {
        this.internalSetLabelOffset(w, h, false);
    }

    private void internalSetLabelOffset(int w, int h, boolean undoing) {
        Dimension old = this.myLabelOffset;
        if (old.width != w || old.height != h) {
            old = new Dimension(old);
            this.myLabelOffset.width = w;
            this.myLabelOffset.height = h;
            this.update(2204, 0, old);
            if (!undoing) {
                this.layoutChildren(null);
            }
        }
    }

    public void setLabelOffset(Dimension d) {
        this.setLabelOffset(d.width, d.height);
    }

    public boolean isDraggableLabel() {
        return this.myDraggableLabel;
    }

    public void setDraggableLabel(boolean d) {
        this.internalSetDraggableLabel(d, false);
    }

    private void internalSetDraggableLabel(boolean d, boolean undoing) {
        boolean old = this.myDraggableLabel;
        if (old != d) {
            this.myDraggableLabel = d;
            this.update(2205, old ? 1 : 0, null);
            if (!undoing && this.getLabel() != null) {
                this.getLabel().setSelectable(d);
                this.getLabel().setDragsNode(!d);
            }
        }
    }

    public JGoObject getIcon() {
        return this.myIcon;
    }

    public void setIcon(JGoObject icon) {
        JGoObject old = this.myIcon;
        if (old != icon) {
            JGoIconicNode.copyProperties(old, icon);
            if (old != null) {
                this.removeObject(old);
            }
            this.myIcon = icon;
            if (icon != null) {
                if (old == null) {
                    icon.setSelectable(false);
                    icon.setResizable(false);
                }
                this.addObjectAtHead(icon);
            }
            this.update(2202, 0, old);
            if (this.getPort() != null && this.getPort().getPortObject() == old) {
                this.getPort().setPortObject(icon);
            }
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public void setLabel(JGoText lab) {
        JGoText old = this.myLabel;
        if (old != lab) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myLabel = lab;
            if (lab != null) {
                this.addObjectAtTail(lab);
            }
            this.update(2201, 0, old);
        }
    }

    public JGoPort getPort() {
        return this.myPort;
    }

    public void setPort(JGoPort p) {
        JGoPort old = this.myPort;
        if (old != p) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myPort = p;
            if (p != null) {
                this.addObjectAtTail(p);
            }
            this.update(2203, 0, old);
            if (p != null && p.getPortObject() == null) {
                p.setPortObject(this.getIcon());
            }
        }
    }

    public JGoImage getImage() {
        JGoObject icon = this.getIcon();
        if (icon instanceof JGoImage) {
            return (JGoImage)icon;
        }
        return null;
    }

    public String getText() {
        if (this.getLabel() != null) {
            return this.getLabel().getText();
        }
        return "";
    }

    public void setText(String s) {
        if (s == null) {
            return;
        }
        JGoText lab = this.getLabel();
        if (lab == null) {
            this.myLabel = this.createLabel(s);
            this.myLabelOffset.width = 999999;
            this.myLabelOffset.height = -999999;
            this.addObjectAtTail(this.myLabel);
        } else {
            lab.setText(s);
        }
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("icon")) {
            this.myIcon = (JGoObject)referencedObject;
        } else if (attr.equals("label")) {
            this.myLabel = (JGoText)referencedObject;
        } else if (attr.equals("port")) {
            this.myPort = (JGoPort)referencedObject;
        }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jJGoIconicNode = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoIconicNode", jGoElementGroup);
            jJGoIconicNode.setAttribute("draggablelabel", this.myDraggableLabel ? "true" : "false");
            jJGoIconicNode.setAttribute("labeloffsetx", Integer.toString(this.myLabelOffset.width));
            jJGoIconicNode.setAttribute("labeloffsety", Integer.toString(this.myLabelOffset.height));
            if (this.myIcon != null) {
                svgDoc.registerReferencingNode(jJGoIconicNode, "icon", this.myIcon);
            }
            if (this.myLabel != null) {
                svgDoc.registerReferencingNode(jJGoIconicNode, "label", this.myLabel);
            }
            if (this.myPort != null) {
                svgDoc.registerReferencingNode(jJGoIconicNode, "port", this.myPort);
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String offsetheight;
            this.myDraggableLabel = jGoChildElement.getAttribute("draggablelabel").equals("true");
            String offsetwidth = jGoChildElement.getAttribute("labeloffsetx");
            if (offsetwidth.length() > 0) {
                this.myLabelOffset.width = Integer.parseInt(offsetwidth);
            }
            if ((offsetheight = jGoChildElement.getAttribute("labeloffsety")).length() > 0) {
                this.myLabelOffset.height = Integer.parseInt(offsetheight);
            }
            String icon = jGoChildElement.getAttribute("icon");
            svgDoc.registerReferencingObject(this, "icon", icon);
            String label = jGoChildElement.getAttribute("label");
            svgDoc.registerReferencingObject(this, "label", label);
            String port = jGoChildElement.getAttribute("port");
            svgDoc.registerReferencingObject(this, "port", port);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 2202: {
                e.setNewValue(this.getIcon());
                return;
            }
            case 2201: {
                e.setNewValue(this.getLabel());
                return;
            }
            case 2203: {
                e.setNewValue(this.getPort());
                return;
            }
            case 2204: {
                e.setNewValue(new Dimension(this.getLabelOffset()));
                return;
            }
            case 2205: {
                e.setNewValueInt(this.isDraggableLabel() ? 1 : 0);
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 2202: {
                this.setIcon((JGoObject)e.getValue(undo));
                return;
            }
            case 2201: {
                this.setLabel((JGoText)e.getValue(undo));
                return;
            }
            case 2203: {
                this.setPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2204: {
                Dimension d = (Dimension)e.getValue(undo);
                this.internalSetLabelOffset(d.width, d.height, true);
                return;
            }
            case 2205: {
                this.internalSetDraggableLabel(e.getValueInt(undo) == 1, true);
                return;
            }
        }
        super.changeValue(e, undo);
    }
}

