/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoIdentifiablePart;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoPositionArray;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.Arrays;

public class JGoLink
extends JGoStroke
implements JGoIdentifiablePart {
    public static final int AdjustingStyleCalculate = 0;
    public static final int AdjustingStyleScale = 1;
    public static final int AdjustingStyleStretch = 2;
    public static final int AdjustingStyleEnd = 3;
    public static final int RelinkableFromHandle = 91;
    public static final int RelinkableToHandle = 92;
    public static final int ChangedFromPort = 201;
    public static final int ChangedToPort = 202;
    public static final int ChangedOrthogonal = 203;
    public static final int ChangedRelinkable = 204;
    public static final int ChangedJumpsOver = 205;
    public static final int ChangedAvoidsNodes = 206;
    public static final int ChangedCurviness = 207;
    public static final int ChangedAdjustingStyle = 208;
    public static final int ChangedUserObject = 209;
    public static final int ChangedPartID = 210;
    public static final int ChangedRoundedCorners = 211;
    private static final int flagAdjustingStyle = 15;
    private static final int flagLinkOrtho = 8192;
    private static final int flagLinkRelinkable = 65536;
    private static final int flagLinkJumpsOver = 131072;
    private static final int flagLinkAvoidsNodes = 262144;
    private static final int flagNoClearPorts = 524288;
    private static final int flagRoundedCorners = 0x100000;
    private static boolean myResizingModifiesExistingLink = true;
    private int myPartID = -1;
    private Object myUserObject = null;
    private int myLinkFlags = 0;
    private JGoPort myFromPort = null;
    private JGoPort myToPort = null;
    private int myCurviness = 10;

    public JGoLink() {
        this.init();
    }

    public JGoLink(JGoPort from, JGoPort to) {
        this.init();
        this.myFromPort = from;
        this.myToPort = to;
        if (this.myFromPort != null) {
            this.myFromPort.addLink(this);
        }
        if (this.myToPort != null) {
            this.myToPort.addLink(this);
        }
        this.calculateStroke();
    }

    private final void init() {
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFFF7);
        this.myLinkFlags = 65536;
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoLink newobj = (JGoLink)super.copyObject(env);
        if (newobj != null) {
            newobj.myPartID = this.myPartID;
            newobj.myUserObject = this.myUserObject;
            newobj.myLinkFlags = this.myLinkFlags;
            env.delay(this);
            newobj.myFromPort = null;
            newobj.myToPort = null;
        }
        return newobj;
    }

    public void copyObjectDelayed(JGoCopyEnvironment env, JGoObject newobj) {
        if (!(newobj instanceof JGoLink)) {
            return;
        }
        JGoLink oldlink = this;
        JGoLink newlink = (JGoLink)newobj;
        JGoPort oldFromP = oldlink.getFromPort();
        JGoPort oldToP = oldlink.getToPort();
        Object newfp = env.get(oldFromP);
        Object newtp = env.get(oldToP);
        if (newfp instanceof JGoPort && newtp instanceof JGoPort) {
            JGoPort newFromP = (JGoPort)newfp;
            JGoPort newToP = (JGoPort)newtp;
            newlink.myFromPort = newFromP;
            newlink.myToPort = newToP;
            newFromP.addLink(newlink);
            newToP.addLink(newlink);
        } else if (newlink.getLayer() != null) {
            newlink.getLayer().removeObject(newlink);
        }
    }

    public void unlink() {
        JGoLayer layer = this.getLayer();
        if (layer != null) {
            JGoPort port = this.getFromPort();
            if (port != null) {
                port.removeLink(this);
            }
            if ((port = this.getToPort()) != null) {
                port.removeLink(this);
            }
            layer.removeObject(this);
        } else {
            JGoView view = this.getView();
            if (view != null) {
                JGoPort port = this.getFromPort();
                if (port != null) {
                    port.removeLink(this);
                }
                if ((port = this.getToPort()) != null) {
                    port.removeLink(this);
                }
                view.removeObject(this);
            }
        }
    }

    protected void gainedSelection(JGoSelection selection) {
        if (!this.isResizable()) {
            super.gainedSelection(selection);
        } else {
            int nFirstPoint = this.getFirstPickPoint();
            int nLastPoint = this.getLastPickPoint();
            boolean relinkable = this.isRelinkable();
            for (int i = nFirstPoint + 1; i <= nLastPoint - 1; ++i) {
                Point pnt = this.getPoint(i);
                if (pnt == null) continue;
                int hn = 100 + i;
                if (this.isOrthogonal()) {
                    Point p2;
                    Point p0;
                    if (this.getNumPoints() < 6) {
                        hn = -1;
                    } else if (i == nFirstPoint + 1) {
                        p0 = this.getPoint(nFirstPoint);
                        if (p0.y == pnt.y && p0.x != pnt.x) {
                            hn = 8;
                        } else if (p0.x == pnt.x && p0.y != pnt.y) {
                            hn = 2;
                        } else if (p0.x == pnt.x && p0.y == pnt.y && nFirstPoint + 2 <= nLastPoint) {
                            p2 = this.getPoint(nFirstPoint + 2);
                            if (p2.y == pnt.y && p2.x != pnt.x) {
                                hn = 2;
                            } else if (p2.x == pnt.x && p2.y != pnt.y) {
                                hn = 8;
                            }
                        }
                    } else if (i == nLastPoint - 1) {
                        p0 = this.getPoint(nLastPoint);
                        if (pnt.y == p0.y && pnt.x != p0.x) {
                            hn = 4;
                        } else if (pnt.x == p0.x && pnt.y != p0.y) {
                            hn = 6;
                        } else if (p0.x == pnt.x && p0.y == pnt.y && nLastPoint - 2 >= nFirstPoint) {
                            p2 = this.getPoint(nLastPoint - 2);
                            if (p2.y == pnt.y && p2.x != pnt.x) {
                                hn = 6;
                            } else if (p2.x == pnt.x && p2.y != pnt.y) {
                                hn = 4;
                            }
                        }
                    }
                }
                selection.createResizeHandle(this, pnt.x, pnt.y, hn, hn != -1);
            }
            Point p = this.getPoint(nFirstPoint);
            JGoHandle handle = selection.createResizeHandle(this, p.x, p.y, relinkable ? 91 : -1, relinkable);
            p = this.getPoint(nLastPoint);
            handle = selection.createResizeHandle(this, p.x, p.y, relinkable ? 92 : -1, relinkable);
        }
    }

    public Rectangle handleResize(Graphics2D g, JGoView view, Rectangle prevRect, Point newPoint, int whichHandle, int event, int minWidth, int minHeight) {
        JGoPort startport = null;
        JGoPort origendport = null;
        if (whichHandle == 91) {
            startport = this.getToPort();
            origendport = this.getFromPort();
        } else if (whichHandle == 92) {
            startport = this.getFromPort();
            origendport = this.getToPort();
        }
        if (startport != null) {
            if (JGoLink.isDefaultResizingRelinks()) {
                JGoLink reuselink = this;
                if (reuselink.getFromPort() == startport) {
                    reuselink.setToPort(null);
                } else if (reuselink.getToPort() == startport) {
                    reuselink.setFromPort(null);
                }
                view.startReLink(reuselink, origendport, newPoint);
            } else {
                this.unlink();
                view.startNewLink(startport, newPoint);
            }
        } else {
            int midfirst = this.getFirstPickPoint() + 1;
            int midlast = this.getLastPickPoint() - 1;
            switch (whichHandle) {
                case 2: {
                    this.setPoint(midfirst, this.getPoint((int)(midfirst - 1)).x, newPoint.y);
                    this.setPoint(midfirst + 1, this.getPoint((int)(midfirst + 2)).x, newPoint.y);
                    break;
                }
                case 8: {
                    this.setPoint(midfirst, newPoint.x, this.getPoint((int)(midfirst - 1)).y);
                    this.setPoint(midfirst + 1, newPoint.x, this.getPoint((int)(midfirst + 2)).y);
                    break;
                }
                case 6: {
                    this.setPoint(midlast - 1, this.getPoint((int)(midlast - 2)).x, newPoint.y);
                    this.setPoint(midlast, this.getPoint((int)(midlast + 1)).x, newPoint.y);
                    break;
                }
                case 4: {
                    this.setPoint(midlast - 1, newPoint.x, this.getPoint((int)(midlast - 2)).y);
                    this.setPoint(midlast, newPoint.x, this.getPoint((int)(midlast + 1)).y);
                    break;
                }
                default: {
                    Point newend;
                    if (whichHandle < 100) break;
                    int i = whichHandle - 100;
                    Point oldpt = this.getPoint(i);
                    if (this.isOrthogonal()) {
                        Point before = this.getPoint(i - 1);
                        Point after = this.getPoint(i + 1);
                        if (before.x == oldpt.x && oldpt.y == after.y) {
                            this.setPoint(i - 1, newPoint.x, before.y);
                            this.setPoint(i + 1, after.x, newPoint.y);
                        } else if (before.y == oldpt.y && oldpt.x == after.x) {
                            this.setPoint(i - 1, before.x, newPoint.y);
                            this.setPoint(i + 1, newPoint.x, after.y);
                        } else if (before.x == oldpt.x && oldpt.x == after.x) {
                            this.setPoint(i - 1, newPoint.x, before.y);
                            this.setPoint(i + 1, newPoint.x, after.y);
                        } else if (before.y == oldpt.y && oldpt.y == after.y) {
                            this.setPoint(i - 1, before.x, newPoint.y);
                            this.setPoint(i + 1, after.x, newPoint.y);
                        }
                    }
                    this.setPoint(i, newPoint);
                    int numpts = this.getNumPoints();
                    if (numpts < 3) break;
                    if (i == 1 && this.getFromPort() != null) {
                        newend = new Point(0, 0);
                        this.setPoint(0, this.getFromPort().getLinkPointFromPoint(newPoint.x, newPoint.y, newend));
                    }
                    if (i != numpts - 2 || this.getToPort() == null) break;
                    newend = new Point(0, 0);
                    this.setPoint(numpts - 1, this.getToPort().getLinkPointFromPoint(newPoint.x, newPoint.y, newend));
                }
            }
        }
        return null;
    }

    protected void ownerChange(JGoObjectCollection oldOwner, JGoObjectCollection newOwner, JGoObject mainObject) {
        super.ownerChange(oldOwner, newOwner, mainObject);
        if (newOwner == null && !this.isNoClearPorts() && !this.isChildOf(mainObject)) {
            JGoPort port = this.getFromPort();
            if (port != null) {
                port.removeLink(this);
            }
            if ((port = this.getToPort()) != null) {
                port.removeLink(this);
            }
        }
    }

    void setNoClearPorts(boolean bFlag) {
        int f = this.myLinkFlags;
        f = bFlag ? (f |= 0x80000) : (f &= 0xFFF7FFFF);
        this.myLinkFlags = f;
    }

    boolean isNoClearPorts() {
        return (this.myLinkFlags & 0x80000) != 0;
    }

    public void portChange(JGoPort port, int hint, int prevInt, Object prevVal) {
        if (hint != 301 && hint != 302 && hint != 0) {
            if (port != null && port == this.getFromPort() && this.getNumPoints() > 0) {
                Point fromPoint = new Point(0, 0);
                fromPoint = port.getFromLinkPoint(this, fromPoint);
                Point firstPoint = this.getPoint(0);
                if (Math.abs(fromPoint.x - firstPoint.x) > 1 || Math.abs(fromPoint.y - firstPoint.y) > 1) {
                    this.calculateStroke();
                }
            } else if (port != null && port == this.getToPort() && this.getNumPoints() >= 2) {
                Point toPoint = new Point(0, 0);
                toPoint = port.getToLinkPoint(this, toPoint);
                Point lastPoint = this.getPoint(this.getNumPoints() - 1);
                if (Math.abs(toPoint.x - lastPoint.x) > 1 || Math.abs(toPoint.y - lastPoint.y) > 1) {
                    this.calculateStroke();
                }
            } else {
                this.calculateStroke();
            }
        }
    }

    public int getFirstPickPoint() {
        JGoPort p = this.getFromPort();
        if (p == null) {
            return 0;
        }
        int n = this.getNumPoints();
        if (n <= 2) {
            return 0;
        }
        if (p.getFromSpot() != -1 || this.isOrthogonal()) {
            return 1;
        }
        return 0;
    }

    public int getLastPickPoint() {
        int n = this.getNumPoints();
        if (n == 0) {
            return 0;
        }
        JGoPort p = this.getToPort();
        if (p == null) {
            return n - 1;
        }
        if (n <= 2) {
            return n - 1;
        }
        if (p.getToSpot() != -1 || this.isOrthogonal()) {
            return n - 2;
        }
        return n - 1;
    }

    public JGoPort getFromPort() {
        return this.myFromPort;
    }

    public JGoPort getToPort() {
        return this.myToPort;
    }

    public void setFromPort(JGoPort from) {
        JGoPort oldport = this.myFromPort;
        if (oldport != from) {
            if (oldport != null) {
                oldport.removeLink(this);
            }
            this.myFromPort = from;
            if (this.myFromPort != null) {
                this.myFromPort.addLink(this);
            }
            this.removeAllPoints();
            this.calculateStroke();
            this.update(201, 0, oldport);
        }
    }

    private void setFromPortNoCalc(JGoPort from) {
        JGoPort oldport = this.myFromPort;
        if (oldport != from) {
            if (oldport != null) {
                oldport.removeLink(this);
            }
            this.myFromPort = from;
            if (this.myFromPort != null) {
                this.myFromPort.addLink(this);
            }
            this.update(201, 0, oldport);
        }
    }

    public void setToPort(JGoPort to) {
        JGoPort oldport = this.myToPort;
        if (oldport != to) {
            if (oldport != null) {
                oldport.removeLink(this);
            }
            this.myToPort = to;
            if (this.myToPort != null) {
                this.myToPort.addLink(this);
            }
            this.removeAllPoints();
            this.calculateStroke();
            this.update(202, 0, oldport);
        }
    }

    private void setToPortNoCalc(JGoPort to) {
        JGoPort oldport = this.myToPort;
        if (oldport != to) {
            if (oldport != null) {
                oldport.removeLink(this);
            }
            this.myToPort = to;
            if (this.myToPort != null) {
                this.myToPort.addLink(this);
            }
            this.update(202, 0, oldport);
        }
    }

    public JGoPort getOtherPort(JGoPort p) {
        if (this.getFromPort() == p) {
            return this.getToPort();
        }
        if (this.getToPort() == p) {
            return this.getFromPort();
        }
        return null;
    }

    public boolean isCubic() {
        if (this.isSelfLoop() && !this.isOrthogonal()) {
            return true;
        }
        return super.isCubic();
    }

    public boolean isSelfLoop() {
        return this.getFromPort() == this.getToPort() && this.getFromPort() != null;
    }

    public int getCurviness() {
        return this.myCurviness;
    }

    public void setCurviness(int c) {
        int old = this.myCurviness;
        if (old != c) {
            this.myCurviness = c;
            this.update(207, c, null);
        }
    }

    public void calculateStroke() {
        double RIGHT = 0.0;
        double DOWN = 1.5707963267948966;
        double LEFT = Math.PI;
        double UP = 4.71238898038469;
        JGoPort from = this.getFromPort();
        JGoPort to = this.getToPort();
        if (from == null) {
            return;
        }
        if (to == null) {
            return;
        }
        int num = this.getNumPoints();
        int fromspot = from.getFromSpot();
        int tospot = to.getToSpot();
        boolean selfloop = this.isSelfLoop();
        boolean ortho = this.isOrthogonal();
        boolean bezier = this.isCubic();
        boolean calc = this.getAdjustingStyle() == 0;
        int curviness = this.getCurviness();
        boolean oldsuspends = this.isSuspendUpdates();
        if (!oldsuspends) {
            this.foredate(110);
        }
        this.setSuspendUpdates(true);
        if (!ortho && fromspot == -1 && tospot == -1 && !selfloop) {
            boolean adjusted = false;
            if (!calc && num >= 3) {
                Point p = new Point(0, 0);
                Point towards = this.getPoint(1);
                p = from.getLinkPointFromPoint(towards.x, towards.y, p);
                int pAx = p.x;
                int pAy = p.y;
                towards = this.getPoint(num - 2);
                p = to.getLinkPointFromPoint(towards.x, towards.y, p);
                int pBx = p.x;
                int pBy = p.y;
                adjusted = this.adjustPoints(0, pAx, pAy, num - 1, pBx, pBy);
            }
            if (!adjusted) {
                if (bezier) {
                    this.calculateBezierNoSpot(from, to);
                } else {
                    this.calculateLineNoSpot(from, to);
                }
            }
        } else {
            Point fromPoint = new Point(0, 0);
            fromPoint = from.getFromLinkPoint(this, fromPoint);
            int Bx = 0;
            int By = 0;
            double fromDir = 0.0;
            if (ortho || fromspot != -1 || selfloop) {
                int fromSeg = from.getEndSegmentLength();
                fromDir = from.getFromLinkDir(this);
                if (selfloop) {
                    if (ortho) {
                        if (fromDir == 0.0) {
                            fromDir = 4.71238898038469;
                        } else if (fromDir == 1.5707963267948966) {
                            fromDir = 0.0;
                        } else if (fromDir == Math.PI) {
                            fromDir = 1.5707963267948966;
                        } else if (fromDir == 4.71238898038469) {
                            fromDir = Math.PI;
                        }
                    } else {
                        fromDir -= 0.5;
                        if (curviness < 0) {
                            fromDir -= Math.PI;
                        }
                    }
                }
                if (bezier && num >= 4) {
                    fromSeg += 15;
                    if (selfloop) {
                        fromSeg += Math.abs(curviness);
                    }
                }
                if (fromDir == 0.0) {
                    Bx = fromSeg;
                } else if (fromDir == 1.5707963267948966) {
                    By = fromSeg;
                } else if (fromDir == Math.PI) {
                    Bx = -fromSeg;
                } else if (fromDir == 4.71238898038469) {
                    By = -fromSeg;
                } else {
                    Bx = (int)Math.rint((double)fromSeg * Math.cos(fromDir));
                    By = (int)Math.rint((double)fromSeg * Math.sin(fromDir));
                }
                if (fromspot == -1 && selfloop) {
                    fromPoint = from.getLinkPointFromPoint(fromPoint.x + Bx * 1000, fromPoint.y + By * 1000, fromPoint);
                }
            }
            Point toPoint = new Point(0, 0);
            toPoint = to.getToLinkPoint(this, toPoint);
            int Cx = 0;
            int Cy = 0;
            double toDir = -1.0;
            if (ortho || tospot != -1 || selfloop) {
                int toSeg = to.getEndSegmentLength();
                toDir = to.getToLinkDir(this);
                if (selfloop && !ortho) {
                    toDir += 0.5;
                    if (curviness < 0) {
                        toDir += Math.PI;
                    }
                }
                if (bezier && num >= 4) {
                    toSeg += 15;
                    if (selfloop) {
                        toSeg += Math.abs(curviness);
                    }
                }
                if (toDir == 0.0) {
                    Cx = toSeg;
                } else if (toDir == 1.5707963267948966) {
                    Cy = toSeg;
                } else if (toDir == Math.PI) {
                    Cx = -toSeg;
                } else if (toDir == 4.71238898038469) {
                    Cy = -toSeg;
                } else {
                    Cx = (int)Math.rint((double)toSeg * Math.cos(toDir));
                    Cy = (int)Math.rint((double)toSeg * Math.sin(toDir));
                }
                if (tospot == -1 && selfloop) {
                    toPoint = to.getLinkPointFromPoint(toPoint.x + Cx * 1000, toPoint.y + Cy * 1000, toPoint);
                }
            }
            if (ortho || selfloop) {
                fromPoint = from.getLinkPointFromPoint(fromPoint.x + Bx * 1000, fromPoint.y + By * 1000, fromPoint);
            } else if (fromspot == -1) {
                fromPoint = from.getLinkPointFromPoint(toPoint.x + Cx, toPoint.y + Cy, fromPoint);
            }
            if (ortho || selfloop) {
                toPoint = to.getLinkPointFromPoint(toPoint.x + Cx * 1000, toPoint.y + Cy * 1000, toPoint);
            } else if (tospot == -1) {
                toPoint = to.getLinkPointFromPoint(fromPoint.x + Bx, fromPoint.y + By, toPoint);
            }
            int m2x = fromPoint.x;
            int m2y = fromPoint.y;
            if (ortho || fromspot != -1 || selfloop) {
                m2x += Bx;
                m2y += By;
            }
            int m3x = toPoint.x;
            int m3y = toPoint.y;
            if (ortho || tospot != -1 || selfloop) {
                m3x += Cx;
                m3y += Cy;
            }
            if (!calc && !ortho && fromspot == -1 && num > 3 && this.adjustPoints(0, fromPoint.x, fromPoint.y, num - 2, m3x, m3y)) {
                this.setPoint(num - 1, toPoint);
            } else if (!calc && !ortho && tospot == -1 && num > 3 && this.adjustPoints(1, m2x, m2y, num - 1, toPoint.x, toPoint.y)) {
                this.setPoint(0, fromPoint);
            } else if (!calc && !ortho && num > 4 && this.adjustPoints(1, m2x, m2y, num - 2, m3x, m3y)) {
                this.setPoint(0, fromPoint);
                this.setPoint(num - 1, toPoint);
            } else if (!calc && ortho && num >= 6 && !this.isAvoidsNodes() && this.adjustPoints(1, m2x, m2y, num - 2, m3x, m3y)) {
                this.setPoint(0, fromPoint);
                this.setPoint(num - 1, toPoint);
            } else {
                this.removeAllPoints();
                this.addPoint(fromPoint);
                if (ortho || fromspot != -1 || selfloop) {
                    this.addPoint(m2x, m2y);
                }
                if (ortho) {
                    this.addOrthoPoints(m2x, m2y, fromDir, m3x, m3y, toDir);
                }
                if (ortho || tospot != -1 || selfloop) {
                    this.addPoint(m3x, m3y);
                }
                this.addPoint(toPoint);
            }
        }
        this.setBoundingRectInvalid(true);
        this.setSuspendUpdates(oldsuspends);
        if (!oldsuspends) {
            this.update(110, 0, null);
        }
    }

    private void calculateLineNoSpot(JGoPort from, JGoPort to) {
        this.removeAllPoints();
        Point p = new Point(0, 0);
        p = from.getLinkPointFromPoint(to.getLeft() + to.getWidth() / 2, to.getTop() + to.getHeight() / 2, p);
        int pAx = p.x;
        int pAy = p.y;
        p = to.getLinkPointFromPoint(from.getLeft() + from.getWidth() / 2, from.getTop() + from.getHeight() / 2, p);
        int pBx = p.x;
        int pBy = p.y;
        this.addPoint(pAx, pAy);
        this.addPoint(pBx, pBy);
    }

    private void calculateBezierNoSpot(JGoPort from, JGoPort to) {
        this.removeAllPoints();
        Point p = new Point(0, 0);
        p = from.getLinkPointFromPoint(to.getLeft() + to.getWidth() / 2, to.getTop() + to.getHeight() / 2, p);
        int pAx = p.x;
        int pAy = p.y;
        p = to.getLinkPointFromPoint(from.getLeft() + from.getWidth() / 2, from.getTop() + from.getHeight() / 2, p);
        int pBx = p.x;
        int pBy = p.y;
        double Dx = pBx - pAx;
        double Dy = pBy - pAy;
        double len = Math.sqrt(Dx * Dx + Dy * Dy);
        double rad = this.getCurviness();
        double off = Math.abs(rad);
        if (rad < 0.0) {
            off = -off;
        }
        double slope = 0.0;
        double E = 0.0;
        double Mx = (double)pAx + Dx / 3.0;
        double My = (double)pAy + Dy / 3.0;
        double C1x = Mx;
        double C1y = My;
        if (Math.abs(Dy) < 1.0) {
            C1y = Dx > 0.0 ? (C1y -= off) : (C1y += off);
        } else {
            slope = -Dx / Dy;
            E = Math.sqrt(off * off / (slope * slope + 1.0));
            if (rad < 0.0) {
                E = -E;
            }
            C1x = (double)(Dy < 0.0 ? -1 : 1) * E + Mx;
            C1y = slope * (C1x - Mx) + My;
        }
        Mx = (double)pAx + 2.0 * Dx / 3.0;
        My = (double)pAy + 2.0 * Dy / 3.0;
        double C2x = Mx;
        double C2y = My;
        if (Math.abs(Dy) < 1.0) {
            C2y = Dx > 0.0 ? (C2y -= off) : (C2y += off);
        } else {
            C2x = (double)(Dy < 0.0 ? -1 : 1) * E + Mx;
            C2y = slope * (C2x - Mx) + My;
        }
        this.addPoint(pAx, pAy);
        int x1 = (int)Math.rint(C1x);
        int y1 = (int)Math.rint(C1y);
        this.addPoint(x1, y1);
        int x2 = (int)Math.rint(C2x);
        int y2 = (int)Math.rint(C2y);
        this.addPoint(x2, y2);
        this.addPoint(pBx, pBy);
        this.setPoint(0, from.getLinkPointFromPoint(x1, y1, p));
        this.setPoint(3, to.getLinkPointFromPoint(x2, y2, p));
    }

    protected boolean adjustPoints(int startIndex, int nFx, int nFy, int endIndex, int nTx, int nTy) {
        int s = this.getAdjustingStyle();
        if (this.isOrthogonal()) {
            if (s == 1) {
                return false;
            }
            if (s == 2) {
                s = 3;
            }
        }
        switch (s) {
            case 1: {
                return this.rescalePoints(startIndex, nFx, nFy, endIndex, nTx, nTy);
            }
            case 2: {
                return this.stretchPoints(startIndex, nFx, nFy, endIndex, nTx, nTy);
            }
            case 3: {
                return this.modifyEndPoints(startIndex, nFx, nFy, endIndex, nTx, nTy);
            }
        }
        return false;
    }

    protected boolean rescalePoints(int startIndex, int nFx, int nFy, int endIndex, int nTx, int nTy) {
        double newAngle;
        double oldAngle;
        Point oldFromPt = this.getPoint(startIndex);
        Point oldToPt = this.getPoint(endIndex);
        if (oldFromPt.x == nFx && oldFromPt.y == nFy && oldToPt.x == nTx && oldToPt.y == nTy) {
            return true;
        }
        double Bx = oldToPt.x;
        double Ax = oldFromPt.x;
        double Dx = Bx - Ax;
        double By = oldToPt.y;
        double Ay = oldFromPt.y;
        double Dy = By - Ay;
        double oldDist = Math.sqrt(Dx * Dx + Dy * Dy);
        if (oldDist < 1.0) {
            oldDist = 1.0;
        }
        if (Dx == 0.0) {
            oldAngle = Dy < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            oldAngle = Math.atan(Dy / Math.abs(Dx));
            if (Dx < 0.0) {
                oldAngle = Math.PI - oldAngle;
            }
        }
        double A2x = nFx;
        double A2y = nFy;
        double B2x = nTx;
        double B2y = nTy;
        double D2x = B2x - A2x;
        double D2y = B2y - A2y;
        double newDist = Math.sqrt(D2x * D2x + D2y * D2y);
        if (D2x == 0.0) {
            newAngle = D2y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            newAngle = Math.atan(D2y / Math.abs(D2x));
            if (D2x < 0.0) {
                newAngle = Math.PI - newAngle;
            }
        }
        double DistRatio = newDist / oldDist;
        double AngleDiff = newAngle - oldAngle;
        this.setPoint(startIndex, nFx, nFy);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            double pAngle;
            Point p = this.getPoint(i);
            Dx = (double)p.x - Ax;
            Dy = (double)p.y - Ay;
            double pDist = Math.sqrt(Dx * Dx + Dy * Dy);
            if (pDist < 1.0) {
                pDist = 1.0;
            }
            if (Dx == 0.0) {
                pAngle = Dy < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            } else {
                pAngle = Math.atan(Dy / Math.abs(Dx));
                if (Dx < 0.0) {
                    pAngle = Math.PI - pAngle;
                }
            }
            double p2Angle = pAngle + AngleDiff;
            double p2Dist = pDist * DistRatio;
            double P2x = A2x + p2Dist * Math.cos(p2Angle);
            double P2y = A2y + p2Dist * Math.sin(p2Angle);
            this.setPoint(i, (int)Math.rint(P2x), (int)Math.rint(P2y));
        }
        this.setPoint(endIndex, nTx, nTy);
        return true;
    }

    protected boolean stretchPoints(int startIndex, int nFx, int nFy, int endIndex, int nTx, int nTy) {
        Point a = this.getPoint(startIndex);
        Point b = this.getPoint(endIndex);
        if (a.x == nFx && a.y == nFy && b.x == nTx && b.y == nTy) {
            return true;
        }
        double Ax = a.x;
        double Ay = a.y;
        double Bx = b.x;
        double By = b.y;
        double L = (Bx - Ax) * (Bx - Ax) + (By - Ay) * (By - Ay);
        double Cx = nFx;
        double Cy = nFy;
        double Dx = nTx;
        double Dy = nTy;
        double M = 0.0;
        double m2 = 1.0;
        if (Dx - Cx != 0.0) {
            M = (Dy - Cy) / (Dx - Cx);
        }
        if (M != 0.0) {
            m2 = (float)Math.sqrt(1.0 + 1.0 / (M * M));
        }
        this.setPoint(startIndex, nFx, nFy);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            Point p = this.getPoint(i);
            double Px = p.x;
            double Py = p.y;
            double Q = 0.5;
            if (L != 0.0) {
                Q = ((Ax - Px) * (Ax - Bx) + (Ay - Py) * (Ay - By)) / L;
            }
            double Vx = Ax + Q * (Bx - Ax);
            double Vy = Ay + Q * (By - Ay);
            double dV = (float)Math.sqrt((Px - Vx) * (Px - Vx) + (Py - Vy) * (Py - Vy));
            if (Py < M * (Px - Vx) + Vy) {
                dV = -dV;
            }
            if (M > 0.0) {
                dV = -dV;
            }
            double Wx = Cx + Q * (Dx - Cx);
            double Wy = Cy + Q * (Dy - Cy);
            if (M != 0.0) {
                double x = Wx + dV / m2;
                double y = Wy - (x - Wx) / M;
                this.setPoint(i, (int)Math.rint(x), (int)Math.rint(y));
                continue;
            }
            this.setPoint(i, (int)Math.rint(Wx), (int)Math.rint(Wy + dV));
        }
        this.setPoint(endIndex, nTx, nTy);
        return true;
    }

    protected boolean modifyEndPoints(int startIndex, int nFx, int nFy, int endIndex, int nTx, int nTy) {
        if (this.isOrthogonal()) {
            Point b = this.getPoint(startIndex + 1);
            Point c = this.getPoint(startIndex + 2);
            if (b.x == c.x && b.y != c.y) {
                this.setPoint(startIndex + 1, b.x, nFy);
            } else if (b.y == c.y) {
                this.setPoint(startIndex + 1, nFx, b.y);
            }
            b = this.getPoint(endIndex - 1);
            c = this.getPoint(endIndex - 2);
            if (b.x == c.x && b.y != c.y) {
                this.setPoint(endIndex - 1, b.x, nTy);
            } else if (b.y == c.y) {
                this.setPoint(endIndex - 1, nTx, b.y);
            }
        }
        this.setPoint(startIndex, nFx, nFy);
        this.setPoint(endIndex, nTx, nTy);
        return true;
    }

    protected void addOrthoPoints(int endFromX, int endFromY, double fromDir, int endToX, int endToY, double toDir) {
        int m3y;
        int m3x;
        int m2y;
        int m2x;
        double RIGHT = 0.0;
        double DOWN = 1.5707963267948966;
        double LEFT = Math.PI;
        double UP = 4.71238898038469;
        if (fromDir != 0.0 && fromDir != 1.5707963267948966 && fromDir != Math.PI && fromDir != 4.71238898038469) {
            return;
        }
        if (toDir != 0.0 && toDir != 1.5707963267948966 && toDir != Math.PI && toDir != 4.71238898038469) {
            return;
        }
        int sx = endFromX;
        int sy = endFromY;
        int tx = endToX;
        int ty = endToY;
        int penwidth = this.getPen() != null ? this.getPen().getWidth() + 1 : 1;
        JGoObject fromnode = this.getFromPort().getTopLevelObject();
        Rectangle b = fromnode.getBoundingRect();
        Rectangle fromR = new Rectangle(b.x, b.y, b.width, b.height);
        fromR.x -= penwidth;
        fromR.y -= penwidth;
        fromR.width += penwidth * 2;
        fromR.height += penwidth * 2;
        JGoObject tonode = this.getToPort().getTopLevelObject();
        b = tonode.getBoundingRect();
        Rectangle toR = new Rectangle(b.x, b.y, b.width, b.height);
        toR.x -= penwidth;
        toR.y -= penwidth;
        toR.width += penwidth * 2;
        toR.height += penwidth * 2;
        if (this.isAvoidsNodes() && this.getDocument() != null) {
            JGoPositionArray positions = this.getDocument().getPositions();
            int bx1 = Math.min(fromR.x, toR.x);
            int by1 = Math.min(fromR.y, toR.y);
            int bx2 = Math.max(fromR.x + fromR.width, toR.x + toR.width);
            int by2 = Math.max(fromR.y + fromR.height, toR.y + toR.height);
            positions.propagate(endFromX, endFromY, fromDir, endToX, endToY, toDir, bx1 - 20, by1 - 20, bx2 + 20, by2 + 20);
            int endval = positions.getDist(endToX, endToY);
            if (endval >= Integer.MAX_VALUE) {
                positions.setAllUnoccupied(Integer.MAX_VALUE);
                Rectangle whole = positions.getBounds();
                positions.propagate(endFromX, endFromY, fromDir, endToX, endToY, toDir, whole.x, whole.y, whole.x + whole.width, whole.y + whole.height);
                endval = positions.getDist(endToX, endToY);
            }
            if (endval < Integer.MAX_VALUE && !positions.isOccupied(endToX, endToY)) {
                this.traversePositions(positions, endToX, endToY, toDir, true);
                Point two = this.getPoint(2);
                if (this.getNumPoints() < 4) {
                    if (fromDir == 0.0 || fromDir == Math.PI) {
                        two.x = endFromX;
                        two.y = endToY;
                    } else {
                        two.x = endToX;
                        two.y = endFromY;
                    }
                    this.setPoint(2, two);
                    this.insertPoint(3, two);
                } else {
                    Point three = this.getPoint(3);
                    if (fromDir == 0.0 || fromDir == Math.PI) {
                        if (two.x == three.x) {
                            int newx = fromDir == 0.0 ? Math.max(two.x, endFromX) : Math.min(two.x, endFromX);
                            this.setPoint(2, newx, endFromY);
                            this.setPoint(3, newx, three.y);
                        } else if (two.y == three.y) {
                            int newy = endFromY;
                            this.setPoint(2, two.x, newy);
                            this.setPoint(3, three.x, newy);
                        } else {
                            this.setPoint(2, endFromX, two.y);
                        }
                    } else if (fromDir == 1.5707963267948966 || fromDir == 4.71238898038469) {
                        if (two.y == three.y) {
                            int newy = fromDir == 1.5707963267948966 ? Math.max(two.y, endFromY) : Math.min(two.y, endFromY);
                            this.setPoint(2, endFromX, newy);
                            this.setPoint(3, three.x, newy);
                        } else if (two.x == three.x) {
                            int newx = endFromX;
                            this.setPoint(2, newx, two.y);
                            this.setPoint(3, newx, three.y);
                        } else {
                            this.setPoint(2, two.x, endFromY);
                        }
                    }
                }
                return;
            }
        }
        if (fromDir == 0.0) {
            if (tx > sx || toDir == 4.71238898038469 && ty < sy && toR.x + toR.width > sx || toDir == 1.5707963267948966 && ty > sy && toR.x + toR.width > sx) {
                m2x = tx;
                m2y = sy;
                m3x = tx;
                m3y = (sy + ty) / 2;
                if (toDir == Math.PI) {
                    m3x = m2x = this.getMidOrthoPosition(sx, tx, false);
                    m3y = ty;
                } else if (toDir == 4.71238898038469 && ty < sy || toDir == 1.5707963267948966 && ty >= sy) {
                    m2x = sx < toR.x ? this.getMidOrthoPosition(sx, toR.x, false) : (sx < tx && sy < toR.y + toR.height ? this.getMidOrthoPosition(sx, tx, false) : toR.x + toR.width);
                    m3x = m2x;
                    m3y = ty;
                } else if (toDir == 0.0 && m2y > toR.y && m2y < toR.y + toR.height) {
                    m2x = sx;
                    m2y = sy < ty ? Math.min(ty, toR.y) : Math.max(ty, toR.y + toR.height);
                    m3y = m2y;
                }
            } else {
                m2x = sx;
                m2y = ty;
                m3x = (sx + tx) / 2;
                m3y = ty;
                if (toDir == Math.PI || toDir == 1.5707963267948966 && ty < fromR.y || toDir == 4.71238898038469 && ty > fromR.y + fromR.height) {
                    if (ty < sy && (toDir == Math.PI || toDir == 1.5707963267948966)) {
                        m2y = this.getMidOrthoPosition(fromR.y, Math.max(ty, toR.y + toR.height), true);
                    } else if (ty >= sy && (toDir == Math.PI || toDir == 4.71238898038469)) {
                        m2y = this.getMidOrthoPosition(fromR.y + fromR.height, Math.min(ty, toR.y), true);
                    }
                    m3x = tx;
                    m3y = m2y;
                }
                if (m2y > fromR.y && m2y < fromR.y + fromR.height) {
                    if (tx >= fromR.x && tx <= sx || sx <= toR.x + toR.width && sx >= tx) {
                        if (toDir == 0.0 || toDir == Math.PI) {
                            m2x = sx;
                            m2y = (sy + ty) / 2;
                            m3x = tx;
                            m3y = m2y;
                        } else {
                            m2x = Math.max((sx + tx) / 2, sx);
                            m2y = sy;
                            m3x = m2x;
                            m3y = ty;
                        }
                    } else {
                        m3x = tx;
                        m2y = toDir == 4.71238898038469 || (toDir == 0.0 || toDir == Math.PI) && ty < sy ? Math.min(ty, Math.min(fromR.y, toR.y)) : Math.max(ty, Math.max(fromR.y + fromR.height, toR.y + toR.height));
                        m3y = m2y;
                    }
                }
            }
        } else if (fromDir == Math.PI) {
            if (tx <= sx || toDir == 4.71238898038469 && ty < sy && toR.x < sx || toDir == 1.5707963267948966 && ty > sy && toR.x < sx) {
                m2x = tx;
                m2y = sy;
                m3x = tx;
                m3y = (sy + ty) / 2;
                if (toDir == 0.0) {
                    m3x = m2x = this.getMidOrthoPosition(sx, tx, false);
                    m3y = ty;
                } else if (toDir == 4.71238898038469 && ty < sy || toDir == 1.5707963267948966 && ty >= sy) {
                    m2x = sx > toR.x + toR.width ? this.getMidOrthoPosition(sx, toR.x + toR.width, false) : (sx > tx && sy < toR.y + toR.height ? this.getMidOrthoPosition(sx, tx, false) : toR.x);
                    m3x = m2x;
                    m3y = ty;
                }
                if (toDir == Math.PI && m2y > toR.y && m2y < toR.y + toR.height) {
                    m2x = sx;
                    m2y = sy < ty ? Math.min(ty, toR.y) : Math.max(ty, toR.y + toR.height);
                    m3y = m2y;
                }
            } else {
                m2x = sx;
                m2y = ty;
                m3x = (sx + tx) / 2;
                m3y = ty;
                if (toDir == 0.0 || toDir == 1.5707963267948966 && ty < fromR.y || toDir == 4.71238898038469 && ty > fromR.y + fromR.height) {
                    if (ty < sy && (toDir == 0.0 || toDir == 1.5707963267948966)) {
                        m2y = this.getMidOrthoPosition(fromR.y, Math.max(ty, toR.y + toR.height), true);
                    } else if (ty >= sy && (toDir == 0.0 || toDir == 4.71238898038469)) {
                        m2y = this.getMidOrthoPosition(fromR.y + fromR.height, Math.min(ty, toR.y), true);
                    }
                    m3x = tx;
                    m3y = m2y;
                }
                if (m2y > fromR.y && m2y < fromR.y + fromR.height) {
                    if (tx >= fromR.x && tx <= sx || sx <= toR.x + toR.width && sx >= tx) {
                        if (toDir == 0.0 || toDir == Math.PI) {
                            m2x = sx;
                            m2y = (sy + ty) / 2;
                            m3x = tx;
                            m3y = m2y;
                        } else {
                            m2x = Math.min((sx + tx) / 2, sx);
                            m2y = sy;
                            m3x = m2x;
                            m3y = ty;
                        }
                    } else {
                        m3x = tx;
                        m2y = toDir == 4.71238898038469 || (toDir == 0.0 || toDir == Math.PI) && ty < sy ? Math.min(ty, Math.min(fromR.y, toR.y)) : Math.max(ty, Math.max(fromR.y + fromR.height, toR.y + toR.height));
                        m3y = m2y;
                    }
                }
            }
        } else if (fromDir == 1.5707963267948966) {
            if (ty > sy || toDir == Math.PI && tx < sx && toR.y + toR.height > sy || toDir == 0.0 && tx > sx && toR.y + toR.height > sy) {
                m2x = sx;
                m2y = ty;
                m3x = (sx + tx) / 2;
                m3y = ty;
                if (toDir == 4.71238898038469) {
                    m2y = this.getMidOrthoPosition(sy, ty, true);
                    m3x = tx;
                    m3y = m2y;
                } else if (toDir == Math.PI && tx < sx || toDir == 0.0 && tx >= sx) {
                    m2y = sy < toR.y ? this.getMidOrthoPosition(sy, toR.y, true) : (sy < ty && sx < toR.x + toR.width ? this.getMidOrthoPosition(sy, ty, true) : toR.y + toR.height);
                    m3x = tx;
                    m3y = m2y;
                }
                if (toDir == 1.5707963267948966 && m2x > toR.x && m2x < toR.x + toR.width) {
                    m2x = sx < tx ? Math.min(tx, toR.x) : Math.max(tx, toR.x + toR.width);
                    m2y = sy;
                    m3x = m2x;
                }
            } else {
                m2x = tx;
                m2y = sy;
                m3x = tx;
                m3y = (sy + ty) / 2;
                if (toDir == 4.71238898038469 || toDir == 0.0 && tx < fromR.x || toDir == Math.PI && tx > fromR.x + fromR.width) {
                    if (tx < sx && (toDir == 4.71238898038469 || toDir == 0.0)) {
                        m2x = this.getMidOrthoPosition(fromR.x, Math.max(tx, toR.x + toR.width), false);
                    } else if (tx >= sx && (toDir == 4.71238898038469 || toDir == Math.PI)) {
                        m2x = this.getMidOrthoPosition(fromR.x + fromR.width, Math.min(tx, toR.x), false);
                    }
                    m3x = m2x;
                    m3y = ty;
                }
                if (m2x > fromR.x && m2x < fromR.x + fromR.width) {
                    if (ty >= fromR.y && ty <= sy || sy <= toR.y + toR.height && sy >= ty) {
                        if (toDir == 0.0 || toDir == Math.PI) {
                            m2x = sx;
                            m2y = Math.max((sy + ty) / 2, sy);
                            m3x = tx;
                            m3y = m2y;
                        } else {
                            m2x = (sx + tx) / 2;
                            m2y = sy;
                            m3x = m2x;
                            m3y = ty;
                        }
                    } else {
                        m2x = toDir == Math.PI || (toDir == 1.5707963267948966 || toDir == 4.71238898038469) && tx < sx ? Math.min(tx, Math.min(fromR.x, toR.x)) : Math.max(tx, Math.max(fromR.x + fromR.width, toR.x + toR.width));
                        m3x = m2x;
                        m3y = ty;
                    }
                }
            }
        } else if (ty <= sy || toDir == Math.PI && tx < sx && toR.y < sy || toDir == 0.0 && tx > sx && toR.y < sy) {
            m2x = sx;
            m2y = ty;
            m3x = (sx + tx) / 2;
            m3y = ty;
            if (toDir == 1.5707963267948966) {
                m2y = this.getMidOrthoPosition(sy, ty, true);
                m3x = tx;
                m3y = m2y;
            } else if (toDir == Math.PI && tx < sx || toDir == 0.0 && tx >= sx) {
                m2y = sy > toR.y + toR.height ? this.getMidOrthoPosition(sy, toR.y + toR.height, true) : (sy > ty && sx < toR.x + toR.width ? this.getMidOrthoPosition(sy, ty, true) : toR.y);
                m3x = tx;
                m3y = m2y;
            }
            if (toDir == 4.71238898038469 && m2x > toR.x && m2x < toR.x + toR.width) {
                m2x = sx < tx ? Math.min(tx, toR.x) : Math.max(tx, toR.x + toR.width);
                m2y = sy;
                m3x = m2x;
            }
        } else {
            m2x = tx;
            m2y = sy;
            m3x = tx;
            m3y = (sy + ty) / 2;
            if (toDir == 1.5707963267948966 || toDir == 0.0 && tx < fromR.x || toDir == Math.PI && tx > fromR.x + fromR.width) {
                if (tx < sx && (toDir == 1.5707963267948966 || toDir == 0.0)) {
                    m2x = this.getMidOrthoPosition(fromR.x, Math.max(tx, toR.x + toR.width), false);
                } else if (tx >= sx && (toDir == 1.5707963267948966 || toDir == Math.PI)) {
                    m2x = this.getMidOrthoPosition(fromR.x + fromR.width, Math.min(tx, toR.x), false);
                }
                m3x = m2x;
                m3y = ty;
            }
            if (m2x > fromR.x && m2x < fromR.x + fromR.width) {
                if (ty >= fromR.y && ty <= sy || sy <= toR.y + toR.height && sy >= ty) {
                    if (toDir == 0.0 || toDir == Math.PI) {
                        m2x = sx;
                        m2y = Math.min((sy + ty) / 2, sy);
                        m3x = tx;
                        m3y = m2y;
                    } else {
                        m2x = (sx + tx) / 2;
                        m2y = sy;
                        m3x = m2x;
                        m3y = ty;
                    }
                } else {
                    m2x = toDir == Math.PI || (toDir == 1.5707963267948966 || toDir == 4.71238898038469) && tx < sx ? Math.min(tx, Math.min(fromR.x, toR.x)) : Math.max(tx, Math.max(fromR.x + fromR.width, toR.x + toR.width));
                    m3x = m2x;
                    m3y = ty;
                }
            }
        }
        this.addPoint(m2x, m2y);
        this.addPoint(m3x, m3y);
    }

    protected int getMidOrthoPosition(int from, int to, boolean vertical) {
        return (from + to) / 2;
    }

    private void traversePositions(JGoPositionArray positions, int px, int py, double dir, boolean first) {
        double RIGHT = 0.0;
        double DOWN = 1.5707963267948966;
        double LEFT = Math.PI;
        double UP = 4.71238898038469;
        Dimension cell = positions.getCellSize();
        int val = positions.getDist(px, py);
        int qx = px;
        int qy = py;
        int fx = qx;
        int fy = qy;
        if (dir == 0.0) {
            fx += cell.width;
        } else if (dir == 1.5707963267948966) {
            fy += cell.height;
        } else if (dir == Math.PI) {
            fx -= cell.width;
        } else {
            fy -= cell.height;
        }
        while (val > 1 && positions.getDist(fx, fy) == val - 1) {
            qx = fx;
            qy = fy;
            if (dir == 0.0) {
                fx += cell.width;
            } else if (dir == 1.5707963267948966) {
                fy += cell.height;
            } else if (dir == Math.PI) {
                fx -= cell.width;
            } else {
                fy -= cell.height;
            }
            --val;
        }
        if (first) {
            if (val > 1) {
                if (dir == Math.PI || dir == 0.0) {
                    qx = (int)Math.floor((double)qx / (double)cell.width) * cell.width + cell.width / 2;
                } else {
                    qy = (int)Math.floor((double)qy / (double)cell.height) * cell.height + cell.height / 2;
                }
            }
        } else {
            qx = (int)Math.floor((double)qx / (double)cell.width) * cell.width + cell.width / 2;
            qy = (int)Math.floor((double)qy / (double)cell.height) * cell.height + cell.height / 2;
        }
        if (val > 1) {
            double newdir = dir;
            int rx = qx;
            int ry = qy;
            if (dir == 0.0) {
                newdir = 1.5707963267948966;
                ry += cell.height;
            } else if (dir == 1.5707963267948966) {
                newdir = Math.PI;
                rx -= cell.width;
            } else if (dir == Math.PI) {
                newdir = 4.71238898038469;
                ry -= cell.height;
            } else if (dir == 4.71238898038469) {
                newdir = 0.0;
                rx += cell.width;
            }
            if (positions.getDist(rx, ry) == val - 1) {
                this.traversePositions(positions, rx, ry, newdir, false);
            } else {
                int lx = qx;
                int ly = qy;
                if (dir == 0.0) {
                    newdir = 4.71238898038469;
                    ly -= cell.height;
                } else if (dir == 1.5707963267948966) {
                    newdir = 0.0;
                    lx += cell.width;
                } else if (dir == Math.PI) {
                    newdir = 1.5707963267948966;
                    ly += cell.height;
                } else if (dir == 4.71238898038469) {
                    newdir = Math.PI;
                    lx -= cell.width;
                }
                if (positions.getDist(lx, ly) == val - 1) {
                    this.traversePositions(positions, lx, ly, newdir, false);
                }
            }
        }
        this.addPoint(qx, qy);
    }

    public boolean isOrthogonal() {
        return (this.getInternalFlags() & 0x2000) != 0;
    }

    public void setOrthogonal(boolean bOrtho) {
        this.internalSetOrthogonal(bOrtho, false);
    }

    private void internalSetOrthogonal(boolean bOrtho, boolean undoing) {
        boolean oldOrthogonal;
        boolean bl = oldOrthogonal = (this.getInternalFlags() & 0x2000) != 0;
        if (oldOrthogonal != bOrtho) {
            int f = this.getInternalFlags();
            f = bOrtho ? (f |= 0x2000) : (f &= 0xFFFFDFFF);
            this.setInternalFlags(f);
            if (!undoing) {
                this.removeAllPoints();
                this.calculateStroke();
            }
            this.update(203, oldOrthogonal ? 1 : 0, null);
        }
    }

    public void setJumpsOver(boolean bFlag) {
        boolean oldJumpsOver;
        boolean bl = oldJumpsOver = (this.myLinkFlags & 0x20000) != 0;
        if (oldJumpsOver != bFlag) {
            int f = this.myLinkFlags;
            f = bFlag ? (f |= 0x20000) : (f &= 0xFFFDFFFF);
            this.myLinkFlags = f;
            this.resetPath();
            this.update(205, oldJumpsOver ? 1 : 0, null);
        }
    }

    public boolean isJumpsOver() {
        return (this.myLinkFlags & 0x20000) != 0;
    }

    public void setRoundedCorners(boolean bFlag) {
        boolean oldRoundedCorners;
        boolean bl = oldRoundedCorners = (this.myLinkFlags & 0x100000) != 0;
        if (oldRoundedCorners != bFlag) {
            int f = this.myLinkFlags;
            f = bFlag ? (f |= 0x100000) : (f &= 0xFFEFFFFF);
            this.myLinkFlags = f;
            this.resetPath();
            this.update(211, oldRoundedCorners ? 1 : 0, null);
        }
    }

    public boolean isRoundedCorners() {
        return (this.myLinkFlags & 0x100000) != 0;
    }

    public void setAvoidsNodes(boolean bFlag) {
        this.internalSetAvoidsNodes(bFlag, false);
    }

    private void internalSetAvoidsNodes(boolean bFlag, boolean undoing) {
        boolean oldAvoidsNodes;
        boolean bl = oldAvoidsNodes = (this.myLinkFlags & 0x40000) != 0;
        if (oldAvoidsNodes != bFlag) {
            int f = this.myLinkFlags;
            f = bFlag ? (f |= 0x40000) : (f &= 0xFFFBFFFF);
            this.myLinkFlags = f;
            if (!undoing && bFlag) {
                this.removeAllPoints();
                this.calculateStroke();
            }
            this.update(206, oldAvoidsNodes ? 1 : 0, null);
        }
    }

    public boolean isAvoidsNodes() {
        return (this.myLinkFlags & 0x40000) != 0;
    }

    public void setAdjustingStyle(int adj) {
        int old = this.myLinkFlags & 0xF;
        if (old != adj) {
            int f = this.myLinkFlags;
            f &= 0xFFFFFFF0;
            this.myLinkFlags = f |= adj;
            this.update(208, old, null);
        }
    }

    public int getAdjustingStyle() {
        return this.myLinkFlags & 0xF;
    }

    public void setRelinkable(boolean bFlag) {
        boolean oldRelinkable;
        boolean bl = oldRelinkable = (this.myLinkFlags & 0x10000) != 0;
        if (oldRelinkable != bFlag) {
            int f = this.myLinkFlags;
            f = bFlag ? (f |= 0x10000) : (f &= 0xFFFEFFFF);
            this.myLinkFlags = f;
            this.update(204, oldRelinkable ? 1 : 0, null);
        }
    }

    public boolean isRelinkable() {
        return (this.myLinkFlags & 0x10000) != 0;
    }

    public void paint(Graphics2D g, JGoView view) {
        if (view != null && view.getScale() > 0.3 && this.isJumpsOver() && this.isOrthogonal() && !this.isCubic()) {
            this.resetPath();
        }
        super.paint(g, view);
    }

    void makePath(GeneralPath path, JGoView view) {
        int npoints = this.getNumPoints();
        if (npoints >= 2 && view != null && this.isOrthogonal() && !this.isCubic() && (this.isRoundedCorners() || this.isJumpsOver())) {
            Point dummy = new Point(0, 0);
            Point from = this.getPoint(0);
            path.moveTo(from.x, from.y);
            int i = 1;
            while (i < npoints) {
                i = this.furthestPoint(from.x, from.y, i, i > 1);
                Point to = this.getPoint(i);
                if (i >= npoints - 1) {
                    if (from.x != to.x || from.y != to.y) {
                        this.addLine(path, from.x, from.y, to.x, to.y, view);
                    }
                    break;
                }
                int j = this.furthestPoint(to.x, to.y, i + 1, i < npoints - 3);
                Point next = this.getPoint(j);
                this.addLineAndCorner(path, from.x, from.y, to.x, to.y, next.x, next.y, view, dummy);
                from = dummy;
                i = j;
            }
        } else {
            super.makePath(path, view);
        }
    }

    int furthestPoint(int ax, int ay, int i, boolean oneway) {
        int npoints = this.getNumPoints();
        int bx = ax;
        int by = ay;
        while (ax == bx && ay == by) {
            if (i >= npoints) {
                return npoints - 1;
            }
            Point b = this.getPoint(i++);
            bx = b.x;
            by = b.y;
        }
        if (ax != bx && ay != by) {
            return i - 1;
        }
        int cx = bx;
        int cy = by;
        while (true) {
            if (ax != bx || bx != cx || oneway && !(ay < by ? by <= cy : by >= cy)) {
                if (ay != by || by != cy || oneway && !(ax >= bx ? bx >= cx : bx <= cx)) break;
            }
            if (i >= npoints) {
                return npoints - 1;
            }
            Point c = this.getPoint(i++);
            cx = c.x;
            cy = c.y;
        }
        return i - 2;
    }

    private void addLineAndCorner(GeneralPath path, int ax, int ay, int bx, int by, int cx, int cy, JGoView view, Point result) {
        if (ay == by && bx == cx) {
            int corner = this.isRoundedCorners() ? Math.abs(this.getCurviness()) : 0;
            int dx = Math.min(corner, Math.abs(bx - ax) / 2);
            int dy = Math.min(dx, Math.abs(cy - by) / 2);
            if ((dx = dy) < 1 || dy < 1) {
                this.addLine(path, ax, ay, bx, by, view);
                result.x = bx;
                result.y = by;
                return;
            }
            int q1x = bx;
            int q1y = by;
            int q2x = bx;
            int q2y = by;
            if (bx > ax) {
                q1x -= dx;
                q2y = cy > by ? (q2y += dy) : (q2y -= dy);
            } else {
                q1x += dx;
                q2y = cy > by ? (q2y += dy) : (q2y -= dy);
            }
            this.addLine(path, ax, ay, q1x, q1y, view);
            path.quadTo(bx, by, q2x, q2y);
            result.x = q2x;
            result.y = q2y;
        } else if (ax == bx && by == cy) {
            int dx;
            int corner = this.isRoundedCorners() ? Math.abs(this.getCurviness()) : 0;
            int dy = Math.min(corner, Math.abs(by - ay) / 2);
            dy = dx = Math.min(dy, Math.abs(cx - bx) / 2);
            if (dx < 1 || dy < 1) {
                this.addLine(path, ax, ay, bx, by, view);
                result.x = bx;
                result.y = by;
                return;
            }
            int q1x = bx;
            int q1y = by;
            int q2x = bx;
            int q2y = by;
            if (by > ay) {
                q1y -= dy;
                q2x = cx > bx ? (q2x += dx) : (q2x -= dx);
            } else {
                q1y += dy;
                q2x = cx > bx ? (q2x += dx) : (q2x -= dx);
            }
            this.addLine(path, ax, ay, q1x, q1y, view);
            path.quadTo(bx, by, q2x, q2y);
            result.x = q2x;
            result.y = q2y;
        } else {
            this.addLine(path, ax, ay, bx, by, view);
            this.addLine(path, bx, by, cx, cy, view);
            result.x = cx;
            result.y = cy;
        }
    }

    void addLine(GeneralPath path, int ax, int ay, int bx, int by, JGoView view) {
        Point dummy;
        int curve = 10;
        int curve2 = curve / 2;
        int[] vec = view.getTempXs(100);
        int numints = this.getIntersections(ax, ay, bx, by, vec, dummy = view.getTempPoint());
        if (numints > 0) {
            if (ay == by) {
                if (ax < bx) {
                    int j = 0;
                    while (j < numints) {
                        int next;
                        int closer = Math.max(ax, Math.min(vec[j++] - curve2, bx - curve));
                        path.lineTo(closer, by);
                        int farther = Math.min(closer + curve, bx);
                        while (j < numints && (next = vec[j]) < farther + curve) {
                            ++j;
                            farther = Math.min(next + curve2, bx);
                        }
                        path.quadTo((closer + farther) / 2, by - curve, farther, by);
                    }
                } else {
                    int j = numints - 1;
                    while (j >= 0) {
                        int next;
                        int closer = Math.min(ax, Math.max(vec[j--] + curve2, bx + curve));
                        path.lineTo(closer, by);
                        int farther = Math.max(closer - curve, bx);
                        while (j >= 0 && (next = vec[j]) > farther - curve) {
                            --j;
                            farther = Math.max(next - curve2, bx);
                        }
                        path.quadTo((closer + farther) / 2, by - curve, farther, by);
                    }
                }
            } else if (ax == bx) {
                if (ay < by) {
                    int j = 0;
                    while (j < numints) {
                        int next;
                        int closer = Math.max(ay, Math.min(vec[j++] - curve2, by - curve));
                        path.lineTo(bx, closer);
                        int farther = Math.min(closer + curve, by);
                        while (j < numints && (next = vec[j]) < farther + curve) {
                            ++j;
                            farther = Math.min(next + curve2, by);
                        }
                        path.quadTo(bx - curve, (closer + farther) / 2, bx, farther);
                    }
                } else {
                    int j = numints - 1;
                    while (j >= 0) {
                        int next;
                        int closer = Math.min(ay, Math.max(vec[j--] + curve2, by + curve));
                        path.lineTo(bx, closer);
                        int farther = Math.max(closer - curve, by);
                        while (j >= 0 && (next = vec[j]) > farther - curve) {
                            --j;
                            farther = Math.max(next - curve2, by);
                        }
                        path.quadTo(bx - curve, (closer + farther) / 2, bx, farther);
                    }
                }
            }
        }
        path.lineTo(bx, by);
    }

    int getIntersections(int ax, int ay, int bx, int by, int[] v, Point dummy) {
        int numints = 0;
        JGoDocument doc = this.getDocument();
        if (doc == null) {
            return 0;
        }
        JGoLayer layer = doc.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                JGoListPosition pos = layer.getFirstObjectPos();
                while (pos != null) {
                    JGoLink link;
                    JGoObject obj = layer.getObjectAtPos(pos);
                    pos = layer.getNextObjectPos(pos);
                    if (obj == this) {
                        Arrays.sort(v, 0, numints);
                        return numints;
                    }
                    if (!obj.isVisible() || !(obj instanceof JGoLink) || !(link = (JGoLink)obj).isOrthogonal() || !link.isJumpsOver() || link.isCubic()) continue;
                    int npoints = link.getNumPoints();
                    for (int i = 1; i < npoints; ++i) {
                        Point to;
                        Point from = link.getPoint(i - 1);
                        if (!this.getOrthoSegmentIntersection(ax, ay, bx, by, from, to = link.getPoint(i), dummy) || numints >= v.length) continue;
                        v[numints++] = ay == by ? dummy.x : dummy.y;
                    }
                }
            }
            layer = doc.getNextLayer(layer);
        }
        Arrays.sort(v, 0, numints);
        return numints;
    }

    boolean getOrthoSegmentIntersection(int ax, int ay, int bx, int by, Point C, Point D, Point result) {
        if (ax != bx) {
            if (C.x == D.x && Math.min(ax, bx) < C.x && Math.max(ax, bx) > C.x && Math.min(C.y, D.y) < ay && Math.max(C.y, D.y) > ay) {
                result.x = C.x;
                result.y = ay;
                return true;
            }
        } else if (C.y == D.y && Math.min(ay, by) < C.y && Math.max(ay, by) > C.y && Math.min(C.x, D.x) < ax && Math.max(C.x, D.x) > ax) {
            result.x = ax;
            result.y = C.y;
            return true;
        }
        return false;
    }

    public int getPartID() {
        return this.myPartID;
    }

    public void setPartID(int id) {
        int old = this.myPartID;
        if (old != id) {
            this.myPartID = id;
            this.update(210, old, null);
        }
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public void setUserObject(Object obj) {
        Object old = this.myUserObject;
        if (old != obj) {
            this.myUserObject = obj;
            this.update(209, 0, old);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 201: {
                e.setNewValue(this.getFromPort());
                return;
            }
            case 202: {
                e.setNewValue(this.getToPort());
                return;
            }
            case 203: {
                e.setNewValueBoolean(this.isOrthogonal());
                return;
            }
            case 204: {
                e.setNewValueBoolean(this.isRelinkable());
                return;
            }
            case 205: {
                e.setNewValueBoolean(this.isJumpsOver());
                return;
            }
            case 206: {
                e.setNewValueBoolean(this.isAvoidsNodes());
                return;
            }
            case 207: {
                e.setNewValueInt(this.getCurviness());
                return;
            }
            case 208: {
                e.setNewValueInt(this.getAdjustingStyle());
                return;
            }
            case 209: {
                e.setNewValue(this.getUserObject());
                return;
            }
            case 210: {
                e.setNewValueInt(this.getPartID());
                return;
            }
            case 211: {
                e.setNewValueBoolean(this.isRoundedCorners());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 201: {
                this.setFromPortNoCalc((JGoPort)e.getValue(undo));
                return;
            }
            case 202: {
                this.setToPortNoCalc((JGoPort)e.getValue(undo));
                return;
            }
            case 203: {
                this.internalSetOrthogonal(e.getValueBoolean(undo), true);
                return;
            }
            case 204: {
                this.setRelinkable(e.getValueBoolean(undo));
                return;
            }
            case 205: {
                this.setJumpsOver(e.getValueBoolean(undo));
                return;
            }
            case 206: {
                this.internalSetAvoidsNodes(e.getValueBoolean(undo), true);
                return;
            }
            case 207: {
                this.setCurviness(e.getValueInt(undo));
                return;
            }
            case 208: {
                this.setAdjustingStyle(e.getValueInt(undo));
                return;
            }
            case 209: {
                this.setUserObject(e.getValue(undo));
                return;
            }
            case 210: {
                this.setPartID(e.getValueInt(undo));
                return;
            }
            case 211: {
                this.setRoundedCorners(e.getValueBoolean(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoLink = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoLink", jGoElementGroup);
            jGoLink.setAttribute("partid", Integer.toString(this.myPartID));
            svgDoc.registerReferencingNode(jGoLink, "fromport", this.getFromPort());
            svgDoc.registerReferencingNode(jGoLink, "toport", this.getToPort());
            jGoLink.setAttribute("linkflags", Integer.toString(this.myLinkFlags));
            jGoLink.setAttribute("curviness", Integer.toString(this.myCurviness));
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String partid = jGoChildElement.getAttribute("partid");
            if (partid.length() > 0) {
                this.myPartID = Integer.parseInt(partid);
            }
            String fromPortId = jGoChildElement.getAttribute("fromport");
            String toPortId = jGoChildElement.getAttribute("toport");
            svgDoc.registerReferencingObject(this, "fromport", fromPortId);
            svgDoc.registerReferencingObject(this, "toport", toPortId);
            this.myLinkFlags = Integer.parseInt(jGoChildElement.getAttribute("linkflags"));
            String curviness = jGoChildElement.getAttribute("curviness");
            if (curviness.length() > 0) {
                this.setCurviness(Integer.parseInt(curviness));
            }
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            return svgElement.getNextSibling();
        }
        return svgElement.getNextSibling();
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("fromport")) {
            this.setFromPortNoCalc((JGoPort)referencedObject);
            if (this.isSelfLoop()) {
                this.calculateStroke();
            }
        } else if (attr.equals("toport")) {
            this.setToPortNoCalc((JGoPort)referencedObject);
            if (this.isSelfLoop()) {
                this.calculateStroke();
            }
        }
    }

    public static void setDefaultResizingRelinks(boolean reuse) {
        myResizingModifiesExistingLink = reuse;
    }

    public static boolean isDefaultResizingRelinks() {
        return myResizingModifiesExistingLink;
    }
}

