/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;

public class JGoOverview
extends JGoView {
    private JGoView myObserved = null;
    private OverviewRectangle myOverviewRect = null;

    public JGoOverview() {
        this.setHidingDisabledScrollbars(true);
        this.setInternalMouseActions(2);
        this.setScale(0.125);
    }

    public void removeNotify() {
        this.removeListeners();
        this.myObserved = null;
        super.removeNotify();
    }

    private void removeListeners() {
        if (this.myObserved != null && this.myOverviewRect != null) {
            this.myObserved.getDocument().removeDocumentListener(this);
            this.myObserved.removeViewListener(this.myOverviewRect);
            this.myObserved.getCanvas().removeComponentListener(this.myOverviewRect);
        }
    }

    public void setObserved(JGoView observed) {
        if (observed instanceof JGoOverview) {
            return;
        }
        JGoView old = this.myObserved;
        if (old != observed) {
            this.removeListeners();
            this.myObserved = observed;
            if (this.myObserved != null) {
                if (this.myOverviewRect == null) {
                    this.myOverviewRect = new OverviewRectangle(this.myObserved.getViewPosition(), this.myObserved.getExtentSize());
                    this.addObjectAtTail(this.myOverviewRect);
                } else {
                    this.myOverviewRect.setBoundingRect(this.myObserved.getViewRect());
                }
                this.myObserved.getDocument().addDocumentListener(this);
                this.myObserved.addViewListener(this.myOverviewRect);
                this.myObserved.getCanvas().addComponentListener(this.myOverviewRect);
                this.firePropertyChange("observed", old, observed);
                this.updateView();
            }
        }
    }

    public JGoView getObserved() {
        return this.myObserved;
    }

    public boolean isDropFlavorAcceptable(DropTargetDragEvent e) {
        return false;
    }

    public int computeAcceptableDrop(DropTargetDragEvent e) {
        return 0;
    }

    public OverviewRectangle getOverviewRect() {
        return this.myOverviewRect;
    }

    public JGoObject pickDocObject(Point pointToCheck, boolean selectableOnly) {
        if (this.getOverviewRect() != null && this.getOverviewRect().isPointInObj(pointToCheck)) {
            return this.getOverviewRect();
        }
        return null;
    }

    public void selectInBox(Rectangle rect) {
    }

    public void doBackgroundClick(int modifiers, Point dc, Point vc) {
        if (this.getOverviewRect() != null) {
            Rectangle rect = this.getOverviewRect().getBoundingRect();
            this.getOverviewRect().setTopLeft(dc.x - rect.width / 2, dc.y - rect.height / 2);
        }
    }

    public JGoDocument getDocument() {
        if (this.getObserved() != null) {
            return this.getObserved().getDocument();
        }
        return super.getDocument();
    }

    public Dimension getDocumentSize() {
        if (this.getDocument() != null) {
            return this.getDocument().getDocumentSize();
        }
        return new Dimension();
    }

    public boolean isIncludingNegativeCoords() {
        if (this.getObserved() != null) {
            return this.getObserved().isIncludingNegativeCoords();
        }
        return false;
    }

    public String getToolTipText(MouseEvent evt) {
        if (this.getObserved() == null) {
            return null;
        }
        Point p = this.getMouseEventPoint(evt);
        this.convertViewToDoc(p);
        for (JGoObject obj = this.getObserved().pickDocObject(p, false); obj != null; obj = obj.getParent()) {
            String tip = obj.getToolTipText();
            if (tip == null) continue;
            return tip;
        }
        return null;
    }

    public class OverviewRectangle
    extends JGoRectangle
    implements JGoViewListener,
    ComponentListener {
        private boolean myChanging;

        public OverviewRectangle(Point p, Dimension d) {
            super(p, d);
            this.myChanging = false;
            this.setPen(JGoPen.make(65535, 8, new Color(0, 128, 128)));
            this.setResizable(false);
        }

        public void updateRectFromView() {
            if (JGoOverview.this.getObserved() == null) {
                return;
            }
            if (this.myChanging) {
                return;
            }
            this.myChanging = true;
            this.setBoundingRect(JGoOverview.this.getObserved().getViewPosition(), JGoOverview.this.getObserved().getExtentSize());
            JGoOverview.this.scrollRectToVisible(this.getBoundingRect());
            this.myChanging = false;
        }

        public void setBoundingRect(int left, int top, int width, int height) {
            if (JGoOverview.this.getObserved() != null) {
                Point doctopleft = JGoOverview.this.getObserved().getDocumentTopLeft();
                Dimension docsize = JGoOverview.this.getObserved().getDocumentSize();
                if (left + width > doctopleft.x + docsize.width) {
                    left = doctopleft.x + docsize.width - width;
                }
                if (left < doctopleft.x) {
                    left = doctopleft.x;
                }
                if (top + height > doctopleft.y + docsize.height) {
                    top = doctopleft.y + docsize.height - height;
                }
                if (top < doctopleft.y) {
                    top = doctopleft.y;
                }
            }
            if (!JGoOverview.this.isIncludingNegativeCoords()) {
                if (left < 0) {
                    left = 0;
                }
                if (top < 0) {
                    top = 0;
                }
            }
            super.setBoundingRect(left, top, width, height);
        }

        protected void geometryChange(Rectangle prevRect) {
            if (JGoOverview.this.getObserved() == null) {
                return;
            }
            if (this.myChanging) {
                return;
            }
            this.myChanging = true;
            JGoOverview.this.getObserved().setViewPosition(this.getTopLeft());
            this.myChanging = false;
        }

        protected void gainedSelection(JGoSelection selection) {
        }

        protected void lostSelection(JGoSelection selection) {
        }

        public void viewChanged(JGoViewEvent e) {
            switch (e.getHint()) {
                case 1: {
                    if (JGoOverview.this.getObserved() != null && JGoOverview.this.getObserved().getDocument() != e.getObject()) {
                        if (e.getObject() instanceof JGoDocument) {
                            JGoDocument oldDoc = (JGoDocument)e.getObject();
                            oldDoc.removeDocumentListener((JGoView)e.getSource());
                        }
                        JGoOverview.this.getObserved().getDocument().addDocumentListener((JGoView)e.getSource());
                    }
                    this.updateRectFromView();
                    break;
                }
                case 107: 
                case 108: {
                    this.updateRectFromView();
                }
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            this.updateRectFromView();
        }
    }
}

