/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldRefactoringPlugin
extends JavaRefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(EncapsulateFieldRefactoringPlugin.class.getName());
    private ElementHandle<TypeElement> fieldEncloserHandle;
    private Modifier fieldEncloserAccessibility;
    private Set<Modifier> fieldAccessibility;
    private ElementHandle<ExecutableElement> currentGetter;
    private ElementHandle<ExecutableElement> currentSetter;
    private static Set<Modifier> accessModifiers = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private static List<Modifier> MODIFIERS = Arrays.asList(Modifier.PRIVATE, null, Modifier.PROTECTED, Modifier.PUBLIC);
    private final EncapsulateFieldRefactoring refactoring;
    public static final String CLASS_FIELD_PREFIX = "_";
    private TreePathHandle sourceType;

    public EncapsulateFieldRefactoringPlugin(EncapsulateFieldRefactoring encapsulateFieldRefactoring) {
        this.refactoring = encapsulateFieldRefactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        TreePathHandle treePathHandle = this.sourceType != null ? this.sourceType : this.refactoring.getSourceType();
        FileObject fileObject = treePathHandle.getFileObject();
        return JavaSource.forFileObject((FileObject)fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 2);
        try {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            this.sourceType = this.refactoring.getSourceType();
            Problem problem = EncapsulateFieldRefactoringPlugin.isElementAvail(this.sourceType, (CompilationInfo)compilationController);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            Element element = this.sourceType.resolveElement((CompilationInfo)compilationController);
            this.fireProgressListenerStep();
            if (ElementKind.FIELD != element.getKind()) {
                Problem problem3 = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongType"));
                return problem3;
            }
            Object object = compilationController.getTrees().getPath(element);
            this.sourceType = TreePathHandle.create((TreePath)object, (CompilationInfo)compilationController);
            if (!RetoucheUtils.isElementInOpenProject(this.sourceType.getFileObject())) {
                object = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return object;
            }
            object = (TypeElement)element.getEnclosingElement();
            ElementKind elementKind = object.getKind();
            if (elementKind == ElementKind.INTERFACE || elementKind == ElementKind.ANNOTATION_TYPE) {
                Problem problem4 = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateInIntf"));
                return problem4;
            }
            this.fieldEncloserHandle = ElementHandle.create((Element)object);
            this.fieldAccessibility = element.getModifiers();
            this.fieldEncloserAccessibility = this.resolveVisibility((TypeElement)object);
            Problem problem5 = problem;
            return problem5;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        return this.fastCheckParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName(), this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
    }

    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        Problem problem = null;
        Element element = this.sourceType.resolveElement((CompilationInfo)compilationController);
        TypeElement typeElement = (TypeElement)element.getEnclosingElement();
        String string = this.refactoring.getGetterName();
        String string2 = this.refactoring.getSetterName();
        ExecutableElement executableElement = null;
        ExecutableElement executableElement2 = null;
        if (string != null) {
            executableElement = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)compilationController, typeElement, string, Collections.emptyList(), true);
        }
        if (executableElement != null) {
            Types types = compilationController.getTypes();
            if (!types.isSameType(element.asType(), executableElement.getReturnType())) {
                String string3 = new MessageFormat(NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongGetter")).format(new Object[]{((Object)executableElement.getReturnType()).toString()});
                problem = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, string3);
            }
            if (executableElement.getEnclosingElement() != element.getEnclosingElement()) {
                problem = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateGetterExists"));
            } else {
                this.currentGetter = ElementHandle.create((Element)executableElement);
            }
        }
        if (string2 != null) {
            executableElement2 = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)compilationController, typeElement, string2, Collections.singletonList((VariableElement)element), true);
        }
        if (executableElement2 != null) {
            if (TypeKind.VOID != executableElement2.getReturnType().getKind()) {
                problem = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongSetter", null));
            }
            if (executableElement2.getEnclosingElement() != element.getEnclosingElement()) {
                problem = EncapsulateFieldRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"MSG_EncapsulateSetterExists"));
            } else {
                this.currentSetter = ElementHandle.create((Element)executableElement2);
            }
        }
        return problem;
    }

    private Problem fastCheckParameters(String string, String string2, Set<Modifier> set, Set<Modifier> set2, boolean bl) {
        if (string != null && !Utilities.isJavaIdentifier((String)string) || string2 != null && !Utilities.isJavaIdentifier((String)string2) || string == null && string2 == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethods"));
        }
        return null;
    }

    private Modifier resolveVisibility(TypeElement typeElement) {
        NestingKind nestingKind = typeElement.getNestingKind();
        if (nestingKind == NestingKind.ANONYMOUS || nestingKind == NestingKind.LOCAL) {
            return Modifier.PRIVATE;
        }
        Set<Modifier> set = typeElement.getModifiers();
        if (nestingKind == NestingKind.TOP_LEVEL) {
            return set.contains((Object)Modifier.PUBLIC) ? Modifier.PUBLIC : null;
        }
        if (set.contains((Object)Modifier.PRIVATE)) {
            return Modifier.PRIVATE;
        }
        Modifier modifier = this.resolveVisibility((TypeElement)typeElement.getEnclosingElement());
        Modifier modifier2 = null;
        if (set.contains((Object)Modifier.PUBLIC)) {
            modifier2 = Modifier.PUBLIC;
        } else if (set.contains((Object)Modifier.PROTECTED)) {
            modifier2 = Modifier.PROTECTED;
        }
        return this.max(modifier, modifier2);
    }

    private Modifier max(Modifier modifier, Modifier modifier2) {
        int n;
        if (modifier == modifier2) {
            return modifier;
        }
        int n2 = MODIFIERS.indexOf((Object)modifier);
        return n2 > (n = MODIFIERS.indexOf((Object)modifier2)) ? modifier : modifier2;
    }

    private static Modifier getAccessibility(Set<Modifier> set) {
        if (set.isEmpty()) {
            return null;
        }
        HashSet<Modifier> hashSet = new HashSet<Modifier>(set);
        hashSet.retainAll(accessModifiers);
        return hashSet.isEmpty() ? null : (Modifier)((Object)hashSet.iterator().next());
    }

    private static Set<Modifier> replaceAccessibility(Modifier modifier, Modifier modifier2, Element element) {
        HashSet<Modifier> hashSet = new HashSet<Modifier>(element.getModifiers());
        if (modifier != null) {
            hashSet.remove((Object)modifier);
        }
        if (modifier2 != null) {
            hashSet.add(modifier2);
        }
        return hashSet;
    }

    private static ExecutableElement findMethod(CompilationInfo compilationInfo, TypeElement typeElement, String string, List<? extends VariableElement> list, boolean bl) {
        TypeElement typeElement2 = typeElement;
        while (true) {
            for (Element element : typeElement2.getEnclosedElements()) {
                ExecutableElement executableElement;
                if (ElementKind.METHOD != element.getKind() || !string.contentEquals((executableElement = (ExecutableElement)element).getSimpleName()) || !EncapsulateFieldRefactoringPlugin.compareParams(list, executableElement.getParameters()) || !EncapsulateFieldRefactoringPlugin.isAccessible(compilationInfo, typeElement, executableElement)) continue;
                return executableElement;
            }
            TypeMirror typeMirror = typeElement2.getSuperclass();
            if (!bl || typeMirror.getKind() == TypeKind.NONE) {
                return null;
            }
            typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
        }
    }

    private static boolean isAccessible(CompilationInfo compilationInfo, TypeElement typeElement, Element element) {
        if (typeElement == element.getEnclosingElement()) {
            return true;
        }
        Set<Modifier> set = element.getModifiers();
        if (set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED)) {
            return true;
        }
        if (set.contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        Elements elements = compilationInfo.getElements();
        return elements.getPackageOf(element) == elements.getPackageOf(typeElement);
    }

    private static boolean compareParams(List<? extends VariableElement> list, List<? extends VariableElement> list2) {
        if (list.size() == list2.size()) {
            Iterator<? extends VariableElement> iterator = list.iterator();
            for (VariableElement variableElement : list2) {
                if (variableElement.asType() == iterator.next().asType()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String stripPrefix(String string) {
        String string2 = string.startsWith(CLASS_FIELD_PREFIX) ? string.substring(CLASS_FIELD_PREFIX.length()) : string;
        return string2;
    }

    private static StringBuilder getCapitalizedName(VariableElement variableElement) {
        StringBuilder stringBuilder = new StringBuilder(EncapsulateFieldRefactoringPlugin.stripPrefix(variableElement.getSimpleName().toString()));
        stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
        return stringBuilder;
    }

    public static String computeSetterName(VariableElement variableElement) {
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        StringBuilder stringBuilder = EncapsulateFieldRefactoringPlugin.getCapitalizedName(variableElement);
        stringBuilder.insert(0, "set");
        return stringBuilder.toString();
    }

    public static String computeGetterName(VariableElement variableElement) {
        StringBuilder stringBuilder = EncapsulateFieldRefactoringPlugin.getCapitalizedName(variableElement);
        if (TypeKind.BOOLEAN == variableElement.asType().getKind()) {
            stringBuilder.insert(0, "is");
        } else {
            stringBuilder.insert(0, "get");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        this.fireProgressListenerStart(3, 9);
        try {
            this.fireProgressListenerStep();
            EncapsulateDesc encapsulateDesc = this.prepareEncapsulator(null);
            if (encapsulateDesc.p != null && encapsulateDesc.p.isFatal()) {
                Problem problem = encapsulateDesc.p;
                return problem;
            }
            Encapsulator encapsulator = new Encapsulator(Collections.singletonList(encapsulateDesc), encapsulateDesc.p);
            Problem problem = this.createAndAddElements(encapsulateDesc.refs, new JavaRefactoringPlugin.TransformTask(this, encapsulator, encapsulateDesc.fieldHandle), refactoringElementsBag, this.refactoring);
            Problem problem2 = problem != null ? problem : encapsulator.getProblem();
            return problem2;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    EncapsulateDesc prepareEncapsulator(Problem problem) {
        Set<FileObject> set = this.getRelevantFiles();
        EncapsulateDesc encapsulateDesc = new EncapsulateDesc();
        if (this.refactoring.isAlwaysUseAccessors() && this.refactoring.getMethodModifiers().contains((Object)Modifier.PRIVATE) && set.size() > 1) {
            encapsulateDesc.p = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethodsAccess"));
            return encapsulateDesc;
        }
        if (this.refactoring.isAlwaysUseAccessors() && EncapsulateFieldRefactoringPlugin.getAccessibility(this.refactoring.getMethodModifiers()) == null && set.size() > 1) {
            encapsulateDesc.p = EncapsulateFieldRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethodsDefaultAccess"));
        }
        encapsulateDesc.fieldHandle = this.sourceType;
        encapsulateDesc.refs = set;
        encapsulateDesc.currentGetter = this.currentGetter;
        encapsulateDesc.currentSetter = this.currentSetter;
        encapsulateDesc.refactoring = this.refactoring;
        return encapsulateDesc;
    }

    private Set<FileObject> getRelevantFiles() {
        HashSet<FileObject> hashSet;
        FileObject fileObject = this.sourceType.getFileObject();
        if (this.fieldAccessibility.contains((Object)Modifier.PRIVATE) || this.fieldEncloserAccessibility == Modifier.PRIVATE) {
            hashSet = Collections.singleton(fileObject);
        } else {
            ClasspathInfo classpathInfo = this.fieldEncloserAccessibility == Modifier.PUBLIC && (this.fieldAccessibility.contains((Object)Modifier.PUBLIC) || this.fieldAccessibility.contains((Object)Modifier.PROTECTED)) ? RetoucheUtils.getClasspathInfoFor(true, fileObject) : RetoucheUtils.getClasspathInfoFor(false, fileObject);
            ClassIndex classIndex = classpathInfo.getClassIndex();
            hashSet = classIndex.getResources(this.fieldEncloserHandle, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            if (!hashSet.contains(fileObject)) {
                hashSet = new HashSet<FileObject>(hashSet);
                hashSet.add(fileObject);
            }
        }
        return hashSet;
    }

    private static boolean isSubclassOf(TypeElement typeElement, TypeElement typeElement2) {
        TypeMirror typeMirror = typeElement.getSuperclass();
        while (typeMirror.getKind() != TypeKind.NONE) {
            TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement();
            if (typeElement2 == typeElement3) {
                return true;
            }
            typeMirror = typeElement3.getSuperclass();
        }
        return false;
    }

    static final class EncapsulateDesc {
        Problem p;
        Set<FileObject> refs;
        TreePathHandle fieldHandle;
        VariableElement field;
        private ElementHandle<ExecutableElement> currentGetter;
        private ElementHandle<ExecutableElement> currentSetter;
        private EncapsulateFieldRefactoring refactoring;
        private boolean useAccessors;

        EncapsulateDesc() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Encapsulator
    extends RefactoringVisitor {
        private final FileObject sourceFile;
        private Problem problem;
        private List<EncapsulateDesc> descs;
        private Map<VariableElement, EncapsulateDesc> fields;

        public Encapsulator(List<EncapsulateDesc> list, Problem problem) {
            assert (list != null && list.size() > 0);
            this.sourceFile = list.get((int)0).fieldHandle.getFileObject();
            this.descs = list;
            this.problem = problem;
        }

        public Problem getProblem() {
            return this.problem;
        }

        @Override
        public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
            super.setWorkingCopy(workingCopy);
            this.fields = new HashMap<VariableElement, EncapsulateDesc>(this.descs.size());
            for (EncapsulateDesc encapsulateDesc : this.descs) {
                encapsulateDesc.field = (VariableElement)encapsulateDesc.fieldHandle.resolveElement((CompilationInfo)workingCopy);
                this.fields.put(encapsulateDesc.field, encapsulateDesc);
            }
        }

        @Override
        public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
            return (Tree)this.scan(compilationUnitTree.getTypeDecls(), element);
        }

        @Override
        public Tree visitClass(ClassTree classTree, Element element) {
            Object object;
            TypeElement typeElement = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            boolean[] blArray = new boolean[this.descs.size()];
            int n = 0;
            Object object2 = this.descs.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                blArray[n++] = ((EncapsulateDesc)object).useAccessors;
                ((EncapsulateDesc)object).useAccessors = this.resolveUseAccessor(typeElement, (EncapsulateDesc)object);
            }
            if (this.sourceFile == this.workingCopy.getFileObject() && (object2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) == this.descs.get((int)0).field.getEnclosingElement()) {
                object = classTree;
                for (EncapsulateDesc encapsulateDesc : this.descs) {
                    object = this.createGetterAndSetter((ClassTree)object, encapsulateDesc.field, encapsulateDesc.refactoring.getGetterName(), encapsulateDesc.refactoring.getSetterName(), encapsulateDesc.refactoring.getMethodModifiers());
                }
                if (object != null) {
                    this.rewrite(classTree, (Tree)object);
                }
            }
            object2 = (Tree)this.scan(classTree.getMembers(), element);
            n = 0;
            for (EncapsulateDesc encapsulateDesc : this.descs) {
                encapsulateDesc.useAccessors = blArray[n++];
            }
            return object2;
        }

        @Override
        public Tree visitVariable(VariableTree variableTree, Element element) {
            Element element2;
            EncapsulateDesc encapsulateDesc;
            if (this.sourceFile == this.workingCopy.getFileObject() && (encapsulateDesc = this.fields.get(element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath()))) != null) {
                this.resolveFieldDeclaration(variableTree, encapsulateDesc);
                return null;
            }
            return (Tree)this.scan(variableTree.getInitializer(), element);
        }

        @Override
        public Tree visitAssignment(AssignmentTree assignmentTree, Element element) {
            ExpressionTree expressionTree = assignmentTree.getVariable();
            boolean bl = false;
            while (expressionTree.getKind() == Tree.Kind.ARRAY_ACCESS) {
                bl = true;
                expressionTree = ((ArrayAccessTree)expressionTree).getExpression();
            }
            Element element2 = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), expressionTree));
            EncapsulateDesc encapsulateDesc = this.fields.get(element2);
            if (encapsulateDesc != null && encapsulateDesc.useAccessors && encapsulateDesc.refactoring.getSetterName() != null && (bl || this.checkAssignmentInsideExpression()) && !this.isInConstructorOfFieldClass(this.getCurrentPath(), encapsulateDesc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)encapsulateDesc.currentGetter, (ElementHandle<ExecutableElement>)encapsulateDesc.currentSetter)) {
                if (bl) {
                    ExpressionTree expressionTree2 = this.createGetterInvokation(expressionTree, encapsulateDesc.refactoring.getGetterName());
                    this.rewrite(expressionTree, expressionTree2);
                } else {
                    ExpressionTree expressionTree3 = this.createMemberSelection(expressionTree, encapsulateDesc.refactoring.getSetterName());
                    Trees trees = this.workingCopy.getTrees();
                    ExpressionTree expressionTree4 = assignmentTree.getExpression();
                    TreePath treePath = trees.getPath(this.workingCopy.getCompilationUnit(), expressionTree);
                    TreePath treePath2 = trees.getPath(this.workingCopy.getCompilationUnit(), expressionTree4);
                    TypeMirror typeMirror = trees.getTypeMirror(treePath);
                    TypeMirror typeMirror2 = trees.getTypeMirror(treePath2);
                    ExpressionTree expressionTree5 = this.workingCopy.getTypes().isSubtype(typeMirror2, typeMirror) ? expressionTree4 : this.make.TypeCast(this.make.Type(typeMirror), expressionTree4);
                    MethodInvocationTree methodInvocationTree = this.make.MethodInvocation(Collections.emptyList(), expressionTree3, Collections.singletonList(expressionTree5));
                    this.rewrite(assignmentTree, methodInvocationTree);
                }
            }
            return (Tree)this.scan(assignmentTree.getExpression(), element);
        }

        @Override
        public Tree visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Element element) {
            ExpressionTree expressionTree = compoundAssignmentTree.getVariable();
            boolean bl = false;
            while (expressionTree.getKind() == Tree.Kind.ARRAY_ACCESS) {
                bl = true;
                expressionTree = ((ArrayAccessTree)expressionTree).getExpression();
            }
            Element element2 = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), expressionTree));
            EncapsulateDesc encapsulateDesc = this.fields.get(element2);
            if (encapsulateDesc != null && encapsulateDesc.useAccessors && encapsulateDesc.refactoring.getSetterName() != null && (bl || this.checkAssignmentInsideExpression()) && !this.isInConstructorOfFieldClass(this.getCurrentPath(), encapsulateDesc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)encapsulateDesc.currentGetter, (ElementHandle<ExecutableElement>)encapsulateDesc.currentSetter)) {
                if (bl) {
                    ExpressionTree expressionTree2 = this.createGetterInvokation(expressionTree, encapsulateDesc.refactoring.getGetterName());
                    this.rewrite(expressionTree, expressionTree2);
                } else {
                    ExpressionTree expressionTree3 = this.createMemberSelection(expressionTree, encapsulateDesc.refactoring.getSetterName());
                    String string = compoundAssignmentTree.getKind().name();
                    string = string.substring(0, string.length() - "_ASSIGNMENT".length());
                    Tree.Kind kind = Tree.Kind.valueOf(string);
                    ExpressionTree expressionTree4 = this.createGetterInvokation(expressionTree, encapsulateDesc.refactoring.getGetterName());
                    Trees trees = this.workingCopy.getTrees();
                    ExpressionTree expressionTree5 = compoundAssignmentTree.getExpression();
                    TreePath treePath = trees.getPath(this.workingCopy.getCompilationUnit(), expressionTree);
                    TreePath treePath2 = trees.getPath(this.workingCopy.getCompilationUnit(), expressionTree5);
                    TypeMirror typeMirror = trees.getTypeMirror(treePath);
                    BinaryTree binaryTree = this.make.Binary(kind, expressionTree, expressionTree5);
                    TypeMirror typeMirror2 = this.workingCopy.getTreeUtilities().attributeTree((Tree)binaryTree, trees.getScope(treePath2));
                    ExpressionTree expressionTree6 = this.make.Binary(kind, expressionTree4, expressionTree5);
                    if (!this.workingCopy.getTypes().isSubtype(typeMirror2, typeMirror)) {
                        expressionTree6 = this.make.TypeCast(this.make.Type(typeMirror), (ExpressionTree)this.make.Parenthesized(expressionTree6));
                    }
                    MethodInvocationTree methodInvocationTree = this.make.MethodInvocation(Collections.emptyList(), expressionTree3, Collections.singletonList(expressionTree6));
                    this.rewrite(compoundAssignmentTree, methodInvocationTree);
                }
            }
            return (Tree)this.scan(compoundAssignmentTree.getExpression(), element);
        }

        @Override
        public Tree visitUnary(UnaryTree unaryTree, Element element) {
            boolean bl;
            ExpressionTree expressionTree = unaryTree.getExpression();
            Tree.Kind kind = unaryTree.getKind();
            boolean bl2 = bl = kind != Tree.Kind.POSTFIX_DECREMENT && kind != Tree.Kind.POSTFIX_INCREMENT && kind != Tree.Kind.PREFIX_DECREMENT && kind != Tree.Kind.PREFIX_INCREMENT;
            while (expressionTree.getKind() == Tree.Kind.ARRAY_ACCESS) {
                bl = true;
                expressionTree = ((ArrayAccessTree)expressionTree).getExpression();
            }
            Element element2 = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), expressionTree));
            EncapsulateDesc encapsulateDesc = this.fields.get(element2);
            if (encapsulateDesc != null && encapsulateDesc.useAccessors && encapsulateDesc.refactoring.getGetterName() != null && (bl || this.checkAssignmentInsideExpression()) && !this.isInConstructorOfFieldClass(this.getCurrentPath(), encapsulateDesc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)encapsulateDesc.currentGetter, (ElementHandle<ExecutableElement>)encapsulateDesc.currentSetter)) {
                ExpressionTree expressionTree2 = this.createGetterInvokation(expressionTree, encapsulateDesc.refactoring.getGetterName());
                if (bl) {
                    this.rewrite(expressionTree, expressionTree2);
                } else if (encapsulateDesc.refactoring.getSetterName() != null) {
                    ExpressionTree expressionTree3 = this.createMemberSelection(unaryTree.getExpression(), encapsulateDesc.refactoring.getSetterName());
                    Tree.Kind kind2 = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.PREFIX_INCREMENT ? Tree.Kind.PLUS : Tree.Kind.MINUS;
                    Trees trees = this.workingCopy.getTrees();
                    ExpressionTree expressionTree4 = unaryTree.getExpression();
                    TreePath treePath = trees.getPath(this.workingCopy.getCompilationUnit(), expressionTree4);
                    TypeMirror typeMirror = trees.getTypeMirror(treePath);
                    PrimitiveType primitiveType = this.workingCopy.getTypes().getPrimitiveType(TypeKind.INT);
                    ExpressionTree expressionTree5 = this.make.Binary(kind2, expressionTree2, (ExpressionTree)this.make.Literal((Object)1));
                    if (!this.workingCopy.getTypes().isSubtype(primitiveType, typeMirror)) {
                        expressionTree5 = this.make.TypeCast(this.make.Type(typeMirror), (ExpressionTree)this.make.Parenthesized(expressionTree5));
                    }
                    MethodInvocationTree methodInvocationTree = this.make.MethodInvocation(Collections.emptyList(), expressionTree3, Collections.singletonList(expressionTree5));
                    this.rewrite(unaryTree, methodInvocationTree);
                }
            }
            return null;
        }

        @Override
        public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
            Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            EncapsulateDesc encapsulateDesc = this.fields.get(element2);
            if (encapsulateDesc != null && encapsulateDesc.useAccessors && !this.isInConstructorOfFieldClass(this.getCurrentPath(), encapsulateDesc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)encapsulateDesc.currentGetter, (ElementHandle<ExecutableElement>)encapsulateDesc.currentSetter)) {
                ExpressionTree expressionTree = this.createGetterInvokation(memberSelectTree, encapsulateDesc.refactoring.getGetterName());
                this.rewrite(memberSelectTree, expressionTree);
            }
            return (Tree)super.visitMemberSelect(memberSelectTree, element);
        }

        @Override
        public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
            Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            EncapsulateDesc encapsulateDesc = this.fields.get(element2);
            if (encapsulateDesc != null && encapsulateDesc.useAccessors && !this.isInConstructorOfFieldClass(this.getCurrentPath(), encapsulateDesc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)encapsulateDesc.currentGetter, (ElementHandle<ExecutableElement>)encapsulateDesc.currentSetter)) {
                ExpressionTree expressionTree = this.createGetterInvokation(identifierTree, encapsulateDesc.refactoring.getGetterName());
                this.rewrite(identifierTree, expressionTree);
            }
            return null;
        }

        private boolean checkAssignmentInsideExpression() {
            Tree tree = this.getCurrentPath().getLeaf();
            Tree tree2 = this.getCurrentPath().getParentPath().getLeaf();
            if (tree2.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                this.problem = EncapsulateFieldRefactoringPlugin.createProblem(this.problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateInsideAssignment", (Object)tree.toString(), (Object)tree2.toString(), (Object)FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject())));
                return false;
            }
            return true;
        }

        private ExpressionTree createGetterInvokation(ExpressionTree expressionTree, String string) {
            if (string == null) {
                return expressionTree;
            }
            ExpressionTree expressionTree2 = this.createMemberSelection(expressionTree, string);
            MethodInvocationTree methodInvocationTree = this.make.MethodInvocation(Collections.emptyList(), expressionTree2, Collections.emptyList());
            return methodInvocationTree;
        }

        private ExpressionTree createMemberSelection(ExpressionTree expressionTree, String string) {
            ExpressionTree expressionTree2;
            if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
                expressionTree2 = this.make.MemberSelect(memberSelectTree.getExpression(), (CharSequence)string);
            } else {
                expressionTree2 = this.make.Identifier((CharSequence)string);
            }
            return expressionTree2;
        }

        private ClassTree createGetterAndSetter(ClassTree classTree, VariableElement variableElement, String string, String string2, Set<Modifier> set) {
            Object object;
            String string3 = variableElement.getSimpleName().toString();
            boolean bl = variableElement.getModifiers().contains((Object)Modifier.STATIC);
            String string4 = bl ? "a" + EncapsulateFieldRefactoringPlugin.getCapitalizedName(variableElement) : EncapsulateFieldRefactoringPlugin.stripPrefix(string3);
            String string5 = "{return " + string3 + ";}";
            String string6 = (bl ? "{" : "{this.") + string3 + " = " + string4 + ";}";
            HashSet<Modifier> hashSet = new HashSet<Modifier>(set);
            if (bl) {
                hashSet.add(Modifier.STATIC);
            }
            VariableTree variableTree = (VariableTree)this.workingCopy.getTrees().getTree(variableElement);
            ClassTree classTree2 = null;
            ExecutableElement executableElement = null;
            if (string != null) {
                executableElement = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)this.workingCopy, (TypeElement)variableElement.getEnclosingElement(), string, Collections.emptyList(), false);
            }
            if (executableElement == null && string != null) {
                object = this.make.Method(this.make.Modifiers(hashSet), (CharSequence)string, variableTree.getType(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), string5, null);
                classTree2 = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(classTree, (Tree)object);
            }
            object = null;
            if (string2 != null) {
                object = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)this.workingCopy, (TypeElement)variableElement.getEnclosingElement(), string2, Collections.singletonList(variableElement), false);
            }
            if (object == null && string2 != null) {
                VariableTree variableTree2 = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)string4, variableTree.getType(), null);
                MethodTree methodTree = this.make.Method(this.make.Modifiers(hashSet), (CharSequence)string2, (Tree)this.make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(variableTree2), Collections.emptyList(), string6, null);
                classTree2 = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(classTree2 == null ? classTree : classTree2, (Tree)methodTree);
            }
            if (classTree2 == null) {
                classTree = classTree2;
            }
            return classTree2;
        }

        private void resolveFieldDeclaration(VariableTree variableTree, EncapsulateDesc encapsulateDesc) {
            Modifier modifier;
            Modifier modifier2 = EncapsulateFieldRefactoringPlugin.getAccessibility(encapsulateDesc.field.getModifiers());
            if (modifier2 != (modifier = EncapsulateFieldRefactoringPlugin.getAccessibility(encapsulateDesc.refactoring.getFieldModifiers()))) {
                ModifiersTree modifiersTree = this.make.Modifiers(EncapsulateFieldRefactoringPlugin.replaceAccessibility(modifier2, modifier, encapsulateDesc.field), variableTree.getModifiers().getAnnotations());
                VariableTree variableTree2 = this.make.Variable(modifiersTree, (CharSequence)variableTree.getName(), variableTree.getType(), variableTree.getInitializer());
                this.rewrite(variableTree, variableTree2);
            }
        }

        private boolean resolveUseAccessor(TypeElement typeElement, EncapsulateDesc encapsulateDesc) {
            if (encapsulateDesc.refactoring.isAlwaysUseAccessors()) {
                return true;
            }
            Set<Modifier> set = encapsulateDesc.refactoring.getFieldModifiers();
            if (set.contains((Object)Modifier.PRIVATE)) {
                return typeElement != encapsulateDesc.field.getEnclosingElement();
            }
            if (set.contains((Object)Modifier.PROTECTED)) {
                if (EncapsulateFieldRefactoringPlugin.isSubclassOf(typeElement, (TypeElement)encapsulateDesc.field.getEnclosingElement())) {
                    return false;
                }
                return this.workingCopy.getElements().getPackageOf(typeElement) != this.workingCopy.getElements().getPackageOf(encapsulateDesc.field);
            }
            if (set.contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            return this.workingCopy.getElements().getPackageOf(typeElement) != this.workingCopy.getElements().getPackageOf(encapsulateDesc.field);
        }

        private boolean isInConstructorOfFieldClass(TreePath treePath, Element element) {
            Tree tree = treePath.getLeaf();
            Tree.Kind kind = tree.getKind();
            while (true) {
                switch (kind) {
                    case METHOD: {
                        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
                            return false;
                        }
                        Element element2 = this.workingCopy.getTrees().getElement(treePath);
                        return element2.getKind() == ElementKind.CONSTRUCTOR && (element2.getEnclosingElement() == element.getEnclosingElement() || EncapsulateFieldRefactoringPlugin.isSubclassOf((TypeElement)element2.getEnclosingElement(), (TypeElement)element.getEnclosingElement()));
                    }
                    case COMPILATION_UNIT: 
                    case CLASS: 
                    case NEW_CLASS: {
                        return false;
                    }
                }
                treePath = treePath.getParentPath();
                tree = treePath.getLeaf();
                kind = tree.getKind();
            }
        }

        private boolean isInGetterSetter(TreePath treePath, ElementHandle<ExecutableElement> elementHandle, ElementHandle<ExecutableElement> elementHandle2) {
            if (this.sourceFile != this.workingCopy.getFileObject()) {
                return false;
            }
            Tree tree = treePath.getLeaf();
            Tree.Kind kind = tree.getKind();
            while (true) {
                switch (kind) {
                    case METHOD: {
                        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
                            return false;
                        }
                        Element element = this.workingCopy.getTrees().getElement(treePath);
                        return elementHandle != null && element == elementHandle.resolve((CompilationInfo)this.workingCopy) || elementHandle2 != null && element == elementHandle2.resolve((CompilationInfo)this.workingCopy);
                    }
                    case COMPILATION_UNIT: 
                    case CLASS: 
                    case NEW_CLASS: {
                        return false;
                    }
                }
                treePath = treePath.getParentPath();
                tree = treePath.getLeaf();
                kind = tree.getKind();
            }
        }
    }
}

