/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MoveTransformer
extends RefactoringVisitor {
    private FileObject originalFolder;
    private MoveRefactoringPlugin move;
    private Set<Element> elementsToImport = new HashSet<Element>();
    private boolean isThisFileMoving;
    private boolean isThisFileReferencingOldPackage = false;
    private Set<Element> elementsAlreadyImported = new HashSet<Element>();
    private Problem problem;
    private boolean moveToDefaulPackageProblem = false;

    public Problem getProblem() {
        return this.problem;
    }

    public MoveTransformer(MoveRefactoringPlugin moveRefactoringPlugin) {
        this.move = moveRefactoringPlugin;
    }

    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        this.originalFolder = this.workingCopy.getFileObject().getParent();
        this.isThisFileMoving = this.move.filesToMove.contains(this.workingCopy.getFileObject());
        this.elementsToImport = new HashSet<Element>();
        this.isThisFileReferencingOldPackage = false;
        this.elementsAlreadyImported = new HashSet<Element>();
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (element2 != null) {
                FileObject fileObject = SourceUtils.getFile((Element)element2, (ClasspathInfo)this.workingCopy.getClasspathInfo());
                if (this.isElementMoving(element2)) {
                    this.elementsAlreadyImported.add(element2);
                    String string = this.move.getTargetPackageName(SourceUtils.getFile((Element)element2, (ClasspathInfo)this.workingCopy.getClasspathInfo()));
                    if (!"".equals(string)) {
                        MemberSelectTree memberSelectTree2 = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)string), element2);
                        this.rewrite(memberSelectTree, memberSelectTree2);
                    } else if (!this.moveToDefaulPackageProblem) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage"));
                        this.moveToDefaulPackageProblem = true;
                    }
                }
                if (this.isThisFileMoving && !this.isElementMoving(element2) && element2.getKind() != ElementKind.PACKAGE && !this.move.filesToMove.contains(fileObject) && this.getPackageOf(element2).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent())) && !element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED)) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
                if (!this.isThisFileMoving && !this.isElementMoving(element2) && element2.getKind() != ElementKind.PACKAGE && this.move.filesToMove.contains(fileObject) && this.getPackageOf(element2).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent())) && !element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED)) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
            } else if (this.isPackageRename() && "*".equals(memberSelectTree.getIdentifier().toString())) {
                String string;
                ExpressionTree expressionTree = memberSelectTree.getExpression();
                TreePath treePath = this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), expressionTree);
                Element element3 = this.workingCopy.getTrees().getElement(treePath);
                if (element3 != null && element3.getKind() == ElementKind.PACKAGE && (string = RetoucheUtils.getPackageName(this.originalFolder)).equals(element3.toString())) {
                    String string2 = this.move.getTargetPackageName(SourceUtils.getFile((Element)element3, (ClasspathInfo)this.workingCopy.getClasspathInfo()));
                    MemberSelectTree memberSelectTree3 = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)string2), (CharSequence)"*");
                    this.rewrite(memberSelectTree, memberSelectTree3);
                }
            }
        }
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            FileObject fileObject = SourceUtils.getFile((Element)element2, (ClasspathInfo)this.workingCopy.getClasspathInfo());
            if (!this.isThisFileMoving) {
                if (this.isElementMoving(element2)) {
                    if (!this.elementsAlreadyImported.contains(element2) && !RetoucheUtils.getPackageName(this.workingCopy.getCompilationUnit()).equals(this.move.getTargetPackageName(fileObject))) {
                        this.elementsToImport.add(element2);
                    }
                } else if (element2.getKind() != ElementKind.PACKAGE && this.move.filesToMove.contains(fileObject) && this.getPackageOf(element2).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent())) && !element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED)) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
            } else {
                if (!this.isThisFileReferencingOldPackage && !this.isElementMoving(element2) && this.isTopLevelClass(element2) && this.getPackageOf(element2).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent()))) {
                    this.isThisFileReferencingOldPackage = true;
                }
                if (!(element2.getKind() == ElementKind.PACKAGE || this.isElementMoving(element2) || this.move.filesToMove.contains(fileObject) || !this.getPackageOf(element2).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent())) || element2.getModifiers().contains((Object)Modifier.PUBLIC) || element2.getModifiers().contains((Object)Modifier.PROTECTED))) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
            }
        }
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    private TypeElement getTypeElement(Element element) {
        TypeElement typeElement = SourceUtils.getEnclosingTypeElement((Element)element);
        if (typeElement == null && element instanceof TypeElement) {
            return (TypeElement)element;
        }
        return typeElement;
    }

    static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        problem2.setNext(problem);
        return problem2;
    }

    private PackageElement getPackageOf(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    private boolean isPackageRename() {
        return this.move.refactoring instanceof RenameRefactoring;
    }

    private boolean isThisFileReferencedbyOldPackage() {
        HashSet hashSet = new HashSet(this.move.whoReferences.get(this.workingCopy.getFileObject()));
        hashSet.removeAll(this.move.filesToMove);
        for (FileObject fileObject : hashSet) {
            if (!fileObject.getParent().equals(this.originalFolder)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementMoving(Element element) {
        for (ElementHandle elementHandle : this.move.classes.values()) {
            if (!elementHandle.signatureEquals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isTopLevelClass(Element element) {
        return (element.getKind().isClass() || element.getKind().isInterface()) && element.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        Tree tree = (Tree)super.visitCompilationUnit(compilationUnitTree, element);
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return tree;
        }
        CompilationUnitTree compilationUnitTree2 = compilationUnitTree;
        if (this.isThisFileMoving) {
            String string = this.move.getTargetPackageName(this.workingCopy.getFileObject());
            if (compilationUnitTree.getPackageName() != null && !"".equals(string)) {
                this.rewrite(compilationUnitTree.getPackageName(), this.make.Identifier((CharSequence)this.move.getTargetPackageName(this.workingCopy.getFileObject())));
            } else {
                compilationUnitTree2 = this.make.CompilationUnit((ExpressionTree)("".equals(string) ? null : this.make.Identifier((CharSequence)string)), compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
            }
            if (this.isThisFileReferencingOldPackage) {
                ExpressionTree object = compilationUnitTree2.getPackageName();
                if (object != null) {
                    compilationUnitTree2 = this.insertImport(compilationUnitTree2, object.toString() + ".*", null);
                } else if (!this.moveToDefaulPackageProblem) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage"));
                    this.moveToDefaulPackageProblem = true;
                }
            }
        }
        for (Element element2 : this.elementsToImport) {
            FileObject fileObject = SourceUtils.getFile((Element)element2, (ClasspathInfo)this.workingCopy.getClasspathInfo());
            String string = this.move.getTargetPackageName(fileObject);
            if ("".equals(string)) continue;
            compilationUnitTree2 = this.insertImport(compilationUnitTree2, string + "." + element2.getSimpleName(), element2);
        }
        this.rewrite(compilationUnitTree, compilationUnitTree2);
        return tree;
    }

    private CompilationUnitTree insertImport(CompilationUnitTree compilationUnitTree, String string, Element element) {
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            if (importTree.getQualifiedIdentifier().toString().equals(string)) {
                return compilationUnitTree;
            }
            if (element == null || !importTree.getQualifiedIdentifier().toString().equals(this.getPackageOf(element).getQualifiedName() + ".*") || !this.isPackageRename()) continue;
            FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)this.workingCopy.getClasspathInfo());
            this.rewrite(importTree.getQualifiedIdentifier(), this.make.Identifier((CharSequence)(this.move.getTargetPackageName(fileObject) + ".*")));
            return compilationUnitTree;
        }
        CompilationUnitTree compilationUnitTree2 = this.make.insertCompUnitImport(compilationUnitTree, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)string), false));
        return compilationUnitTree2;
    }
}

