/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.DDCommon;
import org.netbeans.modules.j2ee.sun.share.config.StandardDDImpl;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanNode;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class ConfigBeanStorage
implements PropertyChangeListener,
Comparable {
    private ConfigurationStorage storage;
    DConfigBean bean;
    private ConfigBeanStorage parent;
    private ConfigBeanNode node = null;
    private Map childMap = new HashMap();
    private static final String[] ignorableProperties = new String[]{"displayName", "ServletListChanged"};
    public static final String RESOURCE_REF = "resource-ref";
    private List childrenChangeListeners = new Vector();

    public ConfigBeanStorage(DConfigBean dConfigBean, ConfigBeanStorage configBeanStorage, ConfigurationStorage configurationStorage) throws ConfigurationException {
        this.bean = dConfigBean;
        this.parent = configBeanStorage;
        this.storage = configurationStorage;
        this.initChildren();
        StandardDDImpl standardDDImpl = (StandardDDImpl)dConfigBean.getDDBean();
        standardDDImpl.proxy.addConfigBean(this);
        dConfigBean.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Map getChildMap() {
        return this.childMap;
    }

    public ConfigurationStorage getStorage() {
        return this.storage;
    }

    public synchronized Node getNode() {
        this.node = new ConfigBeanNode(this);
        return this.node;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.storage != null && Arrays.binarySearch(ignorableProperties, propertyChangeEvent.getPropertyName()) < 0) {
            System.out.println("PROPERTY CHANGE: " + propertyChangeEvent.getPropertyName());
            if ("contextRoot".equals(propertyChangeEvent.getPropertyName())) {
                System.out.println("  old = '" + propertyChangeEvent.getOldValue() + "', new = '" + propertyChangeEvent.getNewValue() + "'");
            }
            this.storage.setChanged();
        }
        if ("displayName".equalsIgnoreCase(propertyChangeEvent.getPropertyName()) && this.node != null) {
            this.node.setDisplayName((String)propertyChangeEvent.getNewValue());
        }
    }

    public void remove() {
        DDCommon dDCommon = ((StandardDDImpl)this.bean.getDDBean()).proxy;
        dDCommon.removeConfigBean(this);
        if (this.parent != null) {
            try {
                this.parent.bean.removeDConfigBean(this.bean);
                this.storage.setChanged();
            }
            catch (BeanNotFoundException beanNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)beanNotFoundException);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify(16, (Throwable)runtimeException);
            }
        }
    }

    private void initChildren() throws ConfigurationException {
        String[] stringArray = this.bean.getXpaths();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                DDBean[] dDBeanArray = this.bean.getDDBean().getChildBean(stringArray[i]);
                for (int j = 0; j < dDBeanArray.length; ++j) {
                    this.addChild((StandardDDImpl)dDBeanArray[j]);
                }
            }
        }
    }

    void fireEvent(String string, XpathEvent xpathEvent) throws ConfigurationException {
        StandardDDImpl standardDDImpl;
        StandardDDImpl[] standardDDImplArray;
        String[] stringArray = this.bean.getXpaths();
        if (stringArray != null && (standardDDImplArray = this.calculateTargetDDs(standardDDImpl = (StandardDDImpl)xpathEvent.getBean(), string, xpathEvent, stringArray)) != null) {
            for (int i = 0; i < standardDDImplArray.length; ++i) {
                if (xpathEvent.isAddEvent()) {
                    this.addChild(standardDDImplArray[i]);
                    continue;
                }
                this.removeChild(standardDDImplArray[i]);
            }
        }
    }

    private StandardDDImpl[] calculateTargetDDs(StandardDDImpl standardDDImpl, String string, XpathEvent xpathEvent, String[] stringArray) {
        StandardDDImpl[] standardDDImplArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string) && !stringArray[i].equals(xpathEvent.getBean().getXpath())) continue;
            standardDDImplArray = new StandardDDImpl[]{standardDDImpl};
            break;
        }
        HashSet<DDBean> hashSet = new HashSet<DDBean>();
        for (int i = 0; standardDDImplArray == null && i < stringArray.length; ++i) {
            String string2;
            DDBean[] dDBeanArray;
            if (!stringArray[i].startsWith(string) || stringArray[i].length() != string.length() && stringArray[i].charAt(string.length()) != '/' || (dDBeanArray = standardDDImpl.getChildBean(string2 = DDCommon.getRelativePath(stringArray[i], string))) == null) continue;
            for (int j = 0; j < dDBeanArray.length; ++j) {
                if (!(dDBeanArray[j] instanceof StandardDDImpl)) continue;
                hashSet.add(dDBeanArray[j]);
            }
            if (hashSet.size() <= 0) continue;
            standardDDImplArray = hashSet.toArray(new StandardDDImpl[hashSet.size()]);
        }
        return standardDDImplArray;
    }

    private void addChild(StandardDDImpl standardDDImpl) throws ConfigurationException {
        Collection<Object> collection;
        Object object;
        DConfigBean dConfigBean = this.bean.getDConfigBean((DDBean)standardDDImpl);
        if (dConfigBean == null) {
            return;
        }
        if (RESOURCE_REF.equals(standardDDImpl.proxy.dtdname) && (object = this.storage.getDeploymentConfiguration()) instanceof SunONEDeploymentConfiguration) {
            collection = (SunONEDeploymentConfiguration)object;
        }
        object = new ConfigBeanStorage(dConfigBean, this, this.storage);
        collection = (Collection)this.childMap.get(standardDDImpl.getXpath());
        if (collection == null) {
            collection = new TreeSet<DeploymentConfiguration>();
            this.childMap.put(standardDDImpl.getXpath(), collection);
        }
        collection.add(object);
        this.fireChildBeanAddedEvent((ConfigBeanStorage)object);
    }

    private void removeChild(DDBean dDBean) {
        Collection collection = (Collection)this.childMap.get(dDBean.getXpath());
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigBeanStorage configBeanStorage = (ConfigBeanStorage)iterator.next();
            if (!configBeanStorage.bean.getDDBean().equals(dDBean)) continue;
            configBeanStorage.remove();
            iterator.remove();
            this.fireChildBeanRemovedEvent(configBeanStorage);
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException("Null argument passed to ConfigBeanStorage.compareTo()");
        }
        ConfigBeanStorage configBeanStorage = (ConfigBeanStorage)object;
        int n = -1;
        if (this == object) {
            n = 0;
        } else if (this.bean instanceof Base && configBeanStorage.bean instanceof Base) {
            Base base = (Base)this.bean;
            Base base2 = (Base)configBeanStorage.bean;
            n = base.getDisplayName().compareTo(base2.getDisplayName());
            if (n == 0) {
                n = base.getIdentity().compareTo(base2.getIdentity());
            }
        } else {
            throw new IllegalStateException("Source or target bean is null or not derived from Base.");
        }
        return n;
    }

    public DConfigBean getConfigBean() {
        return this.bean;
    }

    public void addChildrenChangeListener(ChildrenChangeListener childrenChangeListener) {
        this.childrenChangeListeners.add(childrenChangeListener);
    }

    public void removeChildrenChangeListener(ChildrenChangeListener childrenChangeListener) {
        this.childrenChangeListeners.remove(childrenChangeListener);
    }

    private void fireChildBeanAddedEvent(ConfigBeanStorage configBeanStorage) {
        for (ChildrenChangeListener childrenChangeListener : this.childrenChangeListeners) {
            childrenChangeListener.childBeanAdded(configBeanStorage);
        }
    }

    private void fireChildBeanRemovedEvent(ConfigBeanStorage configBeanStorage) {
        for (ChildrenChangeListener childrenChangeListener : this.childrenChangeListeners) {
            childrenChangeListener.childBeanRemoved(configBeanStorage);
        }
    }

    static {
        Arrays.sort(ignorableProperties);
    }

    public static interface ChildrenChangeListener {
        public void childBeanAdded(ConfigBeanStorage var1);

        public void childBeanRemoved(ConfigBeanStorage var1);
    }
}

