/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.VersionEditor;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ConfigDataNode
extends DataNode {
    private ConfigDataObject dataObject;

    public ConfigDataNode(ConfigDataObject configDataObject) {
        this(configDataObject, Children.LEAF);
        this.dataObject = configDataObject;
    }

    public ConfigDataNode(ConfigDataObject configDataObject, Children children) {
        super((DataObject)configDataObject, children);
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/sun/share/config/ui/resources/ConfigFile.gif");
    }

    public void destroy() throws IOException {
        this.dataObject = null;
        super.destroy();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("deploymentdescriptor");
        set.setDisplayName(NbBundle.getBundle(ConfigDataNode.class).getString("LBL_ConfigPropertiesName"));
        set.setShortDescription(NbBundle.getBundle(ConfigDataNode.class).getString("LBL_ConfigPropertiesDescription"));
        set.put((Node.Property)new VersionProperty());
        sheet.put(set);
        return sheet;
    }

    private final class VersionProperty
    extends PropertySupport {
        public VersionProperty() {
            super("DDVersion", VersionEditor.class, NbBundle.getBundle(ConfigDataNode.class).getString("LBL_ConfigVersionPropertyName"), NbBundle.getBundle(ConfigDataNode.class).getString("LBL_ConfigVersionPropertyDescription"), true, false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            String string = ASDDVersion.SUN_APPSERVER_8_1.toString();
            try {
                SunONEDeploymentConfiguration sunONEDeploymentConfiguration = ConfigDataNode.this.dataObject.getDeploymentConfiguration();
                string = sunONEDeploymentConfiguration.getAppServerVersion().toString();
            }
            catch (ConfigurationException configurationException) {
                ErrorManager.getDefault().notify(1, (Throwable)configurationException);
            }
            return string;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (object instanceof String) {
                try {
                    ASDDVersion aSDDVersion = ASDDVersion.getASDDVersion((String)((String)object));
                    SunONEDeploymentConfiguration sunONEDeploymentConfiguration = ConfigDataNode.this.dataObject.getDeploymentConfiguration();
                    sunONEDeploymentConfiguration.setAppServerVersion(aSDDVersion);
                }
                catch (ConfigurationException configurationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)configurationException);
                }
            } else {
                throw new IllegalArgumentException("value must be non null and type String");
            }
        }

        public PropertyEditor getPropertyEditor() {
            VersionEditor versionEditor = null;
            try {
                SunONEDeploymentConfiguration sunONEDeploymentConfiguration = ConfigDataNode.this.dataObject.getDeploymentConfiguration();
                int n = VersionEditor.fromASDDVersion(sunONEDeploymentConfiguration.getMinASVersion());
                int n2 = VersionEditor.fromASDDVersion(sunONEDeploymentConfiguration.getMaxASVersion());
                versionEditor = new VersionEditor(n, n2);
            }
            catch (ConfigurationException configurationException) {
                ErrorManager.getDefault().notify(1, (Throwable)configurationException);
            }
            return versionEditor;
        }

        public boolean canWrite() {
            return ConfigDataNode.this.dataObject.getCookie(OpenCookie.class) != null && ConfigDataNode.this.dataObject.getCookie(EditCookie.class) != null;
        }

        public boolean canRead() {
            return true;
        }
    }
}

