/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.DDRoot;
import org.netbeans.modules.j2ee.sun.share.config.ModuleDDSupport;
import org.netbeans.modules.j2ee.sun.share.config.StandardDDImpl;
import org.netbeans.modules.j2ee.sun.share.config.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.xml.sax.SAXException;

public class ConfigurationStorage
implements PropertyChangeListener,
Node.Cookie {
    public static final String ROOT = "/";
    private SunONEDeploymentConfiguration config;
    private ConfigDataObject configDataObject = null;
    private Object dobjMonitor = new Object();
    private PropertyChangeListener weakPropListener = null;
    Map moduleMap = new HashMap();
    final Map versionListeners = new HashMap();
    private boolean needsSave = false;
    final J2eeModuleProvider module;
    boolean loaded = false;
    private RequestProcessor.Task autoSaveTask;
    private int saveInProgress;
    private int cleanInProgress;
    private boolean saveFailedDialogDisplayed;
    private PropertyChangeSupport dobjCookieChangeSupport;

    public ConfigurationStorage(J2eeModuleProvider j2eeModuleProvider, SunONEDeploymentConfiguration sunONEDeploymentConfiguration) throws ConfigurationException, InvalidModuleException, IOException, SAXException {
        this.module = j2eeModuleProvider;
        this.config = sunONEDeploymentConfiguration;
        this.saveInProgress = 0;
        this.cleanInProgress = 0;
        this.dobjCookieChangeSupport = new PropertyChangeSupport(this);
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws ConfigurationException, InvalidModuleException, IOException {
        Object object;
        try {
            ++this.cleanInProgress;
            object = this.moduleMap.values().iterator();
            while (object.hasNext()) {
                ((ModuleDDSupport)object.next()).cleanup();
            }
            this.moduleMap.clear();
        }
        finally {
            --this.cleanInProgress;
        }
        object = new ModuleDDSupport(this.module, (DeploymentConfiguration)this.config);
        this.moduleMap.put(ROOT, object);
    }

    public DDBeanRoot normalizeDDBeanRoot(DDBeanRoot dDBeanRoot) {
        DDRoot dDRoot;
        DDBeanRoot dDBeanRoot2 = dDBeanRoot;
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        if (moduleDDSupport != null && (dDRoot = moduleDDSupport.getDDBeanRoot()) != dDBeanRoot && dDRoot != null) {
            dDBeanRoot2 = dDRoot;
            assert (dDBeanRoot.getXpath().equals(dDBeanRoot2.getXpath())) : "Mismatched xpaths in normalizeDDBeanRoot for " + dDBeanRoot;
        }
        return dDBeanRoot2;
    }

    public RootInterface normalizeDDBeanRoot(RootInterface rootInterface) {
        RootInterface rootInterface2;
        RootInterface rootInterface3 = rootInterface;
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        if (moduleDDSupport != null && (rootInterface2 = moduleDDSupport.getRootInterface()) != rootInterface && rootInterface2 != null) {
            rootInterface3 = rootInterface2;
        }
        return rootInterface3;
    }

    public DDBean normalizeEjbDDBean(DDBean dDBean) {
        StandardDDImpl standardDDImpl = null;
        String string = Utils.getField(dDBean, "ejb-name");
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        DDRoot dDRoot = moduleDDSupport.getDDBeanRoot("META-INF/ejb-jar.xml");
        StandardDDImpl[] standardDDImplArray = (StandardDDImpl[])dDRoot.getChildBean(dDBean.getXpath());
        if (standardDDImplArray != null) {
            String string2;
            int n;
            for (n = 0; n < standardDDImplArray.length; ++n) {
                string2 = null;
                if (!string.equals(string2)) continue;
                standardDDImpl = standardDDImplArray[n];
                break;
            }
            if (standardDDImpl == null) {
                for (n = 0; n < standardDDImplArray.length; ++n) {
                    string2 = "FIXME normalizeEjbDDBean";
                    ErrorManager.getDefault().log(65536, string2);
                }
                Exception exception = new Exception("Failed to lookup: " + string + ", type " + dDBean.getXpath());
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return standardDDImpl;
    }

    private boolean ensureLoaded() {
        if (this.loaded) {
            return true;
        }
        try {
            this.load();
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigDataObject getPrimaryDataObject() {
        ConfigDataObject configDataObject;
        Object object = this.dobjMonitor;
        synchronized (object) {
            FileObject fileObject;
            if (this.configDataObject == null && (fileObject = FileUtil.toFileObject((File)this.config.getConfigFiles()[0])) != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject instanceof ConfigDataObject) {
                        this.configDataObject = (ConfigDataObject)dataObject;
                        this.weakPropListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.configDataObject);
                        this.configDataObject.addPropertyChangeListener(this.weakPropListener);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            configDataObject = this.configDataObject;
        }
        return configDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("valid".equals(propertyChangeEvent.getPropertyName())) {
            if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                Object object = this.dobjMonitor;
                synchronized (object) {
                    this.configDataObject.removePropertyChangeListener(this.weakPropListener);
                    this.configDataObject = null;
                    this.weakPropListener = null;
                }
            }
        } else if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
            this.dobjCookieChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.dobjCookieChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.dobjCookieChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private String filesToString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fileArray.length > 0) {
            stringBuffer.append(fileArray[0].getPath());
        }
        for (int i = 1; i < fileArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(fileArray[i].getPath());
        }
        return stringBuffer.toString();
    }

    public void autoSave() {
        if (this.autoSaveTask == null) {
            this.autoSaveTask = RequestProcessor.getDefault().post(new Runnable(){
                private boolean dialogIsDisplayed;

                public void run() {
                    Mutex.EVENT.readAccess(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (dialogIsDisplayed) {
                                return;
                            }
                            ConfigDataObject configDataObject = ConfigurationStorage.this.getPrimaryDataObject();
                            if (configDataObject == null) {
                                FileObject fileObject = FileUtil.toFileObject((File)ConfigurationStorage.this.config.getConfigFiles()[0]);
                                if (fileObject == null) {
                                    try {
                                        ConfigurationStorage.this.save();
                                    }
                                    catch (Exception exception) {
                                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                                    }
                                }
                                return;
                            }
                            if (!configDataObject.isConfigEditorOpened()) {
                                try {
                                    if (configDataObject.areModified()) {
                                        File[] fileArray = ConfigurationStorage.this.config.getConfigFiles();
                                        String string = ConfigurationStorage.this.config.getAppServerVersion().toString();
                                        String string2 = NbBundle.getMessage(ConfigurationStorage.class, (String)"MSG_SaveGeneratedChanges", (Object)string, (Object)ConfigurationStorage.this.filesToString(fileArray));
                                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0);
                                        dialogIsDisplayed = true;
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                                        if (!NotifyDescriptor.YES_OPTION.equals(confirmation.getValue())) {
                                            return;
                                        }
                                    }
                                    ConfigurationStorage.this.save();
                                }
                                catch (Exception exception) {
                                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                                }
                                finally {
                                    dialogIsDisplayed = false;
                                }
                            } else {
                                configDataObject.setChanged();
                            }
                        }
                    });
                }
            }, 100);
        } else {
            this.autoSaveTask.schedule(100);
        }
    }

    public void setChanged() {
        if (this.cleanInProgress == 0) {
            this.needsSave = true;
            this.autoSave();
        }
    }

    public void updateDDRoot(FileObject fileObject) {
        ModuleDDSupport moduleDDSupport;
        if ("webservices".equals(fileObject.getName()) && (moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT)) != null) {
            moduleDDSupport.getDDBeanRoot(ModuleDDSupport.filenameToPath(fileObject.getNameExt(), moduleDDSupport.getType()));
        }
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.config;
    }

    public static J2eeModuleProvider getChildModuleProvider(J2eeModuleProvider j2eeModuleProvider, String string) {
        J2eeApplicationProvider j2eeApplicationProvider;
        if (string == null) {
            return null;
        }
        J2eeModuleProvider j2eeModuleProvider2 = null;
        if (j2eeModuleProvider instanceof J2eeApplicationProvider && (j2eeModuleProvider2 = (j2eeApplicationProvider = (J2eeApplicationProvider)j2eeModuleProvider).getChildModuleProvider(string)) == null) {
            string = string.startsWith(ROOT) ? string.substring(1) : ROOT + string;
            j2eeModuleProvider2 = j2eeApplicationProvider.getChildModuleProvider(string);
        }
        return j2eeModuleProvider2;
    }

    public Node getMainNode() {
        Node[] nodeArray = this.getMainNodes();
        return nodeArray.length > 0 ? nodeArray[0] : null;
    }

    public Node[] getMainNodes() {
        if (!this.ensureLoaded()) {
            return new Node[0];
        }
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        return moduleDDSupport == null ? new Node[]{} : moduleDDSupport.getNodes();
    }

    public Node[] getNodes(J2eeModule j2eeModule) {
        if (!this.ensureLoaded()) {
            return new Node[0];
        }
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(j2eeModule.getUrl());
        if (moduleDDSupport == null) {
            return new Node[0];
        }
        return moduleDDSupport.getNodes();
    }

    private void createDConfigBean(ModuleDDSupport moduleDDSupport) throws ConfigurationException {
        moduleDDSupport.createConfigs(this);
    }

    public void saveOnDemand() throws IOException {
        if (this.needsSave) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        block5: {
            try {
                ++this.saveInProgress;
                if (this.config != null) {
                    this.needsSave = false;
                    ConfigDataObject configDataObject = this.getPrimaryDataObject();
                    if (configDataObject != null) {
                        configDataObject.resetChanged();
                    }
                    break block5;
                }
                throw new IllegalStateException("Attempted to save configuration when DeploymentConfiguration is null.");
            }
            finally {
                --this.saveInProgress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportExceptionDuringSave(Exception exception) {
        if (!this.saveFailedDialogDisplayed) {
            try {
                this.saveFailedDialogDisplayed = true;
                String string = exception.getLocalizedMessage();
                String string2 = this.config.getAppServerVersion().toString();
                String string3 = this.filesToString(this.config.getConfigFiles());
                String string4 = string != null && string.length() > 0 ? (exception instanceof IOException ? string : NbBundle.getMessage(ConfigurationStorage.class, (String)"MSG_ConfigurationSaveFailedHasMessage", (Object)string2, (Object)string3, (Object)string)) : NbBundle.getMessage(ConfigurationStorage.class, (String)"MSG_ConfigurationSaveFailed", (Object)string2, (Object)string3);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string4));
            }
            finally {
                this.saveFailedDialogDisplayed = false;
            }
        }
    }

    public void load() throws IOException, InvalidModuleException, ConfigurationException {
        if (this.saveInProgress > 0) {
            return;
        }
        this.init();
        if (!(this.config instanceof SunONEDeploymentConfiguration)) {
            throw new IllegalArgumentException("Invalid DeploymentConfiguration: " + this.config);
        }
        SunONEDeploymentConfiguration sunONEDeploymentConfiguration = this.config;
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        this.createDConfigBean(moduleDDSupport);
        this.loaded = true;
    }

    public void cleanup() {
        for (ModuleDDSupport moduleDDSupport : this.moduleMap.values()) {
            moduleDDSupport.cleanup();
        }
        this.moduleMap = new HashMap();
    }

    private String getKey(J2eeModule j2eeModule) {
        String string = j2eeModule.getUrl();
        if (string == null || string.trim().equals("")) {
            string = ROOT;
        }
        return string;
    }

    boolean saveInProgress() {
        return this.saveInProgress > 0;
    }

    public DDBeanRoot getDDBeanRoot(J2eeModule j2eeModule) {
        DDRoot dDRoot;
        DDRoot dDRoot2 = null;
        ModuleDDSupport moduleDDSupport = (ModuleDDSupport)this.moduleMap.get(ROOT);
        if (moduleDDSupport != null && (dDRoot = moduleDDSupport.getDDBeanRoot()) != null) {
            dDRoot2 = dDRoot;
        }
        return dDRoot2;
    }
}

