/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.io.File;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.AbstractFilesListener;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ModuleDDSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DDFilesListener
extends AbstractFilesListener {
    private SunONEDeploymentConfiguration config;
    private File[] ddFiles = null;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public DDFilesListener(SunONEDeploymentConfiguration sunONEDeploymentConfiguration, J2eeModuleProvider j2eeModuleProvider) {
        super(j2eeModuleProvider);
        this.config = sunONEDeploymentConfiguration;
    }

    protected File[] getTargetFiles() {
        if (this.ddFiles != null) {
            return this.ddFiles;
        }
        SourceFileMap sourceFileMap = this.provider.getSourceFileMap();
        FileObject[] fileObjectArray = sourceFileMap.getSourceRoots();
        if (fileObjectArray == null || fileObjectArray.length < 1) {
            this.ddFiles = EMPTY_FILE_ARRAY;
            return this.ddFiles;
        }
        if (fileObjectArray[0] == null) {
            this.ddFiles = EMPTY_FILE_ARRAY;
            return this.ddFiles;
        }
        File file = FileUtil.toFile((FileObject)fileObjectArray[0]);
        String[] stringArray = ModuleDDSupport.getDDPaths(this.provider.getJ2eeModule().getModuleType());
        this.ddFiles = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (J2eeModule.WAR != this.provider.getJ2eeModule().getModuleType()) {
                string = string.substring(stringArray[i].lastIndexOf(47) + 1);
            }
            this.ddFiles[i] = new File(file, string);
        }
        return this.ddFiles;
    }

    protected boolean isTarget(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        this.getTargetFiles();
        for (int i = 0; i < this.ddFiles.length; ++i) {
            if (!fileObject.getNameExt().equalsIgnoreCase(this.ddFiles[i].getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isTarget(String string) {
        if (string == null) {
            return false;
        }
        this.getTargetFiles();
        for (int i = 0; i < this.ddFiles.length; ++i) {
            if (!string.equalsIgnoreCase(this.ddFiles[i].getName())) continue;
            return true;
        }
        return true;
    }

    protected void targetCreated(FileObject fileObject) {
        ConfigurationStorage configurationStorage = this.config.getStorage();
        if (configurationStorage != null) {
            configurationStorage.updateDDRoot(fileObject);
        }
    }

    protected void targetDeleted(FileObject fileObject) {
    }

    protected void targetChanged(FileObject fileObject) {
    }
}

