/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.netbeans.modules.j2ee.sun.share.config.ui.PanelFocusCookie;
import org.netbeans.modules.j2ee.sun.share.config.ui.PanelView;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractDesignEditor
extends TopComponent
implements PanelFocusCookie,
ExplorerManager.Provider {
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 400;
    protected static EmptyInspectorNode emptyInspectorNode;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "/org/netbeans/modules/form/resources/emptyInspector";
    private ExplorerManager manager = null;
    protected JComponent structureView;
    protected JComponent propertiesView;
    protected JComponent contentView;
    protected static final String iconURL = "/org/netbeans/modules/form/resources/inspector.gif";
    protected static final long serialVersionUID = 1L;

    protected AbstractDesignEditor() {
    }

    public AbstractDesignEditor(PanelView panelView) {
        this.contentView = panelView;
        this.contentView.setPreferredSize(new Dimension(400, 400));
        this.initComponents();
        this.setRootContext(panelView.getRoot());
    }

    public AbstractDesignEditor(PanelView panelView, JComponent jComponent) {
        this.contentView = panelView;
        this.contentView.setPreferredSize(new Dimension(400, 400));
        this.structureView = jComponent;
        this.initComponents();
        this.setRootContext(panelView.getRoot());
    }

    public void setRootContext(Node node) {
        this.getExplorerManager().setRootContext(node);
    }

    protected void initComponents() {
        ExplorerManager explorerManager = this.getExplorerManager();
        emptyInspectorNode = new EmptyInspectorNode();
        explorerManager.setRootContext((Node)emptyInspectorNode);
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.setName("CTL_ComponentPanelTitle");
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.setToolTipText("HINT_ComponentPanel");
        explorerManager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectedListener());
        this.setLayout(new BorderLayout());
    }

    public JComponent getContentView() {
        return this.contentView;
    }

    public JComponent getStructureView() {
        if (this.structureView == null) {
            this.structureView = this.createStructureComponent();
        }
        return this.structureView;
    }

    public abstract JComponent createStructureComponent();

    public JComponent getPropertiesView() {
        if (this.propertiesView == null) {
            this.propertiesView = this.createPropertiesComponent();
            this.propertiesView.addPropertyChangeListener(new PropertiesDisplayListener());
        }
        return this.propertiesView;
    }

    public abstract JComponent createPropertiesComponent();

    public void open() {
        if (this.contentView != null) {
            ((PanelView)((Object)this.contentView)).open();
        }
    }

    public boolean canClose() {
        if (this.contentView != null) {
            return ((PanelView)((Object)this.contentView)).canClose();
        }
        return true;
    }

    public boolean setFocusOn(String string, String string2, Object object) {
        if (this.contentView != null) {
            return ((PanelView)((Object)this.contentView)).setFocusOn(string, string2, object);
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("ComponentPanel");
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBase(AbstractDesignEditor.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    static class PropertiesDisplayListener
    implements PropertyChangeListener {
        PropertiesDisplayListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayWritableOnly".equals(propertyChangeEvent.getPropertyName())) {
                // empty if block
            }
        }
    }

    class NodeSelectedListener
    implements PropertyChangeListener {
        NodeSelectedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            Node[] nodeArray = AbstractDesignEditor.this.getExplorerManager().getSelectedNodes();
        }
    }
}

