/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.VersionNotSupportedException;
import org.netbeans.modules.j2ee.sun.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;

public class ServletRef
extends Base {
    public static final String SERVLET_NAME = "servletName";
    public static final String RUN_AS_ROLE_NAME = "runAsRoleName";
    private DDBean servletNameDD;
    private String principalName;
    private String className;
    public static final String FIELD_PRINCIPAL_CLASS_NAME = ":class-name";

    public ServletRef() {
        this.setDescriptorElement(this.bundle.getString("BDN_Servlet"));
    }

    protected void init(DDBean dDBean, Base base) throws ConfigurationException {
        super.init(dDBean, base);
        this.servletNameDD = this.getNameDD("servlet-name");
        this.updateNamedBeanCache("Servlet");
        this.loadFromPlanFile(this.getConfig());
    }

    protected String getComponentName() {
        return this.getServletName();
    }

    protected void updateValidationFieldList() {
        super.updateValidationFieldList();
        this.validationFieldList.add(FIELD_PRINCIPAL_CLASS_NAME);
    }

    public boolean validateField(String string) {
        ValidationError validationError = null;
        boolean bl = true;
        if (string.equals(FIELD_PRINCIPAL_CLASS_NAME)) {
            String string2 = this.getAbsoluteXpath("principal-name/" + string);
            if (Utils.notEmpty(this.className) && !Utils.isJavaClass(this.className)) {
                Object[] objectArray = new Object[]{FIELD_PRINCIPAL_CLASS_NAME};
                String string3 = MessageFormat.format(this.bundle.getString("ERR_InvalidJavaClass"), objectArray);
                validationError = ValidationError.getValidationError(string2, string3);
            } else {
                validationError = ValidationError.getValidationErrorMask(string2);
            }
        }
        if (validationError != null) {
            this.getMessageDB().updateError(validationError);
        }
        return validationError == null || !Utils.notEmpty(validationError.getMessage());
    }

    public String getHelpId() {
        return "AS_CFG_Servlet";
    }

    public String getServletName() {
        return ServletRef.cleanDDBeanText(this.servletNameDD);
    }

    public String getRunAsRoleName() {
        String string = null;
        DDBean[] dDBeanArray = this.getDDBean().getChildBean("run-as/role-name");
        if (dDBeanArray.length > 0) {
            string = dDBeanArray[0].getText();
        }
        return string;
    }

    public void notifyDDChange(XpathEvent xpathEvent) {
        super.notifyDDChange(xpathEvent);
        DDBean dDBean = xpathEvent.getBean();
        if (dDBean == this.servletNameDD) {
            this.getPCS().firePropertyChange(SERVLET_NAME, GenericOldValue, this.getServletName());
            this.getPCS().firePropertyChange("displayName", GenericOldValue, this.getDisplayName());
            this.updateNamedBeanCache("Servlet");
        } else if (dDBean.getXpath().indexOf("run-as") != -1) {
            this.getPCS().firePropertyChange(RUN_AS_ROLE_NAME, GenericOldValue, this.getRunAsRoleName());
        }
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String string) throws PropertyVetoException {
        String string2 = this.principalName;
        this.getVCS().fireVetoableChange("principalName", string2, string);
        this.principalName = string;
        this.getPCS().firePropertyChange("principalName", string2, this.principalName);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) throws PropertyVetoException {
        String string2 = this.className;
        this.getVCS().fireVetoableChange("className", string2, string);
        this.className = string;
        this.getPCS().firePropertyChange("className", string2, this.className);
    }

    Collection getSnippets() {
        ArrayList<1> arrayList = new ArrayList<1>();
        Base.DefaultSnippet defaultSnippet = new Base.DefaultSnippet(){

            public CommonDDBean getDDSnippet() {
                Servlet servlet = ServletRef.this.getConfig().getStorageFactory().createServlet();
                String string = ServletRef.this.getServletName();
                if (string != null) {
                    servlet.setServletName(string);
                }
                if (Utils.notEmpty(ServletRef.this.principalName)) {
                    servlet.setPrincipalName(ServletRef.this.principalName);
                    if (Utils.notEmpty(ServletRef.this.className)) {
                        try {
                            servlet.setPrincipalNameClassName(ServletRef.this.className);
                        }
                        catch (VersionNotSupportedException versionNotSupportedException) {
                            // empty catch block
                        }
                    }
                }
                return servlet;
            }

            public boolean hasDDSnippet() {
                return ServletRef.this.principalName != null && ServletRef.this.principalName.length() > 0;
            }

            public String getPropertyName() {
                return "Servlet";
            }
        };
        arrayList.add(defaultSnippet);
        return arrayList;
    }

    boolean loadFromPlanFile(SunONEDeploymentConfiguration sunONEDeploymentConfiguration) {
        String string = this.getUriText();
        Servlet servlet = (Servlet)sunONEDeploymentConfiguration.getBeans(string, this.constructFileName(), this.getParser(), new ServletRefFinder(this.getServletName()));
        this.clearProperties();
        if (servlet != null) {
            this.principalName = servlet.getPrincipalName();
            try {
                this.className = servlet.getPrincipalNameClassName();
            }
            catch (VersionNotSupportedException versionNotSupportedException) {}
        } else {
            this.setDefaultProperties();
        }
        return servlet != null;
    }

    protected void clearProperties() {
        this.principalName = null;
        this.className = null;
    }

    protected void setDefaultProperties() {
    }

    private static class ServletRefFinder
    extends Base.NameBasedFinder {
        public ServletRefFinder(String string) {
            super("ServletName", string, Servlet.class);
        }
    }
}

