/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.awt.event.ItemEvent;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.SwingUtilities;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.Constants;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.ServiceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Utils
implements Constants {
    private static final String KEYSEPSTR = "|";
    private static final String[] booleanStrings = new String[]{"0", "1", "false", "true", "no", "yes", "off", "on"};

    private Utils() {
    }

    public static String getFQNKey(String string, String string2) {
        String string3 = "";
        if (null != string) {
            string3 = string3 + string;
        }
        if (string3.indexOf(KEYSEPSTR) > -1) {
            throw new IllegalArgumentException("uri");
        }
        string3 = string3 + KEYSEPSTR + string2;
        assert (!string3.equals(KEYSEPSTR));
        return string3;
    }

    public static String getUriFromKey(String string) {
        String string2 = "";
        int n = string.indexOf(KEYSEPSTR);
        if (n > 1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getFilenameFromKey(String string) {
        int n = string.indexOf(KEYSEPSTR);
        String string2 = string.substring(n + 1);
        return string2;
    }

    public static boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean strEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean strEquals(String string, String string2) {
        boolean bl = false;
        bl = string == null ? string2 == null : (string2 == null ? false : string.equals(string2));
        return bl;
    }

    public static boolean strEquivalent(String string, String string2) {
        boolean bl = false;
        if (Utils.strEmpty(string) && Utils.strEmpty(string2)) {
            bl = true;
        } else if (string != null && string2 != null) {
            bl = string.equals(string2);
        }
        return bl;
    }

    public static int strCompareTo(String string, String string2) {
        int n = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
        return n;
    }

    public static boolean hasTrailingSlash(String string) {
        return string.charAt(string.length() - 1) == '/';
    }

    public static boolean containsWhitespace(String string) {
        boolean bl = false;
        if (Utils.notEmpty(string)) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!Character.isSpaceChar(string.charAt(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isJavaIdentifier(String string) {
        boolean bl = true;
        if (!Utils.notEmpty(string) || !Character.isJavaIdentifierStart(string.charAt(0))) {
            bl = false;
        } else {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isJavaPackage(String string) {
        boolean bl = false;
        if (Utils.notEmpty(string)) {
            int n = 0;
            int n2 = string.length();
            block4: for (int i = 0; i < n2 && n < 2; ++i) {
                switch (n) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(string.charAt(i))) {
                            n = 1;
                            continue block4;
                        }
                        n = 2;
                        continue block4;
                    }
                    case 1: {
                        if (string.charAt(i) == '.') {
                            n = 0;
                            continue block4;
                        }
                        if (Character.isJavaIdentifierPart(string.charAt(i))) continue block4;
                        n = 2;
                    }
                }
            }
            if (n == 1) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isJavaClass(String string) {
        return Utils.isJavaPackage(string);
    }

    public static CommonDDBean[] listToArray(List list, Class clazz) {
        int n;
        CommonDDBean[] commonDDBeanArray = null;
        if (list != null && (n = list.size()) != 0) {
            commonDDBeanArray = (CommonDDBean[])Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                CommonDDBean commonDDBean = (CommonDDBean)list.get(i);
                commonDDBeanArray[i] = (CommonDDBean)commonDDBean.clone();
            }
        }
        return commonDDBeanArray;
    }

    public static CommonDDBean[] listToArray(List list, Class clazz, String string) {
        int n;
        CommonDDBean[] commonDDBeanArray = null;
        if (list != null && (n = list.size()) != 0) {
            commonDDBeanArray = (CommonDDBean[])Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                CommonDDBean commonDDBean = (CommonDDBean)list.get(i);
                commonDDBeanArray[i] = commonDDBean.cloneVersion(string);
            }
        }
        return commonDDBeanArray;
    }

    public static List arrayToList(CommonDDBean[] commonDDBeanArray) {
        ArrayList<CommonDDBean> arrayList = null;
        if (commonDDBeanArray != null && commonDDBeanArray.length > 0) {
            arrayList = new ArrayList<CommonDDBean>(commonDDBeanArray.length + 3);
            for (int i = 0; i < commonDDBeanArray.length; ++i) {
                arrayList.add(commonDDBeanArray[i]);
            }
        }
        return arrayList;
    }

    public static boolean booleanValueOf(String string) {
        boolean bl = false;
        int n = -1;
        if (string != null && string.length() > 0) {
            string = string.trim();
            for (int i = 0; i < booleanStrings.length; ++i) {
                if (string.compareToIgnoreCase(booleanStrings[i]) != 0) continue;
                n = i;
                break;
            }
        }
        if (n >= 0 && n % 2 == 1) {
            bl = true;
        }
        return bl;
    }

    public static String encodeUrlField(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.replace(' ', '_');
        }
        if (string2 != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer(string2.length() + 10);
                String[] stringArray = string2.split("/");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(URLEncoder.encode(stringArray[i], "UTF-8"));
                    if (i == stringArray.length - 1) continue;
                    stringBuffer.append("/");
                }
                string2 = stringBuffer.toString();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return string2;
    }

    public static URL getResourceURL(String string, Class clazz) {
        URL uRL = null;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            uRL = uRLClassLoader.findResource(string);
        } else {
            uRL = classLoader.getResource(string);
        }
        return uRL;
    }

    public static void invokeHelp(String string) {
        Utils.invokeHelp(new HelpCtx(string));
    }

    public static void invokeHelp(final HelpCtx helpCtx) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Help)Lookup.getDefault().lookup(Help.class)).showHelp(helpCtx);
            }
        });
    }

    public static boolean interpretCheckboxState(ItemEvent itemEvent) {
        boolean bl = false;
        if (itemEvent.getStateChange() == 1) {
            bl = true;
        } else if (itemEvent.getStateChange() == 2) {
            bl = false;
        }
        return bl;
    }

    static String getDefaultCmpResourceJndiName(EjbJarRoot ejbJarRoot) {
        return "jdo/pmf";
    }

    static ConfigurationException makeCE(String string, Object[] objectArray, Throwable throwable) {
        String string2 = null;
        boolean bl = false;
        try {
            string2 = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.Bundle").getString(string);
        }
        catch (RuntimeException runtimeException) {
            bl = true;
            jsr88Logger.throwing(Utils.class.getName(), "makeCE", runtimeException);
            string2 = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.Bundle").getString("DEF_ConfigurationExceptionFormat");
            int n = 1;
            if (null != objectArray) {
                n += objectArray.length;
            }
            Object[] objectArray2 = new Object[n];
            objectArray2[0] = string;
            for (int i = 1; i < n; ++i) {
                objectArray2[i] = objectArray[i - 1];
            }
            objectArray = objectArray2;
        }
        String string3 = MessageFormat.format(string2, objectArray);
        ConfigurationException configurationException = new ConfigurationException(string3);
        if (null != throwable) {
            configurationException.initCause(throwable);
        }
        if (bl) {
            jsr88Logger.severe(string3);
        }
        return configurationException;
    }

    public static ServiceRef findServiceRef(SunONEDeploymentConfiguration sunONEDeploymentConfiguration, String string) {
        ServiceRef serviceRef = null;
        BaseRoot baseRoot = sunONEDeploymentConfiguration.getMasterDCBRoot();
        if (baseRoot instanceof EjbJarRoot) {
            Iterator iterator = baseRoot.getChildren().iterator();
            while (iterator.hasNext() && serviceRef == null) {
                Object e = iterator.next();
                if (!(e instanceof BaseEjb)) continue;
                Iterator iterator2 = ((BaseEjb)e).getChildren().iterator();
                while (iterator2.hasNext() && serviceRef == null) {
                    ServiceRef serviceRef2;
                    Object e2 = iterator2.next();
                    if (!(e2 instanceof ServiceRef) || !string.equals((serviceRef2 = (ServiceRef)e2).getServiceRefName())) continue;
                    serviceRef = serviceRef2;
                }
            }
        } else {
            for (Object e : baseRoot.getChildren()) {
                ServiceRef serviceRef3;
                if (!(e instanceof ServiceRef) || !string.equals((serviceRef3 = (ServiceRef)e).getServiceRefName())) continue;
                serviceRef = serviceRef3;
                break;
            }
        }
        return serviceRef;
    }
}

