/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ErrorSupportClient;

public class ErrorSupport
implements ErrorSupportClient {
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private List errorList;
    private JPanel errorPanel;
    private JComponent focusedComponent;
    private ErrorSupportClient client;

    public ErrorSupport() {
        this.initialize();
        this.client = this;
    }

    public ErrorSupport(ErrorSupportClient errorSupportClient) {
        this.initialize();
        this.client = errorSupportClient;
    }

    private void initialize() {
        this.errorList = new ArrayList();
        this.errorPanel = null;
        this.focusedComponent = null;
    }

    public void showErrors() {
        Object object;
        this.removeAllErrors();
        Collection collection = this.client.getErrors();
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (!(object2 instanceof String)) continue;
                this.addError((String)object2);
            }
        }
        if ((object = this.client.getErrorPanelParent()) != null) {
            if (this.errorList.size() != 0) {
                if (this.errorPanel == null) {
                    this.errorPanel = new JPanel(new GridBagLayout());
                    ((Container)object).add((Component)this.errorPanel, this.client.getErrorPanelConstraints());
                } else {
                    this.errorPanel.removeAll();
                }
                for (String string : this.errorList) {
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(BaseCustomizer.errorMessageIcon);
                    jLabel.setText(string);
                    jLabel.getAccessibleContext().setAccessibleName(this.bundle.getString("ASCN_ErrorMessage"));
                    jLabel.getAccessibleContext().setAccessibleDescription(string);
                    jLabel.setForeground(this.getMessageForegroundColor());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 1.0;
                    this.errorPanel.add((Component)jLabel, gridBagConstraints);
                }
            } else if (this.errorPanel != null) {
                ((Container)object).remove(this.errorPanel);
                this.errorPanel = null;
            }
            ((Container)object).validate();
        }
    }

    public boolean hasErrors() {
        return this.errorList.size() != 0;
    }

    public void addError(String string) {
        this.errorList.add(string);
    }

    public void addError(JComponent jComponent, String string) {
        this.setFocusedComponent(jComponent);
        this.errorList.add(string);
    }

    public void setFocusedComponent(JComponent jComponent) {
        this.focusedComponent = jComponent;
    }

    public JComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    public void removeAllErrors() {
        this.errorList.clear();
        this.focusedComponent = null;
    }

    public Collection getErrors() {
        return null;
    }

    public Container getErrorPanelParent() {
        return null;
    }

    public GridBagConstraints getErrorPanelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 11, 11);
        return gridBagConstraints;
    }

    public Color getMessageForegroundColor() {
        return BaseCustomizer.getErrorForegroundColor();
    }
}

