/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.CharsetMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.ParamMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.ParamType;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyList;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyParam;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.LocaleMapping;

public class DynamicPropertyPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private boolean isEditPopup;
    private PropertyList theList;
    private List paramMappings;
    private boolean hasDescription;
    private boolean isEditable;
    private JLabel nameRequiredMark;
    private JLabel nameLabel;
    private JLabel valueRequiredMark;
    private JLabel valueLabel;
    private JComboBox propertiesCombo;
    private JComponent customEditor;
    private JTextField descriptionField;
    private JTextField customTextField;
    private JComboBox customComboBox;
    private JCheckBox customCheckBox;
    private int normalizedHeight;
    private DefaultComboBoxModel propertyListModel;
    private String name;
    private ParamMapping nameMapping;
    private String value;
    private String description;
    private final ResourceBundle localBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private ResourceBundle propertyListBundle;
    private static final String TEXT_TRUE = "true";
    private static final String TEXT_FALSE = "false";
    private static final int NAME_FIELD = 0;
    private static final int VALUE_FIELD = 1;
    private static final int DESCRIPTION_FIELD = 2;
    private static final int NUM_FIELDS_NO_DESCRIPTION = 2;
    private static final int NUM_FIELDS_WITH_DESCRIPTION = 3;

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private void initUserComponents() {
        Object object;
        this.customTextField = new JTextField();
        this.customComboBox = new JComboBox();
        this.customCheckBox = new JCheckBox();
        this.nameRequiredMark = new JLabel();
        this.nameLabel = new JLabel();
        this.propertiesCombo = new JComboBox();
        this.valueRequiredMark = new JLabel();
        this.valueLabel = new JLabel();
        this.customEditor = this.customTextField;
        int n = this.customTextField.getPreferredSize().height;
        int n2 = this.customComboBox.getPreferredSize().height;
        int n3 = this.customCheckBox.getPreferredSize().height;
        this.normalizedHeight = Math.max(n, Math.max(n2, n3));
        this.nameRequiredMark.setText(this.localBundle.getString("LBL_RequiredMark"));
        this.nameRequiredMark.setLabelFor(this.propertiesCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.nameRequiredMark.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_RequiredMark"));
        this.nameRequiredMark.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_RequiredMark"));
        this.add((Component)this.nameRequiredMark, gridBagConstraints);
        this.nameLabel.setText(this.localBundle.getString("LBL_Name_1"));
        this.nameLabel.setDisplayedMnemonic(this.localBundle.getString("MNE_Name").charAt(0));
        this.nameLabel.setLabelFor(this.propertiesCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.propertiesCombo.setEditable(this.isEditable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 11);
        gridBagConstraints.weightx = 1.0;
        this.propertiesCombo.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_Name"));
        this.propertiesCombo.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_Name"));
        this.add((Component)this.propertiesCombo, gridBagConstraints);
        this.propertiesCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DynamicPropertyPanel.this.handlePropertiesComboActionPerformed(actionEvent);
            }
        });
        int n4 = this.hasDescription ? 0 : 11;
        this.valueRequiredMark.setText(this.localBundle.getString("LBL_RequiredMark"));
        this.valueRequiredMark.setLabelFor(this.customEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, n4, 0);
        this.valueRequiredMark.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_RequiredMark"));
        this.valueRequiredMark.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_RequiredMark"));
        this.add((Component)this.valueRequiredMark, gridBagConstraints);
        this.valueLabel.setText(this.localBundle.getString("LBL_Value_1"));
        this.valueLabel.setDisplayedMnemonic(this.localBundle.getString("MNE_Value").charAt(0));
        this.valueLabel.setLabelFor(this.customEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, n4, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        int n5 = this.normalizedHeight - n;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n7 + 6, 6, n6 + n4, 11);
        gridBagConstraints.weightx = 1.0;
        this.customTextField.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_Value"));
        this.customTextField.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_Value"));
        this.customComboBox.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_Value"));
        this.customComboBox.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_Value"));
        this.customCheckBox.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_Value"));
        this.customCheckBox.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_Value"));
        this.add((Component)this.customEditor, gridBagConstraints);
        if (this.hasDescription) {
            object = new JLabel();
            JLabel jLabel = new JLabel();
            this.descriptionField = new JTextField();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 12, 11, 0);
            this.add((Component)object, gridBagConstraints);
            jLabel.setText(this.localBundle.getString("LBL_Description_1"));
            jLabel.setDisplayedMnemonic(this.localBundle.getString("MNE_Description").charAt(0));
            jLabel.setLabelFor(this.descriptionField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 11, 0);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 11, 11);
            gridBagConstraints.weightx = 1.0;
            this.descriptionField.getAccessibleContext().setAccessibleName(this.localBundle.getString("ACSN_Description"));
            this.descriptionField.getAccessibleContext().setAccessibleDescription(this.localBundle.getString("ACSD_Description"));
            this.add((Component)this.descriptionField, gridBagConstraints);
            this.descriptionField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    DynamicPropertyPanel.this.handleDescriptionFieldKeyReleased(keyEvent);
                }
            });
        }
        this.customTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                DynamicPropertyPanel.this.handleCustomTextFieldKeyReleased(keyEvent);
            }
        });
        this.customCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DynamicPropertyPanel.this.handleCustomCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.customComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DynamicPropertyPanel.this.handleCustomComboBoxActionPerformed(actionEvent);
            }
        });
        this.buildMappings();
        this.propertyListModel = new DefaultComboBoxModel();
        object = this.paramMappings.iterator();
        while (object.hasNext()) {
            this.propertyListModel.addElement((ParamMapping)object.next());
        }
        this.propertiesCombo.setModel(this.propertyListModel);
    }

    private void handleCustomTextFieldKeyReleased(KeyEvent keyEvent) {
        if (this.customEditor == this.customTextField) {
            this.value = this.customTextField.getText();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handleCustomCheckBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.customEditor == this.customCheckBox) {
            this.value = Utils.interpretCheckboxState(itemEvent) ? TEXT_TRUE : TEXT_FALSE;
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handleCustomComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.customEditor == this.customComboBox && "comboBoxChanged".equals(actionEvent.getActionCommand())) {
            Object object = this.customComboBox.getSelectedItem();
            if (object instanceof String) {
                this.value = (String)object;
            } else if (object instanceof CharsetMapping) {
                this.value = ((CharsetMapping)object).getCharset().toString();
            } else if (object instanceof LocaleMapping) {
                this.value = ((LocaleMapping)object).getLocale().toString();
            }
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handleDescriptionFieldKeyReleased(KeyEvent keyEvent) {
        if (this.hasDescription) {
            this.description = this.descriptionField.getText();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handlePropertiesComboActionPerformed(ActionEvent actionEvent) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            Object object = this.propertyListModel.getSelectedItem();
            if (object instanceof ParamMapping) {
                this.nameMapping = (ParamMapping)object;
                this.selectProperty(this.nameMapping);
            } else if (object instanceof String) {
                this.nameMapping = null;
                this.name = (String)object;
                if (this.propertyListModel.getIndexOf(object) == -1) {
                    this.propertyListModel.addElement(object);
                }
                this.enableTextFields(true);
                this.displayCustomEditor(this.customTextField);
            }
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void selectProperty(ParamMapping paramMapping) {
        PropertyParam propertyParam = paramMapping.getParam();
        if (propertyParam != null) {
            Object object;
            ParamType paramType = propertyParam.getParamType();
            String string = paramType.getType();
            this.enableTextFields(true);
            this.valueRequiredMark.setText(paramType.getRequired().equals(TEXT_TRUE) ? this.localBundle.getString("LBL_RequiredMark") : "");
            String string2 = propertyParam.getParamLabel();
            if (string2 != null) {
                this.valueLabel.setText(this.propertyListBundle.getString(string2) + " :");
            } else {
                this.valueLabel.setText(this.localBundle.getString("LBL_Value_1"));
            }
            this.value = propertyParam.getDefaultValue();
            if (string.equals("boolean")) {
                this.customCheckBox.setSelected(this.value.equals(TEXT_TRUE));
                this.displayCustomEditor(this.customCheckBox);
            } else if (string.equals("text")) {
                this.customTextField.setText(this.value);
                this.customTextField.setCaretPosition(0);
                this.displayCustomEditor(this.customTextField);
            } else if (string.equals("number")) {
                this.customTextField.setText(this.value);
                this.customTextField.setCaretPosition(0);
                this.displayCustomEditor(this.customTextField);
            } else if (string.equals("list")) {
                object = new DefaultComboBoxModel();
                Object object2 = this.value;
                if (paramType.isParamCharset()) {
                    SortedMap sortedMap = CharsetMapping.getSortedAvailableCharsetMappings();
                    Iterator iterator = sortedMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        CharsetMapping charsetMapping = (CharsetMapping)iterator.next().getValue();
                        ((DefaultComboBoxModel)object).addElement(charsetMapping);
                    }
                    object2 = this.value != null ? CharsetMapping.getCharsetMapping(this.value) : CharsetMapping.getCharsetMapping("UTF8");
                } else if (paramType.isParamLocale()) {
                    SortedMap sortedMap = LocaleMapping.getSortedAvailableLocaleMappings();
                    Iterator iterator = sortedMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        LocaleMapping localeMapping = (LocaleMapping)iterator.next().getValue();
                        ((DefaultComboBoxModel)object).addElement(localeMapping);
                    }
                    object2 = this.value != null ? LocaleMapping.getLocaleMapping(this.value) : LocaleMapping.getLocaleMapping(Locale.getDefault());
                } else {
                    int n = paramType.sizeParamValue();
                    for (int i = 0; i < n; ++i) {
                        ((DefaultComboBoxModel)object).addElement(paramType.getParamValue(i));
                    }
                    if (object2 == null) {
                        object2 = ((DefaultComboBoxModel)object).getElementAt(0);
                    }
                }
                this.customComboBox.setModel(object);
                this.customComboBox.setEditable(paramType.getEditable().equals(TEXT_TRUE));
                this.customComboBox.setSelectedItem(object2);
                this.displayCustomEditor(this.customComboBox);
            }
            if (this.hasDescription && (object = propertyParam.getParamDescription()) != null) {
                this.description = this.propertyListBundle.getString((String)object);
                this.descriptionField.setText(this.description);
                this.descriptionField.setCaretPosition(0);
            }
        } else {
            this.enableTextFields(false);
            this.displayCustomEditor(this.customTextField);
        }
    }

    private void buildMappings() {
        List list = this.theList.fetchPropertyParamList();
        this.paramMappings = new ArrayList(list.size() + 1);
        if (!this.isEditable) {
            this.paramMappings.add(new ParamMapping(null));
        }
        for (PropertyParam propertyParam : list) {
            this.paramMappings.add(new ParamMapping(propertyParam));
        }
    }

    private void displayCustomEditor(JComponent jComponent) {
        if (this.customEditor != jComponent) {
            int n = this.normalizedHeight - jComponent.getPreferredSize().height;
            int n2 = n / 2;
            int n3 = n - n2;
            int n4 = this.hasDescription ? 0 : 11;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(n3 + 6, 6, n2 + n4, 11);
            gridBagConstraints.weightx = 1.0;
            this.valueRequiredMark.setLabelFor(jComponent);
            this.valueLabel.setLabelFor(jComponent);
            int n5 = this.componentIndexOf(this.customEditor);
            this.remove(this.customEditor);
            this.add(jComponent, gridBagConstraints, n5);
            Window window = this.getParentWindow();
            if (window != null) {
                window.pack();
            }
            Rectangle rectangle = jComponent.getBounds(null);
            rectangle.y -= n3;
            rectangle.height += n;
            this.repaint(rectangle);
            this.customEditor = jComponent;
        }
    }

    private int componentIndexOf(JComponent jComponent) {
        int n = -1;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (jComponent != componentArray[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    private void enableTextFields(boolean bl) {
        this.value = null;
        this.customTextField.setText(this.value);
        this.customTextField.setEditable(bl);
        this.customTextField.setEnabled(bl);
        if (this.hasDescription) {
            this.description = null;
            this.descriptionField.setText(this.description);
            this.descriptionField.setEditable(bl);
            this.descriptionField.setEnabled(bl);
        }
    }

    private Window getParentWindow() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    public void init(ASDDVersion aSDDVersion, int n, List list, Object object) {
        this.theList = (PropertyList)object;
        this.hasDescription = this.theList.getDescription().equals(TEXT_TRUE);
        this.isEditable = this.theList.getEditable().equals(TEXT_TRUE);
        String string = this.theList.getBundlePath();
        if (string != null) {
            this.propertyListBundle = ResourceBundle.getBundle(string);
        }
        this.initComponents();
        this.initUserComponents();
        this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
        if (!this.isEditable) {
            this.selectProperty((ParamMapping)this.paramMappings.get(0));
        }
    }

    public Object[] getValues() {
        PropertyParam propertyParam;
        Object[] objectArray = this.hasDescription ? new Object[3] : new Object[2];
        objectArray[0] = this.nameMapping != null ? ((propertyParam = this.nameMapping.getParam()) != null ? propertyParam.getParamName() : "") : this.name;
        objectArray[1] = this.value;
        if (this.hasDescription) {
            objectArray[2] = this.description;
        }
        return objectArray;
    }

    public void setValues(Object[] objectArray) {
        ParamMapping paramMapping;
        if (objectArray == null) {
            objectArray = new Object[this.hasDescription ? 3 : 2];
            objectArray[0] = null;
            objectArray[1] = null;
            if (this.hasDescription) {
                objectArray[2] = null;
            }
            this.isEditPopup = false;
        } else {
            this.isEditPopup = true;
        }
        this.name = (String)objectArray[0];
        this.nameMapping = null;
        if (this.name != null && this.name.length() > 0) {
            for (ParamMapping paramMapping2 : this.paramMappings) {
                PropertyParam propertyParam = paramMapping2.getParam();
                if (propertyParam == null || !this.name.equals(propertyParam.getParamName())) continue;
                this.nameMapping = paramMapping2;
                break;
            }
        } else if (this.paramMappings.size() > 0 && (paramMapping = (ParamMapping)this.paramMappings.get(0)).getParam() == null) {
            this.nameMapping = paramMapping;
        }
        if (this.nameMapping != null) {
            this.propertiesCombo.setSelectedItem(this.nameMapping);
        } else {
            this.propertiesCombo.setSelectedItem(this.name);
        }
        if (this.isEditPopup) {
            this.propertiesCombo.setEnabled(false);
            this.value = (String)objectArray[1];
            if (this.customEditor == this.customCheckBox) {
                this.customCheckBox.setSelected(Utils.booleanValueOf(this.value));
            } else if (this.customEditor == this.customTextField) {
                this.customTextField.setText(this.value);
                this.customTextField.setCaretPosition(0);
            } else if (this.customEditor == this.customComboBox) {
                this.customComboBox.setSelectedItem(this.value);
            }
            if (this.hasDescription) {
                this.description = (String)objectArray[2];
                this.descriptionField.setText(this.description);
                this.descriptionField.setCaretPosition(0);
            }
        }
    }

    public boolean requiredFieldsFilled() {
        return true;
    }

    public Collection getErrors(ValidationSupport validationSupport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.hasEmptyName()) {
            arrayList.add(this.localBundle.getString("ERR_NameFieldIsEmpty"));
        } else if (this.nameMapping != null) {
            if (this.value == null || this.value.length() == 0) {
                Object[] objectArray = new Object[]{this.localBundle.getString("LBL_Value")};
                arrayList.add(MessageFormat.format(this.localBundle.getString("ERR_SpecifiedFieldIsEmpty"), objectArray));
            } else {
                PropertyParam propertyParam = this.nameMapping.getParam();
                ParamType paramType = propertyParam.getParamType();
                String string = paramType.getType();
                String string2 = propertyParam.getParamName();
                if (string.equals("text")) {
                    this.validate(this.value, propertyParam.getParamValidator(), string2, arrayList);
                } else if (string.equals("number")) {
                    this.validateNumber(this.value, paramType.getParamMin(), paramType.getParamMax(), arrayList);
                } else if (string.equals("list")) {
                    this.validate(this.value, propertyParam.getParamValidator(), string2, arrayList);
                }
            }
        }
        return arrayList;
    }

    private boolean hasEmptyName() {
        boolean bl = true;
        if (this.nameMapping != null && this.nameMapping.getParam() != null) {
            bl = false;
        } else if (this.nameMapping == null && this.name != null && this.name.length() > 0) {
            bl = false;
        }
        return bl;
    }

    private void validateNumber(String string, String string2, String string3, List list) {
        try {
            Object[] objectArray;
            long l = Long.parseLong(string);
            long l2 = Long.MIN_VALUE;
            long l3 = Long.MAX_VALUE;
            if (string2 != null && l < (l2 = Long.parseLong(string2))) {
                objectArray = new Object[]{string, Long.toString(l2)};
                list.add(MessageFormat.format(this.localBundle.getString("ERR_NumberTooLow"), objectArray));
            }
            if (string3 != null && l > (l3 = Long.parseLong(string3))) {
                objectArray = new Object[]{string, Long.toString(l3)};
                list.add(MessageFormat.format(this.localBundle.getString("ERR_NumberTooHigh"), objectArray));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{string};
            list.add(MessageFormat.format(this.localBundle.getString("ERR_NumberInvalid"), objectArray));
        }
    }

    private void validate(String string, String string2, String string3, List list) {
        Pattern pattern;
        if (string2 != null && (pattern = PropertyListMapping.getValidator(string2)) != null && !pattern.matcher(string).matches()) {
            Object[] objectArray = new Object[]{string3, string2};
            String string4 = this.localBundle.getString("ERR_PropertyValueInvalid");
            list.add(MessageFormat.format(string4, objectArray));
        }
    }
}

