/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;
import org.openide.util.NbBundle;

public class CacheGeneralPanel
extends JPanel
implements TableModelListener {
    private final ResourceBundle webappBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private final ResourceBundle commonBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private WebAppRootCustomizer masterPanel;
    private GenericTableModel propertiesModel;
    private GenericTablePanel propertiesPanel;
    private JCheckBox jChkCacheEnabled;
    private JLabel jLblCacheSettings;
    private JLabel jLblMaxEntries;
    private JLabel jLblTimeout;
    private JPanel jPnlCacheGeneral;
    private JTextField jTxtMaxEntries;
    private JTextField jTxtTimeout;

    public CacheGeneralPanel(WebAppRootCustomizer webAppRootCustomizer) {
        this.masterPanel = webAppRootCustomizer;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jPnlCacheGeneral = new JPanel();
        this.jLblCacheSettings = new JLabel();
        this.jChkCacheEnabled = new JCheckBox();
        this.jLblMaxEntries = new JLabel();
        this.jTxtMaxEntries = new JTextField();
        this.jLblTimeout = new JLabel();
        this.jTxtTimeout = new JTextField();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_CacheGeneralTab"));
        this.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_CacheGeneralTab"));
        this.jPnlCacheGeneral.setLayout(new GridBagLayout());
        this.jLblCacheSettings.setText(this.webappBundle.getString("LBL_CacheSettings"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlCacheGeneral.add((Component)this.jLblCacheSettings, gridBagConstraints);
        this.jChkCacheEnabled.setText(this.webappBundle.getString("LBL_CacheEnabled"));
        this.jChkCacheEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CacheGeneralPanel.this.jChkCacheEnabledItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.jPnlCacheGeneral.add((Component)this.jChkCacheEnabled, gridBagConstraints);
        this.jChkCacheEnabled.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_CacheEnabled"));
        this.jChkCacheEnabled.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_CacheEnabled"));
        this.jLblMaxEntries.setLabelFor(this.jTxtMaxEntries);
        this.jLblMaxEntries.setText(this.webappBundle.getString("LBL_MaximumEntries_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlCacheGeneral.add((Component)this.jLblMaxEntries, gridBagConstraints);
        this.jTxtMaxEntries.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CacheGeneralPanel.this.jTxtMaxEntriesKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.jPnlCacheGeneral.add((Component)this.jTxtMaxEntries, gridBagConstraints);
        this.jTxtMaxEntries.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_MaximumEntries"));
        this.jTxtMaxEntries.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_MaximumEntries"));
        this.jLblTimeout.setLabelFor(this.jTxtTimeout);
        this.jLblTimeout.setText(this.webappBundle.getString("LBL_Timeout_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.jPnlCacheGeneral.add((Component)this.jLblTimeout, gridBagConstraints);
        this.jTxtTimeout.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CacheGeneralPanel.this.jTxtTimeoutKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.jPnlCacheGeneral.add((Component)this.jTxtTimeout, gridBagConstraints);
        this.jTxtTimeout.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_Timeout"));
        this.jTxtTimeout.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_Timeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPnlCacheGeneral, gridBagConstraints);
    }

    private void jChkCacheEnabledItemStateChanged(ItemEvent itemEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            WebAppCache webAppCache = webAppRoot.getCacheBean();
            try {
                boolean bl = Utils.interpretCheckboxState(itemEvent);
                webAppCache.setCacheEnabled(Boolean.toString(bl));
            }
            catch (PropertyVetoException propertyVetoException) {
                this.jChkCacheEnabled.setSelected(Utils.booleanValueOf(webAppCache.getCacheEnabled()));
            }
        }
    }

    private void jTxtMaxEntriesKeyReleased(KeyEvent keyEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            WebAppCache webAppCache = webAppRoot.getCacheBean();
            try {
                webAppCache.setCacheMaxEntries(this.jTxtMaxEntries.getText());
                webAppCache.validateField(":max-entries");
            }
            catch (PropertyVetoException propertyVetoException) {
                this.jTxtMaxEntries.setText(webAppCache.getCacheMaxEntries());
            }
        }
    }

    private void jTxtTimeoutKeyReleased(KeyEvent keyEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            WebAppCache webAppCache = webAppRoot.getCacheBean();
            try {
                webAppCache.setTimeoutInSeconds(this.jTxtTimeout.getText());
                webAppCache.validateField(":timeout");
            }
            catch (PropertyVetoException propertyVetoException) {
                this.jTxtTimeout.setText(webAppCache.getTimeoutInSeconds());
            }
        }
    }

    private void initUserComponents() {
        ArrayList<GenericTableModel.TableEntry> arrayList = new ArrayList<GenericTableModel.TableEntry>(3);
        arrayList.add(new GenericTableModel.AttributeEntry("Name", this.commonBundle.getString("LBL_Name"), true));
        arrayList.add(new GenericTableModel.AttributeEntry("Value", this.commonBundle.getString("LBL_Value"), true));
        arrayList.add(new GenericTableModel.ValueEntry("Description", this.commonBundle.getString("LBL_Description")));
        this.propertiesModel = new GenericTableModel(WebAppRootCustomizer.webPropertyFactory, arrayList);
        this.propertiesPanel = new GenericTablePanel(this.propertiesModel, this.webappBundle, "CacheProperties", DynamicPropertyPanel.class, "AS_CFG_WebAppCacheProperty", PropertyListMapping.getPropertyList("CacheProperties"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.propertiesPanel, gridBagConstraints);
    }

    public void addListeners() {
        this.propertiesModel.addTableModelListener(this);
    }

    public void removeListeners() {
        this.propertiesModel.removeTableModelListener(this);
    }

    public void initFields(WebAppCache webAppCache) {
        this.jTxtMaxEntries.setText(webAppCache.getCacheMaxEntries());
        this.jTxtTimeout.setText(webAppCache.getTimeoutInSeconds());
        this.jChkCacheEnabled.setSelected(Utils.booleanValueOf(webAppCache.getCacheEnabled()));
        this.propertiesPanel.setModel(webAppCache.getProperties(), webAppCache.getParent().getAppServerVersion());
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            WebAppCache webAppCache = webAppRoot.getCacheBean();
            try {
                webAppCache.setProperties(this.propertiesModel.getData());
                webAppRoot.setDirty();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

