/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.AccessControllerFactoryRegistry;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEventManager;
import org.netbeans.modules.vmd.api.model.PresenterListener;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TransactionManager;
import org.netbeans.modules.vmd.api.model.common.ValidatorPresenter;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListenerManager {
    private static final boolean INVOKE_VALIDATORS = true;
    private volatile long eventID = 0L;
    private final DesignDocument document;
    private final WeakHashMap<DesignListener, DesignEventFilter> listeners = new WeakHashMap();
    private HashSet<DesignComponent> descriptorChangedComponents;
    private ArrayList<PresenterItem> presenterItems;
    private HashSet<DesignComponent> fullyComponents;
    private HashSet<DesignComponent> fullyHierarchies;
    private HashSet<DesignComponent> partlyComponents;
    private HashSet<DesignComponent> partlyHieararchies;
    private boolean selectionChanged;
    private HashMap<DesignComponent, HashMap<String, PropertyValue>> oldPropertyValues;
    private Set<DesignComponent> createdComponents;
    private List<AccessController> controllers;
    private PresenterEventManager presenterEventManager;

    public long getDocumentState() {
        return this.eventID;
    }

    ListenerManager(DesignDocument designDocument) {
        this.document = designDocument;
        this.clearCaches();
        this.controllers = AccessControllerFactoryRegistry.createAccessControllers(designDocument);
        this.presenterEventManager = new PresenterEventManager();
    }

    private void clearCaches() {
        this.descriptorChangedComponents = new HashSet();
        this.presenterItems = new ArrayList(100);
        this.fullyComponents = new HashSet(100);
        this.fullyHierarchies = new HashSet(100);
        this.partlyComponents = new HashSet(100);
        this.partlyHieararchies = new HashSet(100);
        this.oldPropertyValues = new HashMap(100);
        this.createdComponents = new HashSet<DesignComponent>(100);
        this.selectionChanged = false;
    }

    public <T extends AccessController> T getAccessController(Class<T> clazz) {
        if (clazz != null) {
            for (AccessController accessController : this.controllers) {
                if (!clazz.isInstance(accessController)) continue;
                return (T)accessController;
            }
        }
        return null;
    }

    public void addDesignListener(DesignListener designListener, DesignEventFilter designEventFilter) {
        assert (designListener != null && designEventFilter != null);
        this.listeners.put(designListener, designEventFilter);
    }

    public void removeDesignListener(DesignListener designListener) {
        assert (designListener != null);
        this.listeners.remove(designListener);
    }

    void addComponentDescriptorChanged(DesignComponent designComponent, Collection<? extends Presenter> collection, Collection<Presenter> collection2) {
        assert (Debug.isFriend(TransactionManager.class, "componentDescriptorChangeHappened"));
        this.descriptorChangedComponents.add(designComponent);
        if (collection2 != null) {
            for (Presenter presenter : collection2) {
                presenter.setNotifyAttached(designComponent);
            }
        }
        this.presenterItems.add(new PresenterItem(designComponent, collection));
    }

    void addAffectedDesignComponent(DesignComponent designComponent, String string, PropertyValue propertyValue) {
        assert (Debug.isFriend(TransactionManager.class, "writePropertyHappened"));
        this.fullyComponents.add(designComponent);
        HashMap<String, PropertyValue> hashMap = this.oldPropertyValues.get(designComponent);
        if (hashMap == null) {
            hashMap = new HashMap(100);
            this.oldPropertyValues.put(designComponent, hashMap);
        }
        if (!hashMap.containsKey(string)) {
            hashMap.put(string, propertyValue);
        }
    }

    void addAffectedComponentHierarchy(DesignComponent designComponent) {
        assert (Debug.isFriend(TransactionManager.class, "rootChangeHappened") || Debug.isFriend(TransactionManager.class, "parentChangeHappened"));
        this.fullyHierarchies.add(designComponent);
    }

    void notifyComponentCreated(DesignComponent designComponent) {
        assert (Debug.isFriend(DesignDocument.class, "createRawComponent"));
        this.createdComponents.add(designComponent);
    }

    void setSelectionChanged() {
        assert (Debug.isFriend(TransactionManager.class, "selectComponentsHappened"));
        this.selectionChanged = true;
    }

    long getEventID() {
        return this.eventID;
    }

    DesignEvent fireEvent() {
        Object object;
        assert (Debug.isFriend(TransactionManager.class, "writeAccessRootEnd"));
        if (!this.selectionChanged && this.descriptorChangedComponents.isEmpty() && this.fullyComponents.isEmpty() && this.fullyHierarchies.isEmpty()) {
            return null;
        }
        Object object2 = this.fullyComponents.iterator();
        while (object2.hasNext()) {
            for (object = object2.next(); object != null && this.partlyComponents.add((DesignComponent)object); object = ((DesignComponent)object).getParentComponent()) {
            }
        }
        object2 = this.fullyHierarchies.iterator();
        while (object2.hasNext()) {
            for (object = object2.next(); object != null && this.partlyHieararchies.add((DesignComponent)object); object = ((DesignComponent)object).getParentComponent()) {
            }
        }
        object2 = Collections.unmodifiableSet(this.fullyComponents);
        object = Collections.unmodifiableSet(this.partlyComponents);
        Set<DesignComponent> set = Collections.unmodifiableSet(this.fullyHierarchies);
        Set<DesignComponent> set2 = Collections.unmodifiableSet(this.partlyHieararchies);
        Set<DesignComponent> set3 = Collections.unmodifiableSet(this.descriptorChangedComponents);
        Set<DesignComponent> set4 = Collections.unmodifiableSet(this.createdComponents);
        final DesignEvent designEvent = new DesignEvent(++this.eventID, (Set<DesignComponent>)object2, (Set<DesignComponent>)object, set, set2, set3, set4, this.oldPropertyValues, this.selectionChanged);
        this.fireEventInWriteAccess(designEvent, new Runnable(){

            public void run() {
                ListenerManager.this.fireEventCore(designEvent);
            }
        });
        return designEvent;
    }

    private void fireEventInWriteAccess(DesignEvent designEvent, final Runnable runnable) {
        final boolean[] blArray = new boolean[1];
        final int[] nArray = new int[1];
        final Runnable[] runnableArray = new Runnable[1];
        blArray[0] = false;
        nArray[0] = 0;
        runnableArray[0] = new Runnable(){

            public void run() {
                if (blArray[0]) {
                    Debug.warning("AccessController.writeAccess must run the runnable no more than once", ListenerManager.this.controllers.get(nArray[0] - 1));
                    return;
                }
                if (nArray[0] >= ListenerManager.this.controllers.size()) {
                    blArray[0] = true;
                    runnable.run();
                    return;
                }
                AccessController accessController = (AccessController)ListenerManager.this.controllers.get(nArray[0]);
                nArray[0] = nArray[0] + 1;
                try {
                    accessController.writeAccess(runnableArray[0]);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(throwable);
                }
                if (!blArray[0]) {
                    Debug.warning("AccessController.writeAccess must run the runnable once", accessController);
                    nArray[0] = nArray[0] + 1;
                    this.run();
                }
            }
        };
        for (AccessController accessController : this.controllers) {
            try {
                accessController.notifyEventFiring(designEvent);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(throwable);
            }
        }
        runnableArray[0].run();
        for (AccessController accessController : this.controllers) {
            try {
                accessController.notifyEventFired(designEvent);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(throwable);
            }
        }
    }

    private void fireEventCore(DesignEvent designEvent) {
        for (PresenterItem arrayList2 : this.presenterItems) {
            DesignComponent designComponent = arrayList2.component;
            if (arrayList2.presentersToRemove == null) continue;
            for (Object object : arrayList2.presentersToRemove) {
                try {
                    ((Presenter)object).setNotifyDetached(designComponent);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(throwable);
                }
            }
        }
        Collection<DesignComponent> collection = Collections.unmodifiableCollection(this.createdComponents);
        for (AccessController accessController : this.controllers) {
            try {
                accessController.notifyComponentsCreated(collection);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(throwable);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry<DesignListener, DesignEventFilter> entry : this.listeners.entrySet()) {
            DesignEventFilter designEventFilter;
            Object object;
            object = entry.getKey();
            if (object == null || !(designEventFilter = entry.getValue()).isAffected(this.document, designEvent)) continue;
            arrayList.add(object);
        }
        boolean bl = !this.presenterItems.isEmpty();
        this.clearCaches();
        ListenerManager.invokeValidators(designEvent);
        this.presenterEventManager.prepare(bl);
        for (Object object : arrayList) {
            try {
                object.designChanged(designEvent);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(throwable);
            }
        }
        this.presenterEventManager.execute();
    }

    private static void invokeValidators(DesignEvent designEvent) {
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        ListenerManager.invokeValidatorsCore(designEvent.getPartlyAffectedComponents(), hashSet);
        ListenerManager.invokeValidatorsCore(designEvent.getPartlyAffectedHierarchies(), hashSet);
        ListenerManager.invokeValidatorsCore(designEvent.getDescriptorChangedComponents(), hashSet);
    }

    private static void invokeValidatorsCore(Set<DesignComponent> set, HashSet<DesignComponent> hashSet) {
        for (DesignComponent designComponent : set) {
            if (hashSet.contains(designComponent)) continue;
            ValidatorPresenter validatorPresenter = designComponent.getPresenter(ValidatorPresenter.class);
            try {
                if (validatorPresenter != null) {
                    validatorPresenter.checkValidity();
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hashSet.add(designComponent);
        }
    }

    public void addPresenterListener(DesignComponent designComponent, Class<? extends Presenter> clazz, PresenterListener presenterListener) {
        this.presenterEventManager.addPresenterListener(designComponent, clazz, presenterListener);
    }

    public void removePresenterListener(DesignComponent designComponent, Class<? extends Presenter> clazz, PresenterListener presenterListener) {
        this.presenterEventManager.removePresenterListener(designComponent, clazz, presenterListener);
    }

    void firePresenterChanged(DynamicPresenter dynamicPresenter) {
        assert (Debug.isFriend(DynamicPresenter.class, "firePresenterChanged"));
        this.presenterEventManager.firePresenterChanged(dynamicPresenter.getPresenterListener());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PresenterItem {
        private final DesignComponent component;
        private final Collection<? extends Presenter> presentersToRemove;

        PresenterItem(DesignComponent designComponent, Collection<? extends Presenter> collection) {
            this.component = designComponent;
            this.presentersToRemove = collection;
        }
    }
}

